/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.displayer.client;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.dashbuilder.common.client.StringUtils;
import org.dashbuilder.displayer.DisplayerSettings;
import org.dashbuilder.displayer.DisplayerSubType;
import org.dashbuilder.displayer.DisplayerType;
import org.dashbuilder.displayer.client.RendererLibrary;
import org.dashbuilder.displayer.client.resources.i18n.CommonConstants;
import org.dashbuilder.renderer.RendererSettings;
import org.dashbuilder.renderer.service.RendererSettingsService;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.ioc.client.api.EntryPoint;
import org.jboss.errai.ioc.client.container.SyncBeanDef;
import org.jboss.errai.ioc.client.container.SyncBeanManager;

@EntryPoint
@ApplicationScoped
public class RendererManager {
    private SyncBeanManager beanManager;
    private List<RendererLibrary> renderersList;
    private Map<DisplayerType, RendererLibrary> renderersDefault = new EnumMap<DisplayerType, RendererLibrary>(DisplayerType.class);
    private Map<DisplayerType, List<RendererLibrary>> renderersByType = new EnumMap<DisplayerType, List<RendererLibrary>>(DisplayerType.class);
    private Map<DisplayerSubType, List<RendererLibrary>> renderersBySubType = new EnumMap<DisplayerSubType, List<RendererLibrary>>(DisplayerSubType.class);
    CommonConstants i18n = CommonConstants.INSTANCE;
    Caller<RendererSettingsService> rendererSettingsService;

    public RendererManager() {
    }

    @Inject
    public RendererManager(SyncBeanManager beanManager, Caller<RendererSettingsService> rendererSettingsService) {
        this.beanManager = beanManager;
        this.rendererSettingsService = rendererSettingsService;
    }

    @PostConstruct
    protected void init() {
        ((RendererSettingsService)this.rendererSettingsService.call(settings -> this.lookupRenderers((RendererSettings)settings))).getSettings();
    }

    protected void lookupRenderers(RendererSettings settings) {
        String defaultUUID = settings.getDefaultRenderer();
        boolean onlyOffline = settings.isOffline();
        this.renderersList = new ArrayList<RendererLibrary>();
        Collection beanDefs = this.beanManager.lookupBeans(RendererLibrary.class);
        if (onlyOffline) {
            beanDefs = beanDefs.stream().filter(bd -> ((RendererLibrary)bd.getInstance()).isOffline()).collect(Collectors.toList());
        }
        if (defaultUUID != null && !defaultUUID.isEmpty()) {
            beanDefs.stream().map(SyncBeanDef::getInstance).filter(render -> render.getUUID().equals(defaultUUID)).findFirst().ifPresent(rend -> rend.getSupportedTypes().forEach(c -> this.renderersDefault.put((DisplayerType)c, (RendererLibrary)rend)));
        }
        for (SyncBeanDef beanDef : beanDefs) {
            RendererLibrary lib = (RendererLibrary)beanDef.getInstance();
            this.renderersList.add(lib);
            for (DisplayerType displayerType : DisplayerType.values()) {
                if (!lib.isDefault(displayerType)) continue;
                this.renderersDefault.putIfAbsent(displayerType, lib);
            }
            List<DisplayerType> types = lib.getSupportedTypes();
            if (types == null || types.isEmpty()) continue;
            for (DisplayerType type : types) {
                List<RendererLibrary> set = this.renderersByType.get(type);
                if (set == null) {
                    set = new ArrayList<RendererLibrary>();
                    this.renderersByType.put(type, set);
                }
                set.add(lib);
                List<DisplayerSubType> subTypes = lib.getSupportedSubtypes(type);
                if (subTypes == null || subTypes.isEmpty()) continue;
                for (DisplayerSubType subType : subTypes) {
                    List<RendererLibrary> subset = this.renderersBySubType.get(subType);
                    if (subset == null) {
                        subset = new ArrayList<RendererLibrary>();
                        this.renderersBySubType.put(subType, subset);
                    }
                    subset.add(lib);
                }
            }
        }
    }

    public List<RendererLibrary> getRenderers() {
        return this.renderersList;
    }

    public RendererLibrary getDefaultRenderer(DisplayerType displayerType) {
        return this.renderersDefault.get(displayerType);
    }

    public void setDefaultRenderer(DisplayerType displayerType, String rendererName) {
        this.renderersDefault.put(displayerType, this.getRendererByUUID(rendererName));
    }

    public List<RendererLibrary> getRenderersForType(DisplayerType displayerType) {
        return this.renderersByType.getOrDefault(displayerType, new ArrayList());
    }

    public List<RendererLibrary> getRenderersForType(DisplayerType type, DisplayerSubType subType) {
        List<RendererLibrary> types = this.renderersByType.getOrDefault(type, Collections.emptyList());
        List subTypes = this.renderersBySubType.getOrDefault(subType, Collections.emptyList());
        if (type == null) {
            return subType == null ? this.renderersList : subTypes;
        }
        if (subType == null) {
            return types;
        }
        ArrayList<RendererLibrary> result = new ArrayList<RendererLibrary>(subTypes);
        Iterator it = result.iterator();
        while (it.hasNext()) {
            RendererLibrary rl = (RendererLibrary)it.next();
            if (types.contains(rl)) continue;
            it.remove();
        }
        return result;
    }

    public RendererLibrary getRendererByUUID(String renderer) {
        return this.getRendererByOrThrowError(renderer, lib -> lib.getUUID().equals(renderer));
    }

    private RendererLibrary _getRendererByUUID(String renderer) {
        for (RendererLibrary lib : this.renderersList) {
            if (!lib.getUUID().equals(renderer)) continue;
            return lib;
        }
        return null;
    }

    public RendererLibrary getRendererByName(String renderer) {
        return this.getRendererByOrThrowError(renderer, lib -> lib.getName().equals(renderer));
    }

    private RendererLibrary getRendererByOrThrowError(String renderer, Predicate<RendererLibrary> test) {
        return this.renderersList.stream().filter(test).findFirst().orElseThrow(() -> new RuntimeException(this.i18n.rendererliblocator_renderer_not_found(renderer)));
    }

    public RendererLibrary getRendererForType(DisplayerType displayerType) {
        return this.renderersDefault.getOrDefault(displayerType, this.renderersByType.get(displayerType).get(0));
    }

    public RendererLibrary getRendererForDisplayer(DisplayerSettings target) {
        RendererLibrary targetRenderer;
        if (!StringUtils.isBlank((String)target.getRenderer()) && (targetRenderer = this._getRendererByUUID(target.getRenderer())) != null) {
            return targetRenderer;
        }
        List<RendererLibrary> renderersSupported = this.getRenderersForType(target.getType(), target.getSubtype());
        RendererLibrary defaultRenderer = this.getDefaultRenderer(target.getType());
        for (RendererLibrary rendererLibrary : renderersSupported) {
            if (defaultRenderer == null || !rendererLibrary.equals(defaultRenderer)) continue;
            return defaultRenderer;
        }
        if (!renderersSupported.isEmpty()) {
            return renderersSupported.get(0);
        }
        throw new RuntimeException(this.i18n.renderermanager_renderer_not_available(target.getType().name()));
    }

    public boolean isTypeSupported(DisplayerType type) {
        return !this.getRenderersForType(type).isEmpty();
    }
}

