/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.displayer.client;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.dashbuilder.common.client.error.ClientRuntimeError;
import org.dashbuilder.dataset.DataColumn;
import org.dashbuilder.dataset.DataSet;
import org.dashbuilder.dataset.DataSetLookup;
import org.dashbuilder.dataset.DataSetOp;
import org.dashbuilder.dataset.DataSetOpType;
import org.dashbuilder.dataset.client.DataSetClientServices;
import org.dashbuilder.dataset.client.DataSetExportReadyCallback;
import org.dashbuilder.dataset.client.DataSetReadyCallback;
import org.dashbuilder.dataset.filter.DataSetFilter;
import org.dashbuilder.dataset.group.ColumnGroup;
import org.dashbuilder.dataset.group.DataSetGroup;
import org.dashbuilder.dataset.group.GroupFunction;
import org.dashbuilder.dataset.group.GroupStrategy;
import org.dashbuilder.dataset.group.Interval;
import org.dashbuilder.dataset.sort.ColumnSort;
import org.dashbuilder.dataset.sort.DataSetSort;
import org.dashbuilder.dataset.sort.SortOrder;
import org.dashbuilder.displayer.client.DataSetHandler;
import org.dashbuilder.displayer.client.export.ExportCallback;
import org.dashbuilder.displayer.client.export.ExportFormat;
import org.uberfire.backend.vfs.Path;

public class DataSetHandlerImpl
implements DataSetHandler {
    protected DataSetClientServices clientServices;
    protected DataSetLookup lookupBase;
    protected DataSetLookup lookupCurrent;
    protected DataSet lastLookedUpDataSet;
    protected Map<String, List<GroupOpFilter>> _groupOpsAdded = new HashMap<String, List<GroupOpFilter>>();
    protected Map<String, List<GroupOpFilter>> _groupOpsSelected = new HashMap<String, List<GroupOpFilter>>();

    public DataSetHandlerImpl(DataSetClientServices clientServices, DataSetLookup lookup) {
        this.clientServices = clientServices;
        this.lookupBase = lookup;
        this.lookupCurrent = lookup.cloneInstance();
    }

    @Override
    public DataSet getLastDataSet() {
        return this.lastLookedUpDataSet;
    }

    @Override
    public DataSetLookup getCurrentDataSetLookup() {
        return this.lookupCurrent;
    }

    @Override
    public void resetAllOperations() {
        this.lookupCurrent = this.lookupBase.cloneInstance();
    }

    @Override
    public void limitDataSetRows(int offset, int rows) {
        int offsetBase = this.lookupBase.getRowOffset();
        int rowsBase = this.lookupBase.getNumberOfRows();
        this.lookupCurrent.setRowOffset(offsetBase + offset);
        if (rowsBase < 1 || rowsBase > rows) {
            this.lookupCurrent.setNumberOfRows(rows);
        }
    }

    @Override
    public DataSetGroup getGroupOperation(String columnId) {
        String sourceId = this._getSourceColumnId(columnId);
        int index = this.lookupCurrent.getLastGroupOpIndex(0, sourceId, false);
        if (index != -1) {
            return (DataSetGroup)this.lookupCurrent.getOperation(index).cloneInstance();
        }
        DataSetGroup result = new DataSetGroup();
        result.setColumnGroup(new ColumnGroup(sourceId, sourceId, GroupStrategy.DYNAMIC));
        return result;
    }

    @Override
    public boolean filter(DataSetGroup op) {
        ColumnGroup cg = op.getColumnGroup();
        if (cg == null) {
            throw new RuntimeException("Group ops require a pivot column to be specified.");
        }
        if (!op.isSelect()) {
            throw new RuntimeException("Group intervals not specified.");
        }
        for (DataSetGroup next : this.lookupCurrent.getOperationList(DataSetGroup.class)) {
            if (!op.equals((Object)next)) continue;
            return false;
        }
        DataSetGroup clone = op.cloneInstance();
        int idx = this.lookupCurrent.getFirstGroupOpIndex(0, null, null);
        this._filter(idx < 0 ? 0 : idx, clone, false);
        return true;
    }

    @Override
    public boolean filter(DataSetFilter op) {
        if (op == null) {
            return false;
        }
        for (DataSetFilter next : this.lookupCurrent.getOperationList(DataSetFilter.class)) {
            if (!op.equals((Object)next)) continue;
            return false;
        }
        this.lookupCurrent.addOperation(0, new DataSetOp[]{op});
        return true;
    }

    @Override
    public boolean drillDown(DataSetGroup op) {
        ColumnGroup cg = op.getColumnGroup();
        if (cg == null) {
            throw new RuntimeException("Group ops require a pivot column to be specified.");
        }
        if (!op.isSelect()) {
            throw new RuntimeException("Group intervals not specified.");
        }
        for (DataSetGroup next : this.lookupCurrent.getOperationList(DataSetGroup.class)) {
            if (!op.equals((Object)next)) continue;
            return false;
        }
        int lastSelection = this.lookupCurrent.getLastGroupOpIndex(0, null, true) + 1;
        int targetGroup = this.lookupCurrent.getLastGroupOpIndex(lastSelection, cg.getColumnId(), false);
        if (targetGroup == -1) {
            DataSetGroup clone = op.cloneInstance();
            this._filter(lastSelection, clone, true);
            return true;
        }
        DataSetGroup targetOp = (DataSetGroup)this.lookupCurrent.getOperation(targetGroup);
        int latestGroup = this.lookupCurrent.getLastGroupOpIndex(targetGroup + 1, null, false);
        if (latestGroup == -1) {
            DataSetGroup clone = targetOp.cloneInstance();
            this._filter(targetGroup + 1, clone, true);
        }
        this._select(targetOp, op.getSelectedIntervalList());
        return true;
    }

    @Override
    public boolean unfilter(DataSetGroup op) {
        return this._unfilter(op, false);
    }

    @Override
    public boolean unfilter(DataSetFilter op) {
        if (op == null) {
            return false;
        }
        int idx = this.lookupCurrent.getOperationIdx((DataSetOp)op);
        if (idx != -1) {
            this.lookupCurrent.removeOperation(idx);
            return true;
        }
        return false;
    }

    @Override
    public boolean drillUp(DataSetGroup op) {
        return this._unfilter(op, true);
    }

    @Override
    public void sort(String columnId, SortOrder sortOrder) {
        this.unsort();
        String sourceId = this._getSourceColumnId(columnId);
        DataSetSort sortOp = new DataSetSort();
        sortOp.addSortColumn(new ColumnSort[]{new ColumnSort(sourceId, sortOrder)});
        this.lookupCurrent.addOperation(new DataSetOp[]{sortOp});
    }

    public boolean unsort() {
        int n = this.lookupCurrent.removeOperations(DataSetOpType.SORT);
        return n > 0;
    }

    @Override
    public void lookupDataSet(final DataSetReadyCallback callback) throws Exception {
        this.clientServices.lookupDataSet(this.lookupCurrent, new DataSetReadyCallback(){

            public void callback(DataSet dataSet) {
                DataSetHandlerImpl.this.lastLookedUpDataSet = dataSet;
                callback.callback(dataSet);
            }

            public void notFound() {
                callback.notFound();
            }

            public boolean onError(ClientRuntimeError error) {
                return callback.onError(error);
            }
        });
    }

    @Override
    public Interval getInterval(String columnId, int row) {
        Object value;
        if (this.lastLookedUpDataSet == null) {
            return null;
        }
        DataColumn column = this.lastLookedUpDataSet.getColumnById(columnId);
        if (column == null) {
            return null;
        }
        List values = column.getValues();
        Object object = value = row < values.size() ? (Object)values.get(row) : null;
        if (value == null) {
            return null;
        }
        Interval result = new Interval(value.toString(), row);
        result.setType(column.getIntervalType());
        result.setMinValue(column.getMinValue());
        result.setMaxValue(column.getMaxValue());
        return result;
    }

    @Override
    public void exportCurrentDataSetLookup(ExportFormat format, int maxRows, final ExportCallback callback, Map<String, String> columnNameMap) {
        if (this.lastLookedUpDataSet == null || this.lastLookedUpDataSet.getRowCount() == 0) {
            callback.noData();
            return;
        }
        int allRows = this.lastLookedUpDataSet.getRowCountNonTrimmed();
        if (maxRows > 0 && allRows > maxRows) {
            callback.tooManyRows(allRows);
            return;
        }
        try {
            DataSetExportReadyCallback exportReadyCallback = new DataSetExportReadyCallback(){

                public void exportReady(Path exportFilePath) {
                    String u = DataSetHandlerImpl.this.clientServices.getDownloadFileUrl(exportFilePath);
                    callback.exportFileUrl(u);
                }

                public void onError(ClientRuntimeError error) {
                    callback.error(error);
                }
            };
            DataSetLookup exportLookup = this.getCurrentDataSetLookup().cloneInstance();
            exportLookup.setRowOffset(0);
            exportLookup.setNumberOfRows(maxRows);
            if (exportLookup.getLastGroupOp() != null && columnNameMap != null) {
                for (GroupFunction groupFunction : exportLookup.getLastGroupOp().getGroupFunctions()) {
                    String columnId = groupFunction.getColumnId();
                    if (!columnNameMap.containsKey(columnId)) continue;
                    String columnName = columnNameMap.get(columnId);
                    groupFunction.setColumnId(columnName);
                }
            }
            if (ExportFormat.XLS.equals((Object)format)) {
                this.clientServices.exportDataSetExcel(exportLookup, exportReadyCallback);
            } else {
                this.clientServices.exportDataSetCSV(exportLookup, exportReadyCallback);
            }
        }
        catch (Exception e) {
            callback.error(new ClientRuntimeError((Throwable)e));
        }
    }

    protected void _filter(int index, DataSetGroup op, boolean drillDown) {
        ColumnGroup cgroup = op.getColumnGroup();
        String columnId = cgroup.getColumnId();
        if (!this._groupOpsAdded.containsKey(columnId)) {
            this._groupOpsAdded.put(columnId, new ArrayList());
        }
        List<GroupOpFilter> filterOps = this._groupOpsAdded.get(columnId);
        if (!drillDown) {
            for (GroupOpFilter filterOp : filterOps) {
                if (filterOp.drillDown || !filterOp.groupOp.getColumnGroup().equals((Object)cgroup)) continue;
                filterOp.groupOp.getSelectedIntervalList().clear();
                filterOp.groupOp.getSelectedIntervalList().addAll(op.getSelectedIntervalList());
                return;
            }
        }
        GroupOpFilter groupOpFilter = new GroupOpFilter(op, drillDown);
        filterOps.add(groupOpFilter);
        this.lookupCurrent.addOperation(index, new DataSetOp[]{op});
    }

    protected void _select(DataSetGroup op, List<Interval> intervalList) {
        GroupOpFilter groupOpFilter = new GroupOpFilter(op, true);
        op.setSelectedIntervalList(intervalList);
        String columnId = op.getColumnGroup().getColumnId();
        if (!this._groupOpsSelected.containsKey(columnId)) {
            this._groupOpsSelected.put(columnId, new ArrayList());
        }
        this._groupOpsSelected.get(columnId).add(groupOpFilter);
    }

    protected boolean _unfilter(DataSetGroup op, boolean drillDown) {
        GroupOpFilter target;
        Iterator<GroupOpFilter> it1;
        boolean opFound = false;
        String columnId = op.getColumnGroup().getColumnId();
        if (this._groupOpsAdded.containsKey(columnId)) {
            it1 = this._groupOpsAdded.get(columnId).iterator();
            while (it1.hasNext()) {
                target = it1.next();
                Iterator it2 = this.lookupCurrent.getOperationList().iterator();
                while (it2.hasNext()) {
                    DataSetOp next = (DataSetOp)it2.next();
                    if (next != target.groupOp || target.drillDown != drillDown) continue;
                    it1.remove();
                    it2.remove();
                    opFound = true;
                }
            }
        }
        if (this._groupOpsSelected.containsKey(columnId)) {
            it1 = this._groupOpsSelected.get(columnId).iterator();
            while (it1.hasNext()) {
                target = it1.next();
                for (DataSetOp next : this.lookupCurrent.getOperationList(DataSetGroup.class)) {
                    if (next != target.groupOp || target.drillDown != drillDown) continue;
                    it1.remove();
                    next.getSelectedIntervalList().clear();
                    next.getGroupFunctions().clear();
                    next.getSelectedIntervalList().addAll(target.intervalList);
                    next.getGroupFunctions().addAll(target.groupFunctions);
                    opFound = true;
                }
            }
        }
        return opFound;
    }

    protected String _getSourceColumnId(String columnId) {
        String sourceId;
        DataColumn column;
        if (this.lastLookedUpDataSet != null && (column = this.lastLookedUpDataSet.getColumnById(columnId)) != null && column.getGroupFunction() != null && (sourceId = column.getGroupFunction().getSourceId()) != null) {
            return sourceId;
        }
        for (List<GroupOpFilter> currentSelections : this._groupOpsSelected.values()) {
            for (GroupOpFilter groupOpFilter : currentSelections) {
                GroupFunction gf = groupOpFilter.groupOp.getGroupFunction(columnId);
                if (gf == null) continue;
                return gf.getSourceId();
            }
        }
        return columnId;
    }

    protected static class GroupOpFilter {
        DataSetGroup groupOp;
        boolean drillDown = false;
        List<GroupFunction> groupFunctions;
        List<Interval> intervalList;

        private GroupOpFilter(DataSetGroup op, boolean drillDown) {
            this.groupOp = op;
            this.drillDown = drillDown;
            this.groupFunctions = new ArrayList<GroupFunction>(op.getGroupFunctions());
            this.intervalList = new ArrayList<Interval>(op.getSelectedIntervalList());
        }

        public String toString() {
            StringBuilder out = new StringBuilder();
            out.append("drillDown(").append(this.drillDown).append(") ");
            if (this.groupOp != null) {
                out.append("groupOp(").append(this.groupOp).append(")");
            }
            return out.toString();
        }
    }
}

