/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.displayer.client.widgets;

import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Widget;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.dashbuilder.displayer.DisplayerAttributeDef;
import org.dashbuilder.displayer.client.Displayer;
import org.dashbuilder.displayer.client.widgets.sourcecode.HasHtmlTemplate;
import org.dashbuilder.displayer.client.widgets.sourcecode.HasJsTemplate;
import org.dashbuilder.displayer.client.widgets.sourcecode.SourceCodeEditor;
import org.dashbuilder.displayer.client.widgets.sourcecode.SourceCodeType;
import org.uberfire.client.mvp.UberView;

@Dependent
public class DisplayerHtmlEditor
implements IsWidget {
    Displayer displayer;
    View view;
    SourceCodeEditor sourceCodeEditor;
    Set<SourceCodeItem> sourceCodeItems = new HashSet<SourceCodeItem>();
    SourceCodeItem selectedSourceCodeItem = null;
    boolean showingDisplayer = true;

    @Inject
    public DisplayerHtmlEditor(View view, SourceCodeEditor sourceCodeEditor) {
        this.view = view;
        this.sourceCodeEditor = sourceCodeEditor;
        view.init(this);
        this.sourceCodeItems.add(new SourceCodeItem("html", SourceCodeType.HTML, DisplayerAttributeDef.HTML_TEMPLATE));
        this.sourceCodeItems.add(new SourceCodeItem("javascript", SourceCodeType.JAVASCRIPT, DisplayerAttributeDef.JS_TEMPLATE));
    }

    public Widget asWidget() {
        return this.view.asWidget();
    }

    public Displayer getDisplayer() {
        return this.displayer;
    }

    public void setDisplayer(Displayer displayer) {
        this.selectedSourceCodeItem = null;
        this.displayer = displayer;
        this.initSourceCodeItems();
        this.showDisplayer();
    }

    public boolean showDisplayer() {
        if (this.sourceCodeEditor.hasErrors()) {
            this.sourceCodeEditor.focus();
            return false;
        }
        this.view.showDisplayer(this.displayer);
        this.showingDisplayer = true;
        this.displayer.redraw();
        return true;
    }

    public void initSourceCodeItems() {
        this.view.clearSourceCodeItems();
        Set attrs = this.displayer.getDisplayerConstraints().getSupportedAttributes();
        for (SourceCodeItem sourceCodeItem : this.sourceCodeItems) {
            if (!attrs.contains(sourceCodeItem.attributeDef)) continue;
            this.view.addSourceCodeItem(sourceCodeItem.name);
        }
    }

    public SourceCodeItem getSourceCodeItem(String name) {
        for (SourceCodeItem sourceCodeItem : this.sourceCodeItems) {
            if (!sourceCodeItem.name.equals(name)) continue;
            return sourceCodeItem;
        }
        return null;
    }

    public boolean onSourceCodeItemSelected(String name) {
        this.selectedSourceCodeItem = this.getSourceCodeItem(name);
        String code = this.displayer.getDisplayerSettings().getDisplayerSetting(this.selectedSourceCodeItem.attributeDef);
        Map<String, String> varMap = null;
        if (this.selectedSourceCodeItem.type == SourceCodeType.HTML && this.displayer instanceof HasHtmlTemplate) {
            varMap = ((HasHtmlTemplate)((Object)this.displayer)).getHtmlVariableMap();
        }
        if (this.selectedSourceCodeItem.type == SourceCodeType.JAVASCRIPT && this.displayer instanceof HasJsTemplate) {
            varMap = ((HasJsTemplate)((Object)this.displayer)).getJsVariableMap();
        }
        this.sourceCodeEditor.init(this.selectedSourceCodeItem.type, code, varMap, this::onSourceCodeChanged);
        this.sourceCodeEditor.focus();
        this.showingDisplayer = false;
        this.view.editSourceCodeItem(name, this.sourceCodeEditor);
        return true;
    }

    public void onSourceCodeChanged() {
        if (!this.sourceCodeEditor.hasErrors()) {
            String newCode = this.sourceCodeEditor.getCode();
            this.displayer.getDisplayerSettings().setDisplayerSetting(this.selectedSourceCodeItem.attributeDef, newCode);
        }
    }

    public class SourceCodeItem {
        String name;
        SourceCodeType type;
        DisplayerAttributeDef attributeDef;

        public SourceCodeItem(String name, SourceCodeType type, DisplayerAttributeDef attributeDef) {
            this.name = name;
            this.type = type;
            this.attributeDef = attributeDef;
        }
    }

    public static interface View
    extends UberView<DisplayerHtmlEditor> {
        public void showDisplayer(IsWidget var1);

        public void clearSourceCodeItems();

        public void addSourceCodeItem(String var1);

        public void editSourceCodeItem(String var1, IsWidget var2);
    }
}

