/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.displayer.client.widgets;

import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Widget;
import elemental2.dom.DomGlobal;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.dashbuilder.common.client.error.ClientRuntimeError;
import org.dashbuilder.dataset.DataColumn;
import org.dashbuilder.dataset.DataSet;
import org.dashbuilder.dataset.client.DataSetReadyCallback;
import org.dashbuilder.dataset.sort.SortOrder;
import org.dashbuilder.displayer.ColumnSettings;
import org.dashbuilder.displayer.DisplayerAttributeDef;
import org.dashbuilder.displayer.DisplayerAttributeGroupDef;
import org.dashbuilder.displayer.DisplayerConstraints;
import org.dashbuilder.displayer.DisplayerSettings;
import org.dashbuilder.displayer.MapColorScheme;
import org.dashbuilder.displayer.Position;
import org.dashbuilder.displayer.client.Displayer;
import org.dashbuilder.displayer.client.DisplayerLocator;
import org.dashbuilder.displayer.client.RendererLibrary;
import org.dashbuilder.displayer.client.RendererManager;
import org.dashbuilder.displayer.client.events.DisplayerSettingsChangedEvent;
import org.uberfire.client.mvp.UberView;
import org.uberfire.ext.properties.editor.model.validators.PropertyFieldValidator;

@Dependent
public class DisplayerSettingsEditor
implements IsWidget {
    protected View view;
    protected DisplayerLocator displayerLocator;
    protected RendererManager rendererManager;
    protected Displayer displayer;
    protected DisplayerSettings displayerSettings;
    protected DisplayerConstraints displayerContraints;
    private Set<DisplayerAttributeDef> supportedAttributes;
    protected Event<DisplayerSettingsChangedEvent> settingsChangedEvent;
    public static final String COLUMNS_PREFFIX = "columns.";

    @Inject
    public DisplayerSettingsEditor(View view, DisplayerLocator displayerLocator, RendererManager rendererManager, Event<DisplayerSettingsChangedEvent> settingsChangedEvent) {
        this.view = view;
        this.displayerLocator = displayerLocator;
        this.rendererManager = rendererManager;
        this.settingsChangedEvent = settingsChangedEvent;
        view.init(this);
    }

    public Widget asWidget() {
        return this.view.asWidget();
    }

    public DisplayerSettings getDisplayerSettings() {
        return this.displayerSettings;
    }

    public void init(Displayer displayer) {
        try {
            this.displayer = displayer;
            this.displayerSettings = displayer.getDisplayerSettings();
            this.displayerContraints = displayer.getDisplayerConstraints();
            this.supportedAttributes = this.displayerContraints.getSupportedAttributes();
            displayer.getDataSetHandler().lookupDataSet(new DataSetReadyCallback(){

                public void callback(DataSet dataSet) {
                    DisplayerSettingsEditor.this.show();
                }

                public void notFound() {
                    DisplayerSettingsEditor.this.view.dataSetNotFound();
                }

                public boolean onError(ClientRuntimeError error) {
                    DisplayerSettingsEditor.this.console(error.getThrowable());
                    DisplayerSettingsEditor.this.view.error(error.getMessage());
                    return false;
                }
            });
        }
        catch (Exception e) {
            this.console(e);
            this.view.error(e.toString());
        }
    }

    public boolean isSupported(DisplayerAttributeDef attributeDef) {
        return this.supportedAttributes.contains(attributeDef);
    }

    public boolean isSupported(DisplayerAttributeGroupDef groupDef) {
        if (this.supportedAttributes.contains(groupDef)) {
            for (DisplayerAttributeDef attrDef : groupDef.getChildren()) {
                if (attrDef instanceof DisplayerAttributeGroupDef || !this.supportedAttributes.contains(attrDef)) continue;
                return true;
            }
        }
        return false;
    }

    void show() {
        ArrayList<String> optionList;
        this.view.clear();
        if (this.isSupported(DisplayerAttributeGroupDef.GENERAL_GROUP)) {
            this.view.addCategory((DisplayerAttributeDef)DisplayerAttributeGroupDef.GENERAL_GROUP);
            if (this.isSupported(DisplayerAttributeDef.TITLE)) {
                this.view.addTextProperty(DisplayerAttributeDef.TITLE, this.displayerSettings.getTitle(), new PropertyFieldValidator[0]);
            }
            if (this.isSupported(DisplayerAttributeDef.TITLE_VISIBLE)) {
                this.view.addBooleanProperty(DisplayerAttributeDef.TITLE_VISIBLE, this.displayerSettings.isTitleVisible());
            }
        }
        if (this.isSupported(DisplayerAttributeDef.RENDERER)) {
            this.view.addCategory(DisplayerAttributeDef.RENDERER);
            optionList = new ArrayList<String>();
            for (RendererLibrary option : this.rendererManager.getRenderersForType(this.displayerSettings.getType())) {
                optionList.add(option.getUUID());
            }
            if (optionList.size() > 1) {
                Position[] renderer = this.rendererManager.getRendererForDisplayer(this.displayerSettings);
                this.view.addListProperty(DisplayerAttributeDef.RENDERER, optionList, renderer.getUUID());
            }
        }
        if (this.isSupported(DisplayerAttributeGroupDef.CHART_GROUP)) {
            this.view.addCategory((DisplayerAttributeDef)DisplayerAttributeGroupDef.CHART_GROUP);
            if (this.isSupported(DisplayerAttributeDef.CHART_RESIZABLE)) {
                this.view.addBooleanProperty(DisplayerAttributeDef.CHART_RESIZABLE, this.displayerSettings.isResizable());
            }
            if (this.isSupported(DisplayerAttributeDef.CHART_WIDTH)) {
                this.view.addTextProperty(DisplayerAttributeDef.CHART_WIDTH, String.valueOf(this.displayerSettings.getChartWidth()), this.createLongValidator());
            }
            if (this.isSupported(DisplayerAttributeDef.CHART_HEIGHT)) {
                this.view.addTextProperty(DisplayerAttributeDef.CHART_HEIGHT, String.valueOf(this.displayerSettings.getChartHeight()), this.createLongValidator());
            }
            if (this.isSupported(DisplayerAttributeDef.CHART_BGCOLOR)) {
                this.view.addColorProperty(DisplayerAttributeDef.CHART_BGCOLOR, this.displayerSettings.getChartBackgroundColor());
            }
            if (this.isSupported(DisplayerAttributeDef.CHART_3D)) {
                this.view.addBooleanProperty(DisplayerAttributeDef.CHART_3D, this.displayerSettings.isChart3D());
            }
        }
        if (this.isSupported(DisplayerAttributeGroupDef.CHART_MARGIN_GROUP)) {
            this.view.addCategory((DisplayerAttributeDef)DisplayerAttributeGroupDef.CHART_MARGIN_GROUP);
            if (this.isSupported(DisplayerAttributeDef.CHART_MARGIN_TOP)) {
                this.view.addTextProperty(DisplayerAttributeDef.CHART_MARGIN_TOP, String.valueOf(this.displayerSettings.getChartMarginTop()), this.createLongValidator());
            }
            if (this.isSupported(DisplayerAttributeDef.CHART_MARGIN_BOTTOM)) {
                this.view.addTextProperty(DisplayerAttributeDef.CHART_MARGIN_BOTTOM, String.valueOf(this.displayerSettings.getChartMarginBottom()), this.createLongValidator());
            }
            if (this.isSupported(DisplayerAttributeDef.CHART_MARGIN_LEFT)) {
                this.view.addTextProperty(DisplayerAttributeDef.CHART_MARGIN_LEFT, String.valueOf(this.displayerSettings.getChartMarginLeft()), this.createLongValidator());
            }
            if (this.isSupported(DisplayerAttributeDef.CHART_MARGIN_RIGHT)) {
                this.view.addTextProperty(DisplayerAttributeDef.CHART_MARGIN_RIGHT, String.valueOf(this.displayerSettings.getChartMarginRight()), this.createLongValidator());
            }
        }
        if (this.isSupported(DisplayerAttributeGroupDef.CHART_LEGEND_GROUP)) {
            this.view.addCategory((DisplayerAttributeDef)DisplayerAttributeGroupDef.CHART_LEGEND_GROUP);
            if (this.isSupported(DisplayerAttributeDef.CHART_SHOWLEGEND)) {
                this.view.addBooleanProperty(DisplayerAttributeDef.CHART_SHOWLEGEND, this.displayerSettings.isChartShowLegend());
            }
            if (this.isSupported(DisplayerAttributeDef.CHART_LEGENDPOSITION)) {
                optionList = new ArrayList();
                for (Position position : Position.values()) {
                    String positionLabel = this.view.getPositionLiteralI18n(position);
                    optionList.add(positionLabel);
                }
                if (optionList.size() > 1) {
                    String positionLabel = this.view.getPositionLiteralI18n(this.displayerSettings.getChartLegendPosition());
                    this.view.addListProperty(DisplayerAttributeDef.CHART_LEGENDPOSITION, optionList, positionLabel);
                }
            }
        }
        if (this.isSupported(DisplayerAttributeGroupDef.XAXIS_GROUP) || this.isSupported(DisplayerAttributeGroupDef.YAXIS_GROUP)) {
            this.view.addCategory((DisplayerAttributeDef)DisplayerAttributeGroupDef.XAXIS_GROUP);
            if (this.isSupported(DisplayerAttributeDef.XAXIS_SHOWLABELS)) {
                this.view.addBooleanProperty(DisplayerAttributeDef.XAXIS_SHOWLABELS, this.displayerSettings.isXAxisShowLabels());
            }
            if (this.isSupported(DisplayerAttributeDef.XAXIS_TITLE)) {
                this.view.addTextProperty(DisplayerAttributeDef.XAXIS_TITLE, this.displayerSettings.getXAxisTitle(), new PropertyFieldValidator[0]);
            }
            if (this.isSupported(DisplayerAttributeDef.XAXIS_LABELSANGLE)) {
                this.view.addTextProperty(DisplayerAttributeDef.XAXIS_LABELSANGLE, String.valueOf(this.displayerSettings.getXAxisLabelsAngle()), new PropertyFieldValidator[0]);
            }
            if (this.isSupported(DisplayerAttributeDef.YAXIS_SHOWLABELS)) {
                this.view.addBooleanProperty(DisplayerAttributeDef.YAXIS_SHOWLABELS, this.displayerSettings.isXAxisShowLabels());
            }
            if (this.isSupported(DisplayerAttributeDef.YAXIS_TITLE)) {
                this.view.addTextProperty(DisplayerAttributeDef.YAXIS_TITLE, this.displayerSettings.getYAxisTitle(), new PropertyFieldValidator[0]);
            }
        }
        if (this.isSupported(DisplayerAttributeGroupDef.TABLE_GROUP)) {
            this.view.addCategory((DisplayerAttributeDef)DisplayerAttributeGroupDef.TABLE_GROUP);
            if (this.isSupported(DisplayerAttributeDef.TABLE_PAGESIZE)) {
                this.view.addTextProperty(DisplayerAttributeDef.TABLE_PAGESIZE, String.valueOf(this.displayerSettings.getTablePageSize()), this.createLongValidator());
            }
            if (this.isSupported(DisplayerAttributeDef.TABLE_WIDTH)) {
                this.view.addTextProperty(DisplayerAttributeDef.TABLE_WIDTH, String.valueOf(this.displayerSettings.getTableWidth()), this.createLongValidator());
            }
            if (this.isSupported(DisplayerAttributeDef.TABLE_SORTENABLED)) {
                this.view.addBooleanProperty(DisplayerAttributeDef.TABLE_SORTENABLED, this.displayerSettings.isTableSortEnabled());
            }
            if (this.isSupported(DisplayerAttributeDef.TABLE_SORTCOLUMNID)) {
                optionList = new ArrayList();
                DataSet dataSet = this.displayer.getDataSetHandler().getLastDataSet();
                List dsColumns = dataSet.getColumns();
                optionList.add("");
                for (DataColumn column : dsColumns) {
                    optionList.add(column.getId());
                }
                this.view.addListProperty(DisplayerAttributeDef.TABLE_SORTCOLUMNID, optionList, this.displayerSettings.getTableDefaultSortColumnId());
            }
            if (this.isSupported(DisplayerAttributeDef.TABLE_SORTORDER)) {
                optionList = new ArrayList();
                optionList.add(SortOrder.ASCENDING.toString());
                optionList.add(SortOrder.DESCENDING.toString());
                this.view.addListProperty(DisplayerAttributeDef.TABLE_SORTORDER, optionList, this.displayerSettings.getTableDefaultSortOrder().toString());
            }
            if (this.isSupported(DisplayerAttributeDef.TABLE_COLUMN_PICKER_ENABLED)) {
                this.view.addBooleanProperty(DisplayerAttributeDef.TABLE_COLUMN_PICKER_ENABLED, this.displayerSettings.isTableColumnPickerEnabled());
            }
        }
        if (this.isSupported(DisplayerAttributeGroupDef.METER_GROUP)) {
            this.view.addCategory((DisplayerAttributeDef)DisplayerAttributeGroupDef.METER_GROUP);
            if (this.isSupported(DisplayerAttributeDef.METER_START)) {
                this.view.addTextProperty(DisplayerAttributeDef.METER_START, String.valueOf(this.displayerSettings.getMeterStart()), this.createMeterValidator(this.displayerSettings, 0));
            }
            if (this.isSupported(DisplayerAttributeDef.METER_WARNING)) {
                this.view.addTextProperty(DisplayerAttributeDef.METER_WARNING, String.valueOf(this.displayerSettings.getMeterWarning()), this.createMeterValidator(this.displayerSettings, 1));
            }
            if (this.isSupported(DisplayerAttributeDef.METER_CRITICAL)) {
                this.view.addTextProperty(DisplayerAttributeDef.METER_CRITICAL, String.valueOf(this.displayerSettings.getMeterCritical()), this.createMeterValidator(this.displayerSettings, 2));
            }
            if (this.isSupported(DisplayerAttributeDef.METER_END)) {
                this.view.addTextProperty(DisplayerAttributeDef.METER_END, String.valueOf(this.displayerSettings.getMeterEnd()), this.createMeterValidator(this.displayerSettings, 3));
            }
        }
        if (this.isSupported(DisplayerAttributeGroupDef.FILTER_GROUP)) {
            this.view.addCategory((DisplayerAttributeDef)DisplayerAttributeGroupDef.FILTER_GROUP);
            if (this.isSupported(DisplayerAttributeDef.FILTER_ENABLED)) {
                this.view.addBooleanProperty(DisplayerAttributeDef.FILTER_ENABLED, this.displayerSettings.isFilterEnabled());
            }
            if (this.isSupported(DisplayerAttributeDef.FILTER_SELFAPPLY_ENABLED)) {
                this.view.addBooleanProperty(DisplayerAttributeDef.FILTER_SELFAPPLY_ENABLED, this.displayerSettings.isFilterSelfApplyEnabled());
            }
            if (this.isSupported(DisplayerAttributeDef.FILTER_LISTENING_ENABLED)) {
                this.view.addBooleanProperty(DisplayerAttributeDef.FILTER_LISTENING_ENABLED, this.displayerSettings.isFilterListeningEnabled());
            }
            if (this.isSupported(DisplayerAttributeDef.FILTER_NOTIFICATION_ENABLED)) {
                this.view.addBooleanProperty(DisplayerAttributeDef.FILTER_NOTIFICATION_ENABLED, this.displayerSettings.isFilterNotificationEnabled());
            }
        }
        if (this.isSupported(DisplayerAttributeGroupDef.SELECTOR_GROUP)) {
            this.view.addCategory((DisplayerAttributeDef)DisplayerAttributeGroupDef.SELECTOR_GROUP);
            if (this.isSupported(DisplayerAttributeDef.SELECTOR_WIDTH)) {
                this.view.addTextProperty(DisplayerAttributeDef.SELECTOR_WIDTH, String.valueOf(this.displayerSettings.getSelectorWidth()), this.createLongValidator());
            }
            if (this.isSupported(DisplayerAttributeDef.SELECTOR_MULTIPLE)) {
                this.view.addBooleanProperty(DisplayerAttributeDef.SELECTOR_MULTIPLE, this.displayerSettings.isSelectorMultiple());
            }
            if (this.isSupported(DisplayerAttributeDef.SELECTOR_SHOW_INPUTS)) {
                this.view.addBooleanProperty(DisplayerAttributeDef.SELECTOR_SHOW_INPUTS, this.displayerSettings.isSelectorInputsEnabled());
            }
        }
        if (this.isSupported(DisplayerAttributeGroupDef.REFRESH_GROUP)) {
            this.view.addCategory((DisplayerAttributeDef)DisplayerAttributeGroupDef.REFRESH_GROUP);
            if (this.isSupported(DisplayerAttributeDef.REFRESH_INTERVAL)) {
                this.view.addTextProperty(DisplayerAttributeDef.REFRESH_INTERVAL, String.valueOf(this.displayerSettings.getRefreshInterval()), this.createLongValidator());
            }
            if (this.isSupported(DisplayerAttributeDef.REFRESH_STALE_DATA)) {
                this.view.addBooleanProperty(DisplayerAttributeDef.REFRESH_STALE_DATA, this.displayerSettings.isRefreshStaleData());
            }
        }
        if (this.isSupported(DisplayerAttributeGroupDef.COLUMNS_GROUP)) {
            this.view.addCategory((DisplayerAttributeDef)DisplayerAttributeGroupDef.COLUMNS_GROUP);
            DataSet dataSet = this.displayer.getDataSetHandler().getLastDataSet();
            for (int i = 0; i < dataSet.getColumns().size(); ++i) {
                DataColumn dataColumn = dataSet.getColumnByIndex(i);
                ColumnSettings cs = this.displayerSettings.getColumnSettings(dataColumn);
                String fieldSuffix = COLUMNS_PREFFIX + cs.getColumnId() + ".";
                String expression = cs.getValueExpression();
                String pattern = cs.getValuePattern();
                this.view.addTextProperty(fieldSuffix + "name", this.view.getColumnNameI18n() + (i + 1), cs.getColumnName(), new PropertyFieldValidator[0]);
                if (expression != null) {
                    this.view.addTextProperty(fieldSuffix + "expression", "     " + this.view.getColumnExpressionI18n(), expression, new PropertyFieldValidator[0]);
                }
                if (pattern == null) continue;
                this.view.addTextProperty(fieldSuffix + "pattern", "     " + this.view.getColumnPatternI18n(), pattern, new PropertyFieldValidator[0]);
            }
        }
        if (this.isSupported(DisplayerAttributeGroupDef.EXPORT_GROUP)) {
            this.view.addCategory((DisplayerAttributeDef)DisplayerAttributeGroupDef.EXPORT_GROUP);
            if (this.isSupported(DisplayerAttributeDef.EXPORT_TO_CSV)) {
                this.view.addBooleanProperty(DisplayerAttributeDef.EXPORT_TO_CSV, this.displayerSettings.isCSVExportAllowed());
            }
            if (this.isSupported(DisplayerAttributeDef.EXPORT_TO_XLS)) {
                this.view.addBooleanProperty(DisplayerAttributeDef.EXPORT_TO_XLS, this.displayerSettings.isExcelExportAllowed());
            }
        }
        if (this.isSupported(DisplayerAttributeGroupDef.MAP_GROUP)) {
            this.view.addCategory((DisplayerAttributeDef)DisplayerAttributeGroupDef.MAP_GROUP);
            if (this.isSupported(DisplayerAttributeDef.MAP_COLOR_SCHEME)) {
                List<String> colorsSchemes = Stream.of(MapColorScheme.values()).map(this.view::getMapColorSchemeI18n).collect(Collectors.toList());
                String mapColorSchemePositionLabel = this.view.getMapColorSchemeI18n(this.displayerSettings.getMapColorScheme());
                this.view.addListProperty(DisplayerAttributeDef.MAP_COLOR_SCHEME, colorsSchemes, mapColorSchemePositionLabel);
            }
        }
        this.view.show();
    }

    void onAttributeChanged(String attrKey, String attrValue) {
        if (attrKey.startsWith(COLUMNS_PREFFIX)) {
            String[] strings = attrKey.split("\\.");
            if (strings.length == 3) {
                String columnId = strings[1];
                String setting = strings[2];
                if ("name".equals(setting)) {
                    this.displayerSettings.setColumnName(columnId, attrValue);
                } else if ("empty".equals(setting)) {
                    this.displayerSettings.setColumnEmptyTemplate(columnId, attrValue);
                } else if ("pattern".equals(setting)) {
                    this.displayerSettings.setColumnValuePattern(columnId, attrValue);
                } else if ("expression".equals(setting)) {
                    this.displayerSettings.setColumnValueExpression(columnId, attrValue);
                }
            }
        } else {
            this.displayerSettings.setDisplayerSetting(attrKey, attrValue);
        }
        this.settingsChangedEvent.fire((Object)new DisplayerSettingsChangedEvent(this.displayerSettings));
    }

    public LongValidator createLongValidator() {
        return new LongValidator();
    }

    public DoubleValidator createDoubleValidator() {
        return new DoubleValidator();
    }

    public MeterValidator createMeterValidator(DisplayerSettings settings, int level) {
        return new MeterValidator(settings, level);
    }

    private void console(Throwable e) {
        if (DomGlobal.console != null) {
            DomGlobal.console.error(new Object[]{"Error running displayer."});
            DomGlobal.console.error(new Object[]{e});
        }
    }

    public class MeterValidator
    extends LongValidator {
        private DisplayerSettings displayerSettings;
        private int level;
        private boolean lowerOk;
        private boolean upperOk;

        public MeterValidator(DisplayerSettings displayerSettings, int level) {
            this.lowerOk = true;
            this.upperOk = true;
            this.displayerSettings = displayerSettings;
            this.level = level;
        }

        private long getLevelValue(int level) {
            switch (level) {
                case 0: {
                    return this.displayerSettings.getMeterStart();
                }
                case 1: {
                    return this.displayerSettings.getMeterWarning();
                }
                case 2: {
                    return this.displayerSettings.getMeterCritical();
                }
                case 3: {
                    return this.displayerSettings.getMeterEnd();
                }
            }
            return level < 0 ? Long.MIN_VALUE : Long.MAX_VALUE;
        }

        private String getLevelDescr(int level) {
            switch (level) {
                case 0: {
                    return DisplayerSettingsEditor.this.view.getMeterStartI18n();
                }
                case 1: {
                    return DisplayerSettingsEditor.this.view.getMeterWarningI18n();
                }
                case 2: {
                    return DisplayerSettingsEditor.this.view.getMeterCriticalI18n();
                }
                case 3: {
                    return DisplayerSettingsEditor.this.view.getMeterEndI18n();
                }
            }
            return DisplayerSettingsEditor.this.view.getMeterUnknownI18n();
        }

        @Override
        public boolean validate(Object value) {
            if (!super.validate(value)) {
                return false;
            }
            long thisLevel = Long.parseLong(value.toString());
            long lowerLevel = this.getLevelValue(this.level - 1);
            long upperLevel = this.getLevelValue(this.level + 1);
            this.lowerOk = thisLevel >= lowerLevel;
            this.upperOk = thisLevel <= upperLevel;
            return this.lowerOk && this.upperOk;
        }

        @Override
        public String getValidatorErrorMessage() {
            if (!this.lowerOk) {
                return DisplayerSettingsEditor.this.view.getMeterValidationHigherI18n(this.getLevelDescr(this.level - 1));
            }
            if (!this.upperOk) {
                return DisplayerSettingsEditor.this.view.getMeterValidationLowerI18n(this.getLevelDescr(this.level + 1));
            }
            return DisplayerSettingsEditor.this.view.getMeterValidationInvalidI18n();
        }
    }

    public class DoubleValidator
    implements PropertyFieldValidator {
        public boolean validate(Object value) {
            try {
                Double.parseDouble(value.toString());
                return true;
            }
            catch (Exception e) {
                return false;
            }
        }

        public String getValidatorErrorMessage() {
            return DisplayerSettingsEditor.this.view.getDoubleValidationFailedI18n();
        }
    }

    public class LongValidator
    implements PropertyFieldValidator {
        public boolean validate(Object value) {
            try {
                Long.parseLong(value.toString());
                return true;
            }
            catch (Exception e) {
                return false;
            }
        }

        public String getValidatorErrorMessage() {
            return DisplayerSettingsEditor.this.view.getIntegerValidationFailedI18n();
        }
    }

    public static interface View
    extends UberView<DisplayerSettingsEditor> {
        public void clear();

        public void show();

        public void dataSetNotFound();

        public void error(String var1);

        public void addCategory(DisplayerAttributeDef var1);

        public void addTextProperty(DisplayerAttributeDef var1, String var2, PropertyFieldValidator ... var3);

        public void addTextProperty(String var1, String var2, String var3, PropertyFieldValidator ... var4);

        public void addBooleanProperty(DisplayerAttributeDef var1, boolean var2);

        public void addColorProperty(DisplayerAttributeDef var1, String var2);

        public void addListProperty(DisplayerAttributeDef var1, List<String> var2, String var3);

        public String getColumnNameI18n();

        public String getColumnExpressionI18n();

        public String getColumnPatternI18n();

        public String getPositionLiteralI18n(Position var1);

        public String getIntegerValidationFailedI18n();

        public String getDoubleValidationFailedI18n();

        public String getMeterStartI18n();

        public String getMeterWarningI18n();

        public String getMeterCriticalI18n();

        public String getMeterEndI18n();

        public String getMeterUnknownI18n();

        public String getMeterValidationHigherI18n(String var1);

        public String getMeterValidationLowerI18n(String var1);

        public String getMeterValidationInvalidI18n();

        public String getMapColorSchemeI18n(MapColorScheme var1);
    }
}

