/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.displayer.client.widgets.group;

import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.List;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.dashbuilder.dataset.ColumnType;
import org.dashbuilder.dataset.DataSetMetadata;
import org.dashbuilder.dataset.group.AggregateFunctionType;
import org.dashbuilder.dataset.group.GroupFunction;
import org.dashbuilder.displayer.client.events.GroupFunctionChangedEvent;
import org.dashbuilder.displayer.client.events.GroupFunctionDeletedEvent;
import org.dashbuilder.displayer.client.widgets.group.ColumnDetailsEditor;
import org.uberfire.client.mvp.UberView;

@Dependent
public class ColumnFunctionEditor
implements IsWidget {
    View view = null;
    GroupFunction groupFunction = null;
    ColumnType targetType = null;
    boolean functionsEnabled = false;
    DataSetMetadata metadata = null;
    ColumnDetailsEditor columnDetailsEditor = null;
    Event<GroupFunctionChangedEvent> changeEvent = null;
    Event<GroupFunctionDeletedEvent> deleteEvent = null;

    @Inject
    public ColumnFunctionEditor(View view, ColumnDetailsEditor columnDetailsEditor, Event<GroupFunctionChangedEvent> changeEvent, Event<GroupFunctionDeletedEvent> deleteEvent) {
        this.view = view;
        this.columnDetailsEditor = columnDetailsEditor;
        this.changeEvent = changeEvent;
        this.deleteEvent = deleteEvent;
        this.view.init(this);
    }

    public Widget asWidget() {
        return this.view.asWidget();
    }

    public GroupFunction getGroupFunction() {
        return this.groupFunction;
    }

    public ColumnType getTargetType() {
        return this.targetType;
    }

    public ColumnDetailsEditor getColumnDetailsEditor() {
        return this.columnDetailsEditor;
    }

    public void init(DataSetMetadata metadata, GroupFunction groupFunction, ColumnType targetType, String columnTitle, boolean functionsEnabled, boolean canDelete) {
        this.groupFunction = groupFunction;
        this.targetType = targetType;
        this.metadata = metadata;
        this.functionsEnabled = functionsEnabled;
        this.columnDetailsEditor.init(metadata, this.groupFunction);
        this.view.setColumnSelectorTitle(columnTitle);
        this.view.setDeleteOptionEnabled(canDelete);
        this.initColumnListBox();
        if (functionsEnabled && (targetType == null || this.isColumnNumeric())) {
            this.view.setFunctionSelectorEnabled(true);
            this.initFunctionListBox();
        } else {
            this.view.setFunctionSelectorEnabled(false);
        }
    }

    public void delete() {
        this.deleteEvent.fire((Object)new GroupFunctionDeletedEvent(this.groupFunction));
    }

    void onColumnSelected() {
        this.groupFunction.setSourceId(this.view.getSelectedColumnId());
        if (!this.isColumnNumeric()) {
            this.groupFunction.setFunction(null);
        } else {
            this.groupFunction.setFunction(this.getSupportedFunctionTypes().get(0));
        }
        this.initFunctionListBox();
        this.changeEvent.fire((Object)new GroupFunctionChangedEvent(this.groupFunction));
    }

    void onFunctionSelected() {
        AggregateFunctionType selected = null;
        int i = this.view.getSelectedFunctionIndex();
        if (i >= 0) {
            List<AggregateFunctionType> supportedFunctions = this.getSupportedFunctionTypes();
            selected = supportedFunctions.get(i);
        }
        this.groupFunction.setFunction(selected);
        this.changeEvent.fire((Object)new GroupFunctionChangedEvent(this.groupFunction));
    }

    protected boolean isColumnNumeric() {
        return this.targetType != null && this.targetType.equals((Object)ColumnType.NUMBER) && this.functionsEnabled;
    }

    protected void initColumnListBox() {
        this.view.clearColumnSelector();
        for (int i = 0; i < this.metadata.getNumberOfColumns(); ++i) {
            String columnId = this.metadata.getColumnId(i);
            ColumnType columnType = this.metadata.getColumnType(i);
            if (this.targetType != null && columnType != null && !this.isColumnNumeric() && !this.targetType.equals((Object)columnType)) continue;
            this.view.addColumnItem(columnId);
            if (columnId == null || !columnId.equals(this.groupFunction.getSourceId())) continue;
            this.view.setSelectedColumnIndex(i);
        }
    }

    protected void initFunctionListBox() {
        this.view.clearFunctionSelector();
        this.view.setVoidFunctionEnabled(!this.isColumnNumeric());
        AggregateFunctionType selected = this.groupFunction.getFunction();
        List<AggregateFunctionType> supportedFunctions = this.getSupportedFunctionTypes();
        for (int i = 0; i < supportedFunctions.size(); ++i) {
            AggregateFunctionType functionType = supportedFunctions.get(i);
            this.view.addFunctionItem(functionType);
            if (selected == null || !functionType.equals((Object)selected)) continue;
            this.view.setSelectedFunctionIndex(i);
        }
    }

    public List<AggregateFunctionType> getSupportedFunctionTypes() {
        ColumnType columnType = this.metadata.getColumnType(this.groupFunction.getSourceId());
        return this.getSupportedFunctionTypes(columnType);
    }

    public List<AggregateFunctionType> getSupportedFunctionTypes(ColumnType columnType) {
        ArrayList<AggregateFunctionType> result = new ArrayList<AggregateFunctionType>();
        for (AggregateFunctionType function : AggregateFunctionType.values()) {
            if (!function.supportType(columnType)) continue;
            result.add(function);
        }
        return result;
    }

    public static interface View
    extends UberView<ColumnFunctionEditor> {
        public void setDeleteOptionEnabled(boolean var1);

        public void setColumnSelectorTitle(String var1);

        public void clearColumnSelector();

        public void addColumnItem(String var1);

        public void setSelectedColumnIndex(int var1);

        public String getSelectedColumnId();

        public void setFunctionSelectorEnabled(boolean var1);

        public void clearFunctionSelector();

        public void setVoidFunctionEnabled(boolean var1);

        public void addFunctionItem(AggregateFunctionType var1);

        public void setSelectedFunctionIndex(int var1);

        public int getSelectedFunctionIndex();
    }
}

