/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.displayer.client.widgets;

import java.util.Arrays;
import java.util.List;
import org.dashbuilder.displayer.DisplayerSettings;
import org.dashbuilder.displayer.DisplayerSettingsFactory;
import org.dashbuilder.displayer.DisplayerSubType;
import org.dashbuilder.displayer.DisplayerType;
import org.dashbuilder.displayer.client.AbstractRendererLibrary;
import org.dashbuilder.displayer.client.Displayer;
import org.dashbuilder.displayer.client.RendererLibrary;
import org.dashbuilder.displayer.client.RendererManager;
import org.dashbuilder.displayer.client.widgets.RendererSelector;
import org.dashbuilder.displayer.impl.PieChartSettingsBuilderImpl;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.uberfire.mvp.Command;

@RunWith(value=MockitoJUnitRunner.class)
public class RendererSelectorTest {
    @Mock
    RendererSelector.RadioListView radioListView;
    @Mock
    RendererSelector.TabListView tabListView;
    @Mock
    RendererSelector.ListBoxView listBoxView;
    @Mock
    RendererManager rendererManager;
    @Mock
    Command selectCommand;
    RendererLibMock gwtLib = new RendererLibMock("gwt");
    RendererLibMock d3Lib = new RendererLibMock("d3");
    RendererLibMock lienzoLib = new RendererLibMock("lienzo");
    DisplayerSettings settings = ((PieChartSettingsBuilderImpl)DisplayerSettingsFactory.newPieChartSettings().renderer("d3")).buildSettings();
    RendererSelector presenter;

    @Before
    public void init() {
        this.presenter = new RendererSelector(this.tabListView, this.listBoxView, this.radioListView, this.rendererManager);
    }

    @Test
    public void testSingleRenderer() {
        List<RendererLibrary> rendererLibs = Arrays.asList(new RendererLibrary[]{this.d3Lib});
        Mockito.when((Object)this.rendererManager.getRenderersForType((DisplayerType)Matchers.any(DisplayerType.class), (DisplayerSubType)Matchers.any(DisplayerSubType.class))).thenReturn(rendererLibs);
        Mockito.when((Object)this.rendererManager.getRendererForDisplayer(this.settings)).thenReturn((Object)this.d3Lib);
        this.presenter.init(this.settings, RendererSelector.SelectorType.TAB, 300, this.selectCommand);
        ((RendererSelector.TabListView)Mockito.verify((Object)this.tabListView)).setVisible(false);
        ((RendererSelector.TabListView)Mockito.verify((Object)this.tabListView, (VerificationMode)Mockito.never())).setWidth(Mockito.anyInt());
        ((RendererSelector.TabListView)Mockito.verify((Object)this.tabListView, (VerificationMode)Mockito.never())).clearRendererSelector();
        ((RendererSelector.TabListView)Mockito.verify((Object)this.tabListView, (VerificationMode)Mockito.never())).addRendererItem(Mockito.anyString());
        ((RendererSelector.TabListView)Mockito.verify((Object)this.tabListView, (VerificationMode)Mockito.never())).setSelectedRendererIndex(Mockito.anyInt());
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.listBoxView, this.radioListView});
    }

    @Test
    public void testMultipleRenderers() {
        List<RendererLibrary> rendererLibs = Arrays.asList(new RendererLibrary[]{this.gwtLib, this.d3Lib, this.lienzoLib});
        Mockito.when((Object)this.rendererManager.getRenderersForType((DisplayerType)Matchers.any(DisplayerType.class), (DisplayerSubType)Matchers.any(DisplayerSubType.class))).thenReturn(rendererLibs);
        Mockito.when((Object)this.rendererManager.getRendererForDisplayer(this.settings)).thenReturn((Object)this.d3Lib);
        this.presenter.init(this.settings, RendererSelector.SelectorType.LIST, 300, this.selectCommand);
        ((RendererSelector.ListBoxView)Mockito.verify((Object)this.listBoxView)).setVisible(true);
        ((RendererSelector.ListBoxView)Mockito.verify((Object)this.listBoxView)).setWidth(300);
        ((RendererSelector.ListBoxView)Mockito.verify((Object)this.listBoxView)).clearRendererSelector();
        ((RendererSelector.ListBoxView)Mockito.verify((Object)this.listBoxView)).addRendererItem("gwt");
        ((RendererSelector.ListBoxView)Mockito.verify((Object)this.listBoxView)).addRendererItem("d3");
        ((RendererSelector.ListBoxView)Mockito.verify((Object)this.listBoxView)).addRendererItem("lienzo");
        ((RendererSelector.ListBoxView)Mockito.verify((Object)this.listBoxView)).setSelectedRendererIndex(1);
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.tabListView, this.radioListView});
    }

    @Test
    public void testOnSelect() {
        List<RendererLibrary> rendererLibs = Arrays.asList(new RendererLibrary[]{this.gwtLib, this.d3Lib});
        Mockito.when((Object)this.rendererManager.getRenderersForType((DisplayerType)Matchers.any(DisplayerType.class), (DisplayerSubType)Matchers.any(DisplayerSubType.class))).thenReturn(rendererLibs);
        Mockito.when((Object)this.rendererManager.getRendererForDisplayer(this.settings)).thenReturn((Object)this.d3Lib);
        Mockito.when((Object)this.rendererManager.getRendererByName(this.gwtLib.getName())).thenReturn((Object)this.gwtLib);
        Mockito.when((Object)this.tabListView.getRendererSelected()).thenReturn((Object)this.gwtLib.getName());
        this.presenter.init(this.settings, RendererSelector.SelectorType.TAB, 300, this.selectCommand);
        this.presenter.onRendererSelected();
        ((Command)Mockito.verify((Object)this.selectCommand)).execute();
        Assert.assertEquals((Object)this.presenter.getRendererLibrary(), (Object)((Object)this.gwtLib));
    }

    class RendererLibMock
    extends AbstractRendererLibrary {
        String name;

        public RendererLibMock(String name) {
            this.name = name;
        }

        public String getUUID() {
            return null;
        }

        public String getName() {
            return this.name;
        }

        public List<DisplayerType> getSupportedTypes() {
            return null;
        }

        public List<DisplayerSubType> getSupportedSubtypes(DisplayerType displayerType) {
            return null;
        }

        public Displayer lookupDisplayer(DisplayerSettings displayer) {
            return null;
        }
    }
}

