/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.displayer.client.widgets.sourcecode;

import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Widget;
import java.util.HashMap;
import java.util.Map;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.dashbuilder.displayer.client.widgets.sourcecode.HtmlValidator;
import org.dashbuilder.displayer.client.widgets.sourcecode.JsValidator;
import org.dashbuilder.displayer.client.widgets.sourcecode.SourceCodeType;
import org.uberfire.client.mvp.UberView;
import org.uberfire.mvp.Command;

@Dependent
public class SourceCodeEditor
implements IsWidget {
    View view;
    SourceCodeType type;
    String code;
    Command onSourceCodeChanged;
    HtmlValidator htmlValidator;
    JsValidator jsValidator;
    boolean hasErrors = false;
    Map<String, String> varMap;

    @Inject
    public SourceCodeEditor(View view, HtmlValidator htmlValidator, JsValidator jsValidator) {
        this.view = view;
        this.htmlValidator = htmlValidator;
        this.jsValidator = jsValidator;
        view.init(this);
    }

    public Widget asWidget() {
        return this.view.asWidget();
    }

    public String getCode() {
        return this.code;
    }

    public boolean hasErrors() {
        return this.hasErrors;
    }

    public void init(SourceCodeType type, String code, Map<String, String> varMap, Command onSourceCodeChanged) {
        this.type = type;
        this.code = code;
        this.varMap = varMap == null ? new HashMap() : varMap;
        this.hasErrors = false;
        this.onSourceCodeChanged = onSourceCodeChanged;
        this.view.clearAll();
        this.view.edit(type, code);
        this.view.focus();
        for (String var : varMap.keySet()) {
            this.view.declareVariable(var, (String)varMap.get(var));
        }
        String error = this.validateSourceCode(code);
        if (error != null) {
            this.hasErrors = true;
            this.view.error(error);
        }
    }

    public void focus() {
        this.view.focus();
    }

    public String validateSourceCode(String newCode) {
        if (newCode != null && newCode.length() > 0) {
            switch (this.type) {
                case JAVASCRIPT: {
                    return this.jsValidator.validate(newCode, this.varMap.keySet());
                }
                case HTML: {
                    return this.htmlValidator.validate(newCode);
                }
            }
        }
        return null;
    }

    public void onVariableSelected(String var) {
        this.view.injectVariable(var);
        this.view.focus();
    }

    public boolean onSourceCodeChanged(String newCode) {
        String error = this.validateSourceCode(newCode);
        if (error != null) {
            this.hasErrors = true;
            this.view.error(error);
            this.view.focus();
            return false;
        }
        this.code = newCode;
        this.hasErrors = false;
        this.view.clearError();
        this.onSourceCodeChanged.execute();
        return true;
    }

    public static interface View
    extends UberView<SourceCodeEditor> {
        public void clearAll();

        public void edit(SourceCodeType var1, String var2);

        public void declareVariable(String var1, String var2);

        public void injectVariable(String var1);

        public void focus();

        public void error(String var1);

        public void clearError();
    }
}

