/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.displayer.client.widgets;

import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import org.dashbuilder.displayer.client.widgets.ExternalComponentPropertiesEditor;
import org.dashbuilder.external.model.ComponentParameter;
import org.dashbuilder.external.model.ExternalComponent;
import org.dashbuilder.external.service.ExternalComponentService;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.Captor;
import org.mockito.InjectMocks;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.uberfire.ext.properties.editor.model.PropertyEditorCategory;
import org.uberfire.ext.widgets.common.client.common.BusyIndicatorView;
import org.uberfire.mocks.CallerMock;

@RunWith(value=GwtMockitoTestRunner.class)
public class ExternalComponentPropertiesEditorTest {
    @Mock
    ExternalComponentService externalComponentServiceMock;
    @Mock
    ExternalComponentPropertiesEditor.View view;
    @Mock
    BusyIndicatorView loading;
    @Captor
    ArgumentCaptor<Collection<PropertyEditorCategory>> categoriesCaptor;
    CallerMock<ExternalComponentService> externalComponentService;
    @InjectMocks
    ExternalComponentPropertiesEditor externalComponentPropertiesEditor;

    @Before
    public void init() {
        this.externalComponentService = new CallerMock((Object)this.externalComponentServiceMock);
        this.externalComponentPropertiesEditor.setExternalComponentService(this.externalComponentService);
    }

    @Test
    public void testComponentNotFound() {
        String c1 = "c1";
        Mockito.when((Object)this.externalComponentServiceMock.byId(Matchers.matches((String)c1))).thenReturn(Optional.empty());
        this.externalComponentPropertiesEditor.init(c1, Collections.emptyMap(), props -> {});
        ((ExternalComponentPropertiesEditor.View)Mockito.verify((Object)this.view)).componentNotFound();
    }

    @Test
    public void testNoProperties() {
        ExternalComponent c1 = new ExternalComponent("c1", "c1 name", "c1 icon", false, Collections.emptyList());
        Mockito.when((Object)this.externalComponentServiceMock.byId(Matchers.matches((String)c1.getId()))).thenReturn(Optional.of(c1));
        this.externalComponentPropertiesEditor.init(c1.getId(), Collections.emptyMap(), props -> {});
        ((ExternalComponentPropertiesEditor.View)Mockito.verify((Object)this.view)).noPropertiesComponent();
    }

    @Test
    public void testLoadProperties() {
        ComponentParameter p1 = this.param("P1 CAT", "p1val", "text", "P1 Field", "p1", Collections.emptyList());
        ComponentParameter p2 = this.param("P2 CAT", "p2val", "combo", "P2 Field", "p2", Arrays.asList("V1", "V2"));
        ExternalComponent c1 = new ExternalComponent("c1", "c1 name", "c1 icon", false, Arrays.asList(p1, p2));
        Mockito.when((Object)this.externalComponentServiceMock.byId(Matchers.matches((String)c1.getId()))).thenReturn(Optional.of(c1));
        this.externalComponentPropertiesEditor.init(c1.getId(), new HashMap(), props -> {});
        ((ExternalComponentPropertiesEditor.View)Mockito.verify((Object)this.view)).addCategories((Collection)this.categoriesCaptor.capture());
        Collection categories = (Collection)this.categoriesCaptor.getValue();
        Assert.assertEquals((long)3L, (long)categories.size());
    }

    private ComponentParameter param(String category, String defaultValue, String type, String label, String name, List<String> comboValues) {
        return new ComponentParameter(name, type, category, defaultValue, label, comboValues);
    }
}

