/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.displayer.client.widgets;

import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Composite;
import elemental2.dom.DomGlobal;
import elemental2.dom.HTMLDivElement;
import elemental2.dom.HTMLIFrameElement;
import elemental2.dom.MessageEvent;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import jsinterop.base.Js;
import org.dashbuilder.displayer.client.widgets.ExternalComponentPresenter;
import org.dashbuilder.displayer.external.ExternalComponentMessage;
import org.jboss.errai.ui.shared.api.annotations.DataField;
import org.jboss.errai.ui.shared.api.annotations.Templated;

@Dependent
@Templated
public class ExternalComponentView
extends Composite
implements ExternalComponentPresenter.View {
    @Inject
    @DataField
    HTMLDivElement componentRoot;
    @Inject
    @DataField
    HTMLIFrameElement externalComponentIFrame;
    private boolean componentReady = false;
    private JavaScriptObject lastProps;
    private ExternalComponentMessage lastMessage;

    public void init(ExternalComponentPresenter presenter) {
        DomGlobal.window.addEventListener("message", e -> {
            MessageEvent event = (MessageEvent)Js.cast((Object)e);
            if (event.data instanceof ExternalComponentMessage) {
                ExternalComponentMessage message = (ExternalComponentMessage)Js.cast((Object)event.data);
                presenter.receiveMessage(message);
            }
        });
    }

    @Override
    public void setComponentURL(String url) {
        this.externalComponentIFrame.src = url;
        this.componentReady = false;
        this.externalComponentIFrame.onload = e -> {
            this.componentReady = true;
            if (this.lastProps != null) {
                this.postMessageToComponent(this.lastProps);
            }
            if (this.lastMessage != null) {
                this.postMessageToComponent(this.lastMessage);
            }
            return null;
        };
    }

    @Override
    public void postMessage(ExternalComponentMessage message) {
        this.lastMessage = message;
        if (this.componentReady) {
            this.postMessageToComponent(message);
        }
    }

    private void postMessageToComponent(Object message) {
        if (this.externalComponentIFrame != null && this.externalComponentIFrame.contentWindow != null) {
            this.externalComponentIFrame.contentWindow.postMessage(message, Window.Location.getHref());
        }
    }
}

