/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.displayer.client.component.function;

import java.util.Collections;
import java.util.Optional;
import org.dashbuilder.displayer.client.component.function.ComponentFunctionLocator;
import org.dashbuilder.displayer.client.component.function.ExternalComponentFunction;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class ComponentFunctionLocatorTest {
    private final String F1_NAME = "f1";
    private ExternalComponentFunction f1;
    private ComponentFunctionLocator locator;

    @Before
    public void prepare() {
        this.locator = new ComponentFunctionLocator();
        this.f1 = (ExternalComponentFunction)Mockito.mock(ExternalComponentFunction.class);
        Mockito.when((Object)this.f1.getName()).thenReturn((Object)"f1");
        this.locator.functions = Collections.singletonList(this.f1);
    }

    @Test
    public void testFindFunctionByName() {
        Optional result = this.locator.findFunctionByName("f1");
        Assert.assertEquals((Object)this.f1, result.get());
    }

    @Test
    public void testFindFunctionByNameNotFound() {
        Optional result = this.locator.findFunctionByName("not found");
        Assert.assertFalse((boolean)result.isPresent());
    }
}

