/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.displayer.client;

import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.dashbuilder.common.client.error.ClientRuntimeError;
import org.dashbuilder.dataset.ColumnType;
import org.dashbuilder.dataset.DataColumn;
import org.dashbuilder.dataset.client.AbstractDataSetTest;
import org.dashbuilder.dataset.client.DataSetReadyCallback;
import org.dashbuilder.dataset.impl.DataColumnImpl;
import org.dashbuilder.displayer.DisplayerSettings;
import org.dashbuilder.displayer.DisplayerSettingsFactory;
import org.dashbuilder.displayer.client.AbstractDisplayer;
import org.dashbuilder.displayer.client.AbstractDisplayerListener;
import org.dashbuilder.displayer.client.DataSetHandler;
import org.dashbuilder.displayer.client.DataSetHandlerImpl;
import org.dashbuilder.displayer.client.Displayer;
import org.dashbuilder.displayer.client.DisplayerEvaluatorMock;
import org.dashbuilder.displayer.client.DisplayerFormatterMock;
import org.dashbuilder.displayer.client.DisplayerListener;
import org.dashbuilder.displayer.client.DisplayerLocator;
import org.dashbuilder.displayer.client.DisplayerMock;
import org.dashbuilder.displayer.client.RendererLibrary;
import org.dashbuilder.displayer.client.RendererManager;
import org.dashbuilder.displayer.client.formatter.ValueFormatterRegistry;
import org.dashbuilder.displayer.impl.TableDisplayerSettingsBuilderImpl;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.Silent.class)
public class AbstractDisplayerTest
extends AbstractDataSetTest {
    @Mock
    protected RendererManager rendererManager;
    @Mock
    protected RendererLibrary rendererLibrary;
    @Mock
    protected ValueFormatterRegistry formatterRegistry;
    protected DisplayerLocator displayerLocator;

    @Before
    public void init() throws Exception {
        super.init();
        this.displayerLocator = new DisplayerLocator(this.clientServices, this.clientDataSetManager, this.rendererManager, this.formatterRegistry);
        Mockito.when((Object)this.rendererManager.getRendererForDisplayer((DisplayerSettings)Matchers.any(DisplayerSettings.class))).thenReturn((Object)this.rendererLibrary);
        ((RendererLibrary)Mockito.doAnswer(mock -> this.createNewDisplayer((DisplayerSettings)mock.getArguments()[0])).when((Object)this.rendererLibrary)).lookupDisplayer((DisplayerSettings)Matchers.any(DisplayerSettings.class));
        ((RendererLibrary)Mockito.doAnswer(mock -> this.createNewDisplayer((DisplayerSettings)mock.getArguments()[0])).when((Object)this.rendererLibrary)).lookupDisplayer((DisplayerSettings)Matchers.any(DisplayerSettings.class));
        ((RendererLibrary)Mockito.doAnswer(mock -> {
            List displayerList = (List)mock.getArguments()[0];
            for (Displayer displayer : displayerList) {
                displayer.draw();
            }
            return null;
        }).when((Object)this.rendererLibrary)).draw(Matchers.anyListOf(Displayer.class));
    }

    public AbstractDisplayer createNewDisplayer(DisplayerSettings settings) {
        return this.initDisplayer(new DisplayerMock((AbstractDisplayer.View)Mockito.mock(AbstractDisplayer.View.class), null), settings);
    }

    public AbstractDisplayer createNewDisplayer(DisplayerSettings settings, boolean ignoreError) {
        return this.initDisplayer(new DisplayerMock((AbstractDisplayer.View)Mockito.mock(AbstractDisplayer.View.class), null, ignoreError), settings);
    }

    public <D extends AbstractDisplayer> D initDisplayer(D displayer, DisplayerSettings settings) {
        displayer.setEvaluator((AbstractDisplayer.ExpressionEval)new DisplayerEvaluatorMock());
        displayer.setFormatter((AbstractDisplayer.Formatter)new DisplayerFormatterMock());
        displayer.addListener(new DisplayerListener[]{new AbstractDisplayerListener(){

            public void onError(Displayer displayer, ClientRuntimeError error) {
                throw new RuntimeException(error.getRootCause());
            }
        }});
        if (settings != null) {
            displayer.setDisplayerSettings(settings);
            displayer.setDataSetHandler((DataSetHandler)new DataSetHandlerImpl(this.clientServices, settings.getDataSetLookup()));
        }
        return displayer;
    }

    @Test
    public void callbackOnErrorTest() throws Exception {
        DataSetHandler dataSetHandler = (DataSetHandler)Mockito.mock(DataSetHandler.class);
        DisplayerSettings simpleSettings = ((TableDisplayerSettingsBuilderImpl)((TableDisplayerSettingsBuilderImpl)DisplayerSettingsFactory.newTableSettings().dataset("expenses")).filterOn(true, false, true)).buildSettings();
        AbstractDisplayer simpleDisplayer = this.createNewDisplayer(simpleSettings, true);
        simpleDisplayer.listenerList = Collections.emptyList();
        simpleDisplayer.setDataSetHandler(dataSetHandler);
        simpleDisplayer.redraw();
        Assert.assertTrue((boolean)simpleDisplayer.isDrawn());
        ((DataSetHandler)Mockito.doAnswer(invocation -> {
            DataSetReadyCallback callback = (DataSetReadyCallback)invocation.getArguments()[0];
            callback.onError(new ClientRuntimeError("test"));
            return null;
        }).when((Object)dataSetHandler)).lookupDataSet((DataSetReadyCallback)Matchers.any());
        simpleDisplayer.redraw();
        Assert.assertTrue((!simpleDisplayer.isDrawn() ? 1 : 0) != 0);
    }

    @Test
    public void testFormatValue() throws Exception {
        DisplayerSettings simpleSettings = ((TableDisplayerSettingsBuilderImpl)((TableDisplayerSettingsBuilderImpl)DisplayerSettingsFactory.newTableSettings().dataset("expenses")).filterOn(true, false, true)).buildSettings();
        AbstractDisplayer simpleDisplayer = this.createNewDisplayer(simpleSettings, true);
        DataColumnImpl dateColumn = new DataColumnImpl();
        dateColumn.setId("proceesedDate");
        dateColumn.setColumnType(ColumnType.DATE);
        Date date1 = new SimpleDateFormat("dd/MM/yyyy").parse("28/10/2020");
        dateColumn.setValues(Arrays.asList(date1));
        Assert.assertEquals((Object)"Oct 28, 2020 00:00", (Object)simpleDisplayer.formatValue((Object)date1, (DataColumn)dateColumn));
        DataColumnImpl column = new DataColumnImpl();
        column.setId("slaCompliance");
        column.setColumnType(ColumnType.NUMBER);
        column.setValues(Arrays.asList(0));
        Assert.assertEquals((Object)"0.00", (Object)simpleDisplayer.formatValue((Object)0, (DataColumn)column));
        DataColumnImpl numberColumn = new DataColumnImpl();
        numberColumn.setId("slaCompliance");
        numberColumn.setColumnType(ColumnType.NUMBER);
        numberColumn.setValues(Arrays.asList("0"));
        Assert.assertEquals((Object)"0.00", (Object)simpleDisplayer.formatValue((Object)"0", (DataColumn)numberColumn));
        DataColumnImpl emptyNumberColumn = new DataColumnImpl();
        emptyNumberColumn.setId("dataId");
        emptyNumberColumn.setColumnType(ColumnType.NUMBER);
        emptyNumberColumn.setValues(Arrays.asList(""));
        Assert.assertEquals((Object)"", (Object)simpleDisplayer.formatValue((Object)"", (DataColumn)emptyNumberColumn));
        DataColumnImpl textColumn = new DataColumnImpl();
        textColumn.setId("dataId");
        textColumn.setColumnType(ColumnType.TEXT);
        textColumn.setValues(Arrays.asList("test"));
        Assert.assertEquals((Object)"test", (Object)simpleDisplayer.formatValue((Object)"test", (DataColumn)textColumn));
    }
}

