/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.displayer.client.widgets;

import java.util.Arrays;
import org.dashbuilder.dataset.DataSetFactory;
import org.dashbuilder.dataset.client.DataSetReadyCallback;
import org.dashbuilder.dataset.sort.SortOrder;
import org.dashbuilder.displayer.DisplayerAttributeDef;
import org.dashbuilder.displayer.DisplayerAttributeGroupDef;
import org.dashbuilder.displayer.DisplayerConstraints;
import org.dashbuilder.displayer.DisplayerSettings;
import org.dashbuilder.displayer.DisplayerSettingsFactory;
import org.dashbuilder.displayer.DisplayerType;
import org.dashbuilder.displayer.Position;
import org.dashbuilder.displayer.client.DataSetHandler;
import org.dashbuilder.displayer.client.Displayer;
import org.dashbuilder.displayer.client.DisplayerLocator;
import org.dashbuilder.displayer.client.RendererLibrary;
import org.dashbuilder.displayer.client.RendererManager;
import org.dashbuilder.displayer.client.events.DisplayerSettingsChangedEvent;
import org.dashbuilder.displayer.client.widgets.DisplayerSettingsEditor;
import org.dashbuilder.displayer.impl.BarChartSettingsBuilderImpl;
import org.dashbuilder.displayer.impl.MeterChartSettingsBuilderImpl;
import org.dashbuilder.displayer.impl.TableDisplayerSettingsBuilderImpl;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import org.uberfire.ext.properties.editor.model.validators.PropertyFieldValidator;
import org.uberfire.mocks.EventSourceMock;

@RunWith(value=MockitoJUnitRunner.class)
public class DisplayerSettingsEditorTest {
    @Mock
    DisplayerSettingsEditor.View view;
    @Mock
    Displayer displayer;
    @Mock
    DataSetHandler dataSetHandler;
    @Mock
    EventSourceMock<DisplayerSettingsChangedEvent> event;
    @Mock
    DisplayerLocator displayerLocator;
    @Mock
    RendererManager rendererManager;
    @Mock
    RendererLibrary rendererA;
    @Mock
    RendererLibrary rendererB;
    DisplayerSettingsEditor presenter;

    @Before
    public void init() throws Exception {
        Mockito.when((Object)this.rendererManager.getRenderersForType((DisplayerType)Matchers.any(DisplayerType.class))).thenReturn(Arrays.asList(this.rendererA, this.rendererB));
        Mockito.when((Object)this.rendererA.getUUID()).thenReturn((Object)"rendererA");
        Mockito.when((Object)this.rendererB.getUUID()).thenReturn((Object)"rendererB");
        Mockito.when((Object)this.rendererManager.getRendererForDisplayer((DisplayerSettings)Matchers.any(DisplayerSettings.class))).thenReturn((Object)this.rendererB);
        Mockito.when((Object)this.displayer.getDataSetHandler()).thenReturn((Object)this.dataSetHandler);
        Mockito.when((Object)this.displayer.getDisplayerConstraints()).thenReturn((Object)new DisplayerConstraints(null).supportsAttribute(DisplayerAttributeGroupDef.TYPE).supportsAttribute(DisplayerAttributeGroupDef.SUBTYPE).supportsAttribute(DisplayerAttributeGroupDef.RENDERER).supportsAttribute((DisplayerAttributeDef)DisplayerAttributeGroupDef.GENERAL_GROUP).supportsAttribute((DisplayerAttributeDef)DisplayerAttributeGroupDef.COLUMNS_GROUP).supportsAttribute((DisplayerAttributeDef)DisplayerAttributeGroupDef.REFRESH_GROUP).supportsAttribute((DisplayerAttributeDef)DisplayerAttributeGroupDef.FILTER_GROUP).supportsAttribute((DisplayerAttributeDef)DisplayerAttributeGroupDef.CHART_GROUP).supportsAttribute((DisplayerAttributeDef)DisplayerAttributeGroupDef.TABLE_GROUP).supportsAttribute((DisplayerAttributeDef)DisplayerAttributeGroupDef.AXIS_GROUP).supportsAttribute((DisplayerAttributeDef)DisplayerAttributeGroupDef.METER_GROUP));
        this.presenter = new DisplayerSettingsEditor(this.view, this.displayerLocator, this.rendererManager, this.event);
        ((DataSetHandler)Mockito.doAnswer((Answer)new Answer(){

            public Object answer(InvocationOnMock invocationOnMock) throws Throwable {
                DisplayerSettingsEditorTest.this.presenter.show();
                return null;
            }
        }).when((Object)this.dataSetHandler)).lookupDataSet((DataSetReadyCallback)Matchers.any(DataSetReadyCallback.class));
    }

    @Test
    public void testGeneralSettings() {
        Mockito.when((Object)this.dataSetHandler.getLastDataSet()).thenReturn((Object)DataSetFactory.newDataSetBuilder().label("dept").number("amount").buildDataSet());
        Mockito.when((Object)this.displayer.getDisplayerSettings()).thenReturn((Object)((BarChartSettingsBuilderImpl)((BarChartSettingsBuilderImpl)((BarChartSettingsBuilderImpl)((BarChartSettingsBuilderImpl)((BarChartSettingsBuilderImpl)((BarChartSettingsBuilderImpl)((BarChartSettingsBuilderImpl)((BarChartSettingsBuilderImpl)((BarChartSettingsBuilderImpl)((BarChartSettingsBuilderImpl)((BarChartSettingsBuilderImpl)((BarChartSettingsBuilderImpl)((BarChartSettingsBuilderImpl)((BarChartSettingsBuilderImpl)((BarChartSettingsBuilderImpl)((BarChartSettingsBuilderImpl)((BarChartSettingsBuilderImpl)DisplayerSettingsFactory.newBarChartSettings().dataset("dset")).group("dept")).column("dept")).format("Department")).column("amount")).format("Total", "#.##0")).expression("value/100")).title("Sales by dept")).titleVisible(true)).legendOn(Position.BOTTOM)).width(400)).height(200)).xAxisTitle("Depts")).yAxisTitle("Amount $")).margins(10, 80, 80, 100)).filterOn(false, true, true)).refreshOn(3, false)).buildSettings());
        this.presenter.init(this.displayer);
        ((DisplayerSettingsEditor.View)Mockito.verify((Object)this.view)).clear();
        ((DisplayerSettingsEditor.View)Mockito.verify((Object)this.view)).addTextProperty(DisplayerAttributeGroupDef.TITLE, "Sales by dept", new PropertyFieldValidator[0]);
        ((DisplayerSettingsEditor.View)Mockito.verify((Object)this.view)).addBooleanProperty(DisplayerAttributeGroupDef.TITLE_VISIBLE, true);
        ((DisplayerSettingsEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).addBooleanProperty(DisplayerAttributeGroupDef.EXPORT_TO_CSV, false);
        ((DisplayerSettingsEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).addBooleanProperty(DisplayerAttributeGroupDef.EXPORT_TO_XLS, false);
        ((DisplayerSettingsEditor.View)Mockito.verify((Object)this.view)).addTextProperty((DisplayerAttributeDef)Mockito.eq((Object)DisplayerAttributeGroupDef.CHART_WIDTH), (String)Mockito.eq((Object)"400"), new PropertyFieldValidator[]{(PropertyFieldValidator)Matchers.any(DisplayerSettingsEditor.LongValidator.class)});
        ((DisplayerSettingsEditor.View)Mockito.verify((Object)this.view)).addTextProperty((DisplayerAttributeDef)Mockito.eq((Object)DisplayerAttributeGroupDef.CHART_HEIGHT), (String)Mockito.eq((Object)"200"), new PropertyFieldValidator[]{(PropertyFieldValidator)Matchers.any(DisplayerSettingsEditor.LongValidator.class)});
        ((DisplayerSettingsEditor.View)Mockito.verify((Object)this.view)).addColorProperty((DisplayerAttributeDef)Mockito.eq((Object)DisplayerAttributeGroupDef.CHART_BGCOLOR), Mockito.anyString());
        ((DisplayerSettingsEditor.View)Mockito.verify((Object)this.view)).addBooleanProperty(DisplayerAttributeGroupDef.CHART_3D, false);
        ((DisplayerSettingsEditor.View)Mockito.verify((Object)this.view)).addTextProperty((DisplayerAttributeDef)Mockito.eq((Object)DisplayerAttributeGroupDef.CHART_MARGIN_TOP), (String)Mockito.eq((Object)"10"), new PropertyFieldValidator[]{(PropertyFieldValidator)Matchers.any(DisplayerSettingsEditor.LongValidator.class)});
        ((DisplayerSettingsEditor.View)Mockito.verify((Object)this.view)).addTextProperty((DisplayerAttributeDef)Mockito.eq((Object)DisplayerAttributeGroupDef.CHART_MARGIN_BOTTOM), (String)Mockito.eq((Object)"80"), new PropertyFieldValidator[]{(PropertyFieldValidator)Matchers.any(DisplayerSettingsEditor.LongValidator.class)});
        ((DisplayerSettingsEditor.View)Mockito.verify((Object)this.view)).addTextProperty((DisplayerAttributeDef)Mockito.eq((Object)DisplayerAttributeGroupDef.CHART_MARGIN_LEFT), (String)Mockito.eq((Object)"80"), new PropertyFieldValidator[]{(PropertyFieldValidator)Matchers.any(DisplayerSettingsEditor.LongValidator.class)});
        ((DisplayerSettingsEditor.View)Mockito.verify((Object)this.view)).addTextProperty((DisplayerAttributeDef)Mockito.eq((Object)DisplayerAttributeGroupDef.CHART_MARGIN_RIGHT), (String)Mockito.eq((Object)"100"), new PropertyFieldValidator[]{(PropertyFieldValidator)Matchers.any(DisplayerSettingsEditor.LongValidator.class)});
        ((DisplayerSettingsEditor.View)Mockito.verify((Object)this.view)).addBooleanProperty(DisplayerAttributeGroupDef.CHART_SHOWLEGEND, true);
        ((DisplayerSettingsEditor.View)Mockito.verify((Object)this.view)).addListProperty((DisplayerAttributeDef)Mockito.eq((Object)DisplayerAttributeGroupDef.CHART_LEGENDPOSITION), Mockito.anyList(), (String)Matchers.any());
        ((DisplayerSettingsEditor.View)Mockito.verify((Object)this.view)).addBooleanProperty(DisplayerAttributeGroupDef.XAXIS_SHOWLABELS, true);
        ((DisplayerSettingsEditor.View)Mockito.verify((Object)this.view)).addTextProperty(DisplayerAttributeGroupDef.XAXIS_LABELSANGLE, "0", new PropertyFieldValidator[0]);
        ((DisplayerSettingsEditor.View)Mockito.verify((Object)this.view)).addTextProperty(DisplayerAttributeGroupDef.XAXIS_TITLE, "Depts", new PropertyFieldValidator[0]);
        ((DisplayerSettingsEditor.View)Mockito.verify((Object)this.view)).addBooleanProperty(DisplayerAttributeGroupDef.YAXIS_SHOWLABELS, true);
        ((DisplayerSettingsEditor.View)Mockito.verify((Object)this.view)).addTextProperty(DisplayerAttributeGroupDef.YAXIS_TITLE, "Amount $", new PropertyFieldValidator[0]);
        ((DisplayerSettingsEditor.View)Mockito.verify((Object)this.view)).addBooleanProperty(DisplayerAttributeGroupDef.FILTER_ENABLED, true);
        ((DisplayerSettingsEditor.View)Mockito.verify((Object)this.view)).addBooleanProperty(DisplayerAttributeGroupDef.FILTER_SELFAPPLY_ENABLED, false);
        ((DisplayerSettingsEditor.View)Mockito.verify((Object)this.view)).addBooleanProperty(DisplayerAttributeGroupDef.FILTER_NOTIFICATION_ENABLED, true);
        ((DisplayerSettingsEditor.View)Mockito.verify((Object)this.view)).addBooleanProperty(DisplayerAttributeGroupDef.FILTER_LISTENING_ENABLED, true);
        ((DisplayerSettingsEditor.View)Mockito.verify((Object)this.view)).addTextProperty((DisplayerAttributeDef)Mockito.eq((Object)DisplayerAttributeGroupDef.REFRESH_INTERVAL), (String)Mockito.eq((Object)"3"), new PropertyFieldValidator[]{(PropertyFieldValidator)Matchers.any(DisplayerSettingsEditor.LongValidator.class)});
        ((DisplayerSettingsEditor.View)Mockito.verify((Object)this.view)).addBooleanProperty(DisplayerAttributeGroupDef.REFRESH_STALE_DATA, false);
        ((DisplayerSettingsEditor.View)Mockito.verify((Object)this.view)).addTextProperty((String)Mockito.eq((Object)"columns.dept.name"), Mockito.anyString(), (String)Mockito.eq((Object)"Department"), new PropertyFieldValidator[0]);
        ((DisplayerSettingsEditor.View)Mockito.verify((Object)this.view)).addTextProperty((String)Mockito.eq((Object)"columns.amount.name"), Mockito.anyString(), (String)Mockito.eq((Object)"Total"), new PropertyFieldValidator[0]);
        ((DisplayerSettingsEditor.View)Mockito.verify((Object)this.view)).addTextProperty((String)Mockito.eq((Object)"columns.amount.expression"), Mockito.anyString(), (String)Mockito.eq((Object)"value/100"), new PropertyFieldValidator[0]);
        ((DisplayerSettingsEditor.View)Mockito.verify((Object)this.view)).addTextProperty((String)Mockito.eq((Object)"columns.amount.pattern"), Mockito.anyString(), (String)Mockito.eq((Object)"#.##0"), new PropertyFieldValidator[0]);
        ((DisplayerSettingsEditor.View)Mockito.verify((Object)this.view)).show();
    }

    @Test
    public void testChangeAttributes() {
        DisplayerSettings settings = DisplayerSettingsFactory.newBarChartSettings().buildSettings();
        Mockito.when((Object)this.displayer.getDisplayerSettings()).thenReturn((Object)settings);
        this.presenter.init(this.displayer);
        this.presenter.onAttributeChanged(DisplayerAttributeGroupDef.TITLE.getFullId(), "Test");
        this.presenter.onAttributeChanged(DisplayerAttributeGroupDef.TITLE_VISIBLE.getFullId(), "true");
        this.presenter.onAttributeChanged(DisplayerAttributeGroupDef.EXPORT_TO_CSV.getFullId(), "false");
        this.presenter.onAttributeChanged(DisplayerAttributeGroupDef.EXPORT_TO_XLS.getFullId(), "false");
        this.presenter.onAttributeChanged(DisplayerAttributeGroupDef.CHART_HEIGHT.getFullId(), "400");
        this.presenter.onAttributeChanged("columns.amount.name", "Total");
        this.presenter.onAttributeChanged("columns.amount.pattern", "#.###,00");
        this.presenter.onAttributeChanged("columns.amount.expression", "value");
        Assert.assertEquals((Object)settings.getTitle(), (Object)"Test");
        Assert.assertEquals((Object)settings.isTitleVisible(), (Object)true);
        Assert.assertEquals((Object)settings.isCSVExportAllowed(), (Object)false);
        Assert.assertEquals((Object)settings.isExcelExportAllowed(), (Object)false);
        Assert.assertEquals((long)settings.getChartHeight(), (long)400L);
        Assert.assertEquals((Object)settings.getColumnSettings("amount").getColumnName(), (Object)"Total");
        Assert.assertEquals((Object)settings.getColumnSettings("amount").getValuePattern(), (Object)"#.###,00");
        Assert.assertEquals((Object)settings.getColumnSettings("amount").getValueExpression(), (Object)"value");
        ((EventSourceMock)Mockito.verify(this.event, (VerificationMode)Mockito.atLeastOnce())).fire(Matchers.any(DisplayerSettingsChangedEvent.class));
    }

    @Test
    public void testTableSettings() {
        Mockito.when((Object)this.dataSetHandler.getLastDataSet()).thenReturn((Object)DataSetFactory.newDataSetBuilder().label("dept").date("date").number("amount").buildDataSet());
        Mockito.when((Object)this.displayer.getDisplayerConstraints()).thenReturn((Object)new DisplayerConstraints(null).supportsAttribute((DisplayerAttributeDef)DisplayerAttributeGroupDef.TABLE_GROUP).supportsAttribute((DisplayerAttributeDef)DisplayerAttributeGroupDef.EXPORT_GROUP));
        Mockito.when((Object)this.displayer.getDisplayerSettings()).thenReturn((Object)((TableDisplayerSettingsBuilderImpl)((TableDisplayerSettingsBuilderImpl)((TableDisplayerSettingsBuilderImpl)DisplayerSettingsFactory.newTableSettings().tablePageSize(10)).tableWidth(500).tableOrderEnabled(true).tableOrderDefault("date", SortOrder.ASCENDING).tableColumnPickerEnabled(false).allowCsvExport(true)).allowExcelExport(false)).buildSettings());
        this.presenter.init(this.displayer);
        ((DisplayerSettingsEditor.View)Mockito.verify((Object)this.view)).clear();
        ((DisplayerSettingsEditor.View)Mockito.verify((Object)this.view)).addTextProperty((DisplayerAttributeDef)Mockito.eq((Object)DisplayerAttributeGroupDef.TABLE_WIDTH), (String)Mockito.eq((Object)"500"), new PropertyFieldValidator[]{(PropertyFieldValidator)Matchers.any(DisplayerSettingsEditor.LongValidator.class)});
        ((DisplayerSettingsEditor.View)Mockito.verify((Object)this.view)).addBooleanProperty(DisplayerAttributeGroupDef.TABLE_SORTENABLED, true);
        ((DisplayerSettingsEditor.View)Mockito.verify((Object)this.view)).addListProperty((DisplayerAttributeDef)Mockito.eq((Object)DisplayerAttributeGroupDef.TABLE_SORTCOLUMNID), Mockito.anyListOf(String.class), (String)Mockito.eq((Object)"date"));
        ((DisplayerSettingsEditor.View)Mockito.verify((Object)this.view)).addListProperty((DisplayerAttributeDef)Mockito.eq((Object)DisplayerAttributeGroupDef.TABLE_SORTORDER), Mockito.anyListOf(String.class), (String)Mockito.eq((Object)SortOrder.ASCENDING.toString()));
        ((DisplayerSettingsEditor.View)Mockito.verify((Object)this.view)).addBooleanProperty(DisplayerAttributeGroupDef.TABLE_COLUMN_PICKER_ENABLED, false);
        ((DisplayerSettingsEditor.View)Mockito.verify((Object)this.view)).addBooleanProperty(DisplayerAttributeGroupDef.EXPORT_TO_CSV, true);
        ((DisplayerSettingsEditor.View)Mockito.verify((Object)this.view)).addBooleanProperty(DisplayerAttributeGroupDef.EXPORT_TO_XLS, false);
        ((DisplayerSettingsEditor.View)Mockito.verify((Object)this.view)).show();
    }

    @Test
    public void testMeterSettings() {
        Mockito.when((Object)this.displayer.getDisplayerConstraints()).thenReturn((Object)new DisplayerConstraints(null).supportsAttribute((DisplayerAttributeDef)DisplayerAttributeGroupDef.METER_GROUP));
        Mockito.when((Object)this.displayer.getDisplayerSettings()).thenReturn((Object)((MeterChartSettingsBuilderImpl)DisplayerSettingsFactory.newMeterChartSettings().meter(0L, 100L, 500L, 900L)).buildSettings());
        this.presenter.init(this.displayer);
        ((DisplayerSettingsEditor.View)Mockito.verify((Object)this.view)).clear();
        ((DisplayerSettingsEditor.View)Mockito.verify((Object)this.view)).addTextProperty((DisplayerAttributeDef)Mockito.eq((Object)DisplayerAttributeGroupDef.METER_START), (String)Mockito.eq((Object)"0"), new PropertyFieldValidator[]{(PropertyFieldValidator)Matchers.any(DisplayerSettingsEditor.LongValidator.class)});
        ((DisplayerSettingsEditor.View)Mockito.verify((Object)this.view)).addTextProperty((DisplayerAttributeDef)Mockito.eq((Object)DisplayerAttributeGroupDef.METER_WARNING), (String)Mockito.eq((Object)"100"), new PropertyFieldValidator[]{(PropertyFieldValidator)Matchers.any(DisplayerSettingsEditor.LongValidator.class)});
        ((DisplayerSettingsEditor.View)Mockito.verify((Object)this.view)).addTextProperty((DisplayerAttributeDef)Mockito.eq((Object)DisplayerAttributeGroupDef.METER_CRITICAL), (String)Mockito.eq((Object)"500"), new PropertyFieldValidator[]{(PropertyFieldValidator)Matchers.any(DisplayerSettingsEditor.LongValidator.class)});
        ((DisplayerSettingsEditor.View)Mockito.verify((Object)this.view)).addTextProperty((DisplayerAttributeDef)Mockito.eq((Object)DisplayerAttributeGroupDef.METER_END), (String)Mockito.eq((Object)"900"), new PropertyFieldValidator[]{(PropertyFieldValidator)Matchers.any(DisplayerSettingsEditor.LongValidator.class)});
        ((DisplayerSettingsEditor.View)Mockito.verify((Object)this.view)).show();
    }

    @Test
    public void testRenderer() {
        DisplayerSettings settings = ((BarChartSettingsBuilderImpl)DisplayerSettingsFactory.newBarChartSettings().renderer("rendererB")).buildSettings();
        Mockito.when((Object)this.rendererManager.getRendererForDisplayer(settings)).thenReturn((Object)this.rendererB);
        Mockito.when((Object)this.displayer.getDisplayerConstraints()).thenReturn((Object)new DisplayerConstraints(null).supportsAttribute(DisplayerAttributeGroupDef.RENDERER));
        Mockito.when((Object)this.displayer.getDisplayerSettings()).thenReturn((Object)settings);
        this.presenter.init(this.displayer);
        ((DisplayerSettingsEditor.View)Mockito.verify((Object)this.view)).clear();
        ((DisplayerSettingsEditor.View)Mockito.verify((Object)this.view)).addListProperty(DisplayerAttributeGroupDef.RENDERER, Arrays.asList("rendererA", "rendererB"), "rendererB");
        ((DisplayerSettingsEditor.View)Mockito.verify((Object)this.view)).show();
    }

    @Test
    public void testSupportedAttrs() {
        Mockito.when((Object)this.displayer.getDisplayerConstraints()).thenReturn((Object)new DisplayerConstraints(null).supportsAttribute(DisplayerAttributeGroupDef.TYPE).supportsAttribute(DisplayerAttributeGroupDef.SUBTYPE).supportsAttribute(DisplayerAttributeGroupDef.TITLE).supportsAttribute((DisplayerAttributeDef)DisplayerAttributeGroupDef.FILTER_GROUP));
        Mockito.when((Object)this.displayer.getDisplayerSettings()).thenReturn((Object)DisplayerSettingsFactory.newBarChartSettings().buildSettings());
        this.presenter.init(this.displayer);
        Assert.assertEquals((Object)this.presenter.isSupported(DisplayerAttributeGroupDef.TYPE), (Object)true);
        Assert.assertEquals((Object)this.presenter.isSupported(DisplayerAttributeGroupDef.SUBTYPE), (Object)true);
        Assert.assertEquals((Object)this.presenter.isSupported(DisplayerAttributeGroupDef.TITLE), (Object)true);
        Assert.assertEquals((Object)this.presenter.isSupported(DisplayerAttributeGroupDef.TITLE_VISIBLE), (Object)false);
        Assert.assertEquals((Object)this.presenter.isSupported(DisplayerAttributeGroupDef.RENDERER), (Object)false);
        Assert.assertEquals((Object)this.presenter.isSupported(DisplayerAttributeGroupDef.FILTER_ENABLED), (Object)true);
        Assert.assertEquals((Object)this.presenter.isSupported(DisplayerAttributeGroupDef.FILTER_LISTENING_ENABLED), (Object)true);
        Assert.assertEquals((Object)this.presenter.isSupported(DisplayerAttributeGroupDef.FILTER_NOTIFICATION_ENABLED), (Object)true);
        Assert.assertEquals((Object)this.presenter.isSupported(DisplayerAttributeGroupDef.FILTER_SELFAPPLY_ENABLED), (Object)true);
    }

    @Test
    public void testLongValidator() {
        DisplayerSettingsEditor.LongValidator validator = this.presenter.createLongValidator();
        Assert.assertEquals((Object)validator.validate((Object)"500"), (Object)true);
        Assert.assertEquals((Object)validator.validate((Object)"500d"), (Object)false);
        Assert.assertEquals((Object)validator.validate((Object)"aaa"), (Object)false);
    }

    @Test
    public void testMeterValidator() {
        DisplayerSettings settings = ((MeterChartSettingsBuilderImpl)DisplayerSettingsFactory.newMeterChartSettings().meter(0L, 100L, 500L, 900L)).buildSettings();
        Mockito.when((Object)this.displayer.getDisplayerSettings()).thenReturn((Object)settings);
        this.presenter.init(this.displayer);
        DisplayerSettingsEditor.MeterValidator validator = this.presenter.createMeterValidator(settings, 0);
        Assert.assertEquals((Object)validator.validate((Object)"aaa"), (Object)false);
        Assert.assertEquals((Object)validator.validate((Object)"0"), (Object)true);
        Assert.assertEquals((Object)validator.validate((Object)"99"), (Object)true);
        Assert.assertEquals((Object)validator.validate((Object)"100"), (Object)true);
        Assert.assertEquals((Object)validator.validate((Object)"101"), (Object)false);
        Assert.assertEquals((Object)validator.validate((Object)"-999999999999"), (Object)true);
        validator = this.presenter.createMeterValidator(settings, 1);
        Assert.assertEquals((Object)validator.validate((Object)"0"), (Object)true);
        Assert.assertEquals((Object)validator.validate((Object)"99"), (Object)true);
        Assert.assertEquals((Object)validator.validate((Object)"100"), (Object)true);
        Assert.assertEquals((Object)validator.validate((Object)"101"), (Object)true);
        Assert.assertEquals((Object)validator.validate((Object)"500"), (Object)true);
        Assert.assertEquals((Object)validator.validate((Object)"501"), (Object)false);
        Assert.assertEquals((Object)validator.validate((Object)"-1"), (Object)false);
        validator = this.presenter.createMeterValidator(settings, 2);
        Assert.assertEquals((Object)validator.validate((Object)"99"), (Object)false);
        Assert.assertEquals((Object)validator.validate((Object)"100"), (Object)true);
        Assert.assertEquals((Object)validator.validate((Object)"900"), (Object)true);
        Assert.assertEquals((Object)validator.validate((Object)"901"), (Object)false);
        validator = this.presenter.createMeterValidator(settings, 3);
        Assert.assertEquals((Object)validator.validate((Object)"499"), (Object)false);
        Assert.assertEquals((Object)validator.validate((Object)"500"), (Object)true);
        Assert.assertEquals((Object)validator.validate((Object)"900"), (Object)true);
        Assert.assertEquals((Object)validator.validate((Object)"10000000000000"), (Object)true);
    }
}

