/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.displayer.client.widgets;

import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Composite;
import elemental2.dom.Event;
import elemental2.dom.HTMLDivElement;
import elemental2.dom.HTMLIFrameElement;
import elemental2.dom.HTMLParagraphElement;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.dashbuilder.displayer.client.widgets.ExternalComponentPresenter;
import org.dashbuilder.displayer.external.ExternalComponentMessage;
import org.dashbuilder.displayer.external.ExternalComponentMessageHelper;
import org.jboss.errai.ui.shared.api.annotations.DataField;
import org.jboss.errai.ui.shared.api.annotations.Templated;

@Dependent
@Templated
public class ExternalComponentView
extends Composite
implements ExternalComponentPresenter.View {
    @Inject
    @DataField
    HTMLDivElement componentRoot;
    @Inject
    @DataField
    HTMLIFrameElement externalComponentIFrame;
    @Inject
    @DataField
    HTMLDivElement configurationIssueRoot;
    @Inject
    @DataField
    HTMLParagraphElement configurationDetails;
    @Inject
    ExternalComponentMessageHelper messageHelper;
    private boolean componentLoaded = false;
    private ExternalComponentMessage lastMessage;
    private ExternalComponentMessage initMessage;

    public void init(ExternalComponentPresenter presenter) {
        this.showComponent();
    }

    @Override
    public void setComponentURL(String url) {
        this.externalComponentIFrame.src = url;
        this.componentLoaded = false;
        this.externalComponentIFrame.onload = this::onInvoke;
    }

    @Override
    public void postMessage(ExternalComponentMessage message) {
        if (this.componentLoaded) {
            this.postMessageToComponent(message);
        } else if (this.messageHelper.isInit(message)) {
            this.initMessage = message;
        } else {
            this.lastMessage = message;
        }
    }

    private void postMessageToComponent(Object message) {
        if (this.externalComponentIFrame != null && this.externalComponentIFrame.contentWindow != null) {
            this.externalComponentIFrame.contentWindow.postMessage(message, Window.Location.getHref());
        }
    }

    @Override
    public void makeReady() {
    }

    @Override
    public void configurationIssue(String message) {
        this.configurationDetails.textContent = message;
        this.showConfigurationIssue();
    }

    @Override
    public void configurationOk() {
        this.showComponent();
    }

    private void showConfigurationIssue() {
        this.configurationIssueRoot.style.display = "block";
        this.externalComponentIFrame.style.display = "none";
    }

    private void showComponent() {
        this.configurationIssueRoot.style.display = "none";
        this.externalComponentIFrame.style.display = "block";
    }

    private Object onInvoke(Event e) {
        this.componentLoaded = true;
        if (this.initMessage != null) {
            this.postMessageToComponent(this.initMessage);
        }
        if (this.lastMessage != null) {
            this.postMessageToComponent(this.lastMessage);
        }
        return null;
    }
}

