/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.displayer.client.widgets;

import org.dashbuilder.displayer.DisplayerSubType;
import org.dashbuilder.displayer.DisplayerType;
import org.dashbuilder.displayer.client.RendererManager;
import org.dashbuilder.displayer.client.events.DisplayerTypeSelectedEvent;
import org.dashbuilder.displayer.client.widgets.DisplayerSubtypeSelector;
import org.dashbuilder.displayer.client.widgets.DisplayerTypeSelector;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.uberfire.mocks.EventSourceMock;

@RunWith(value=MockitoJUnitRunner.class)
public class DisplayerTypeSelectorTest {
    @Mock
    DisplayerTypeSelector.View typeView;
    @Mock
    DisplayerSubtypeSelector subtypeSelector;
    @Mock
    EventSourceMock<DisplayerTypeSelectedEvent> typeSelectedEvent;
    @Mock
    RendererManager rendererManager;
    DisplayerTypeSelector presenter;

    @Before
    public void init() {
        this.presenter = new DisplayerTypeSelector(this.typeView, this.subtypeSelector, this.typeSelectedEvent, this.rendererManager);
    }

    @Test
    public void testInitialization() {
        this.presenter.init(DisplayerType.LINECHART, DisplayerSubType.SMOOTH);
        ((DisplayerTypeSelector.View)Mockito.verify((Object)this.typeView)).select(DisplayerType.LINECHART);
    }

    @Test
    public void testOnSelect() {
        this.presenter.onSelect(DisplayerType.BARCHART);
        Assert.assertEquals((Object)this.presenter.getSelectedType(), (Object)DisplayerType.BARCHART);
        ((EventSourceMock)Mockito.verify(this.typeSelectedEvent)).fire(ArgumentMatchers.any(DisplayerTypeSelectedEvent.class));
    }

    @Test
    public void testNotSupportedDisplayer() {
        Mockito.when((Object)this.rendererManager.isTypeSupported(DisplayerType.BARCHART)).thenReturn((Object)true);
        Mockito.when((Object)this.rendererManager.isTypeSupported(DisplayerType.LINECHART)).thenReturn((Object)true);
        this.presenter = new DisplayerTypeSelector(this.typeView, this.subtypeSelector, this.typeSelectedEvent, this.rendererManager);
        ((DisplayerTypeSelector.View)Mockito.verify((Object)this.typeView, (VerificationMode)Mockito.times((int)2))).show((DisplayerType)ArgumentMatchers.any());
        ((DisplayerTypeSelector.View)Mockito.verify((Object)this.typeView, (VerificationMode)Mockito.times((int)0))).show(DisplayerType.MAP);
        ((DisplayerTypeSelector.View)Mockito.verify((Object)this.typeView)).show(DisplayerType.BARCHART);
        ((DisplayerTypeSelector.View)Mockito.verify((Object)this.typeView)).show(DisplayerType.LINECHART);
    }
}

