/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.displayer.client.widgets.filter;

import java.lang.annotation.Annotation;
import javax.enterprise.event.Event;
import org.dashbuilder.dataset.ColumnType;
import org.dashbuilder.dataset.DataSetMetadata;
import org.dashbuilder.dataset.filter.ColumnFilter;
import org.dashbuilder.dataset.filter.CoreFunctionFilter;
import org.dashbuilder.dataset.filter.CoreFunctionType;
import org.dashbuilder.dataset.filter.DataSetFilter;
import org.dashbuilder.dataset.filter.FilterFactory;
import org.dashbuilder.displayer.client.events.ColumnFilterDeletedEvent;
import org.dashbuilder.displayer.client.events.DataSetFilterChangedEvent;
import org.dashbuilder.displayer.client.widgets.filter.ColumnFilterEditor;
import org.dashbuilder.displayer.client.widgets.filter.DataSetFilterEditor;
import org.jboss.errai.ioc.client.container.SyncBeanDef;
import org.jboss.errai.ioc.client.container.SyncBeanManager;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class DataSetFilterEditorTest {
    @Mock
    ColumnFilterEditor columnFilterEditor;
    @Mock
    DataSetFilterEditor.View filterView;
    @Mock
    SyncBeanManager beanManager;
    @Mock
    SyncBeanDef<ColumnFilterEditor> columnFilterEditorBeanDef;
    @Mock
    DataSetMetadata metadata;
    @Mock
    Event<DataSetFilterChangedEvent> changedEvent;

    @Before
    public void setup() {
        Mockito.when((Object)this.beanManager.lookupBean(ColumnFilterEditor.class, new Annotation[0])).thenReturn(this.columnFilterEditorBeanDef);
        Mockito.when((Object)this.columnFilterEditorBeanDef.newInstance()).thenReturn((Object)this.columnFilterEditor);
        Mockito.when((Object)this.metadata.getNumberOfColumns()).thenReturn((Object)3);
        Mockito.when((Object)this.metadata.getColumnId(0)).thenReturn((Object)"column1");
        Mockito.when((Object)this.metadata.getColumnId(1)).thenReturn((Object)"column2");
        Mockito.when((Object)this.metadata.getColumnId(2)).thenReturn((Object)"column3");
        Mockito.when((Object)this.metadata.getColumnType(0)).thenReturn((Object)ColumnType.LABEL);
        Mockito.when((Object)this.metadata.getColumnType(2)).thenReturn((Object)ColumnType.DATE);
    }

    @Test
    public void testViewInitialization() {
        DataSetFilter filter = new DataSetFilter();
        ColumnFilter filter1 = FilterFactory.equalsTo((String)"column1", (Comparable)((Object)"Test"));
        filter.addFilterColumn(new ColumnFilter[]{filter1});
        DataSetFilterEditor filterEditor = new DataSetFilterEditor(this.filterView, this.beanManager, this.changedEvent);
        filterEditor.init(filter, this.metadata);
        Assert.assertEquals((Object)this.filterView, (Object)filterEditor.view);
        ((DataSetFilterEditor.View)Mockito.verify((Object)this.filterView)).showNewFilterHome();
        ((DataSetFilterEditor.View)Mockito.verify((Object)this.filterView)).addColumn("column1");
        ((DataSetFilterEditor.View)Mockito.verify((Object)this.filterView)).addColumn("column2");
        ((DataSetFilterEditor.View)Mockito.verify((Object)this.filterView)).addColumn("column3");
        ((DataSetFilterEditor.View)Mockito.verify((Object)this.filterView, (VerificationMode)Mockito.times((int)filter.getColumnFilterList().size()))).addColumnFilterEditor((ColumnFilterEditor)ArgumentMatchers.any(ColumnFilterEditor.class));
    }

    @Test
    public void testWorkflow() {
        DataSetFilterEditor filterEditor = new DataSetFilterEditor(this.filterView, this.beanManager, this.changedEvent);
        filterEditor.init(null, this.metadata);
        Mockito.reset((Object[])new DataSetFilterEditor.View[]{this.filterView});
        filterEditor.onNewFilterStart();
        ((DataSetFilterEditor.View)Mockito.verify((Object)this.filterView)).showColumnSelector();
        filterEditor.onNewFilterCancel();
        ((DataSetFilterEditor.View)Mockito.verify((Object)this.filterView)).showNewFilterHome();
    }

    @Test
    public void testCreateLabelFilter() {
        DataSetFilterEditor filterEditor = new DataSetFilterEditor(this.filterView, this.beanManager, this.changedEvent);
        filterEditor.init(null, this.metadata);
        Mockito.reset((Object[])new DataSetFilterEditor.View[]{this.filterView});
        Mockito.when((Object)this.filterView.getSelectedColumnIndex()).thenReturn((Object)0);
        filterEditor.onCreateFilter();
        ((Event)Mockito.verify(this.changedEvent)).fire(ArgumentMatchers.any(DataSetFilterChangedEvent.class));
        DataSetFilter filter = filterEditor.getFilter();
        Assert.assertNotNull((Object)filter);
        Assert.assertEquals((long)filter.getColumnFilterList().size(), (long)1L);
        CoreFunctionFilter expected = FilterFactory.createCoreFunctionFilter((String)"column1", (ColumnType)ColumnType.LABEL, (CoreFunctionType)CoreFunctionType.NOT_EQUALS_TO);
        Assert.assertEquals(filter.getColumnFilterList().get(0), (Object)expected);
    }

    @Test
    public void testCreateDateFilter() {
        DataSetFilterEditor filterEditor = new DataSetFilterEditor(this.filterView, this.beanManager, this.changedEvent);
        filterEditor.init(null, this.metadata);
        Mockito.reset((Object[])new DataSetFilterEditor.View[]{this.filterView});
        Mockito.when((Object)this.filterView.getSelectedColumnIndex()).thenReturn((Object)2);
        filterEditor.onCreateFilter();
        ((Event)Mockito.verify(this.changedEvent)).fire(ArgumentMatchers.any(DataSetFilterChangedEvent.class));
        DataSetFilter filter = filterEditor.getFilter();
        Assert.assertNotNull((Object)filter);
        Assert.assertEquals((long)filter.getColumnFilterList().size(), (long)1L);
        CoreFunctionFilter expected = FilterFactory.createCoreFunctionFilter((String)"column3", (ColumnType)ColumnType.DATE, (CoreFunctionType)CoreFunctionType.TIME_FRAME);
        Assert.assertEquals(filter.getColumnFilterList().get(0), (Object)expected);
    }

    @Test
    public void testDeleteDuplicatedFilters() {
        ColumnFilter columnFilter1 = FilterFactory.notEqualsTo((String)"column", (Comparable)((Object)"val1"));
        ColumnFilter columnFilter2 = FilterFactory.notEqualsTo((String)"column", (Comparable)((Object)"val1"));
        ColumnFilterEditor columnFilterEditor1 = (ColumnFilterEditor)Mockito.mock(ColumnFilterEditor.class);
        ColumnFilterEditor columnFilterEditor2 = (ColumnFilterEditor)Mockito.mock(ColumnFilterEditor.class);
        Mockito.when((Object)columnFilterEditor1.getFilter()).thenReturn((Object)columnFilter1);
        Mockito.when((Object)columnFilterEditor2.getFilter()).thenReturn((Object)columnFilter2);
        Mockito.when((Object)this.columnFilterEditorBeanDef.newInstance()).thenReturn((Object)columnFilterEditor1, (Object[])new ColumnFilterEditor[]{columnFilterEditor2});
        DataSetFilter filter = new DataSetFilter();
        filter.addFilterColumn(new ColumnFilter[]{columnFilter1, columnFilter2});
        DataSetFilterEditor filterEditor = new DataSetFilterEditor(this.filterView, this.beanManager, this.changedEvent);
        filterEditor.init(filter, this.metadata);
        filterEditor.onColumnFilterDeleted(new ColumnFilterDeletedEvent(columnFilterEditor2));
        filterEditor.onColumnFilterDeleted(new ColumnFilterDeletedEvent(columnFilterEditor1));
        Assert.assertEquals((long)filter.getColumnFilterList().size(), (long)0L);
        ((DataSetFilterEditor.View)Mockito.verify((Object)this.filterView)).removeColumnFilterEditor(columnFilterEditor1);
        ((DataSetFilterEditor.View)Mockito.verify((Object)this.filterView)).removeColumnFilterEditor(columnFilterEditor2);
        ((SyncBeanManager)Mockito.verify((Object)this.beanManager)).destroyBean((Object)columnFilterEditor1);
        ((SyncBeanManager)Mockito.verify((Object)this.beanManager)).destroyBean((Object)columnFilterEditor2);
        ((Event)Mockito.verify(this.changedEvent, (VerificationMode)Mockito.times((int)2))).fire(ArgumentMatchers.any(DataSetFilterChangedEvent.class));
    }
}

