/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.displayer.client.widgets;

import java.util.Arrays;
import org.dashbuilder.displayer.DisplayerSubType;
import org.dashbuilder.displayer.DisplayerType;
import org.dashbuilder.displayer.client.RendererLibrary;
import org.dashbuilder.displayer.client.RendererManager;
import org.dashbuilder.displayer.client.events.DisplayerSubtypeSelectedEvent;
import org.dashbuilder.displayer.client.widgets.DisplayerSubtypeSelector;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.uberfire.mocks.EventSourceMock;

@RunWith(value=MockitoJUnitRunner.class)
public class DisplayerSubtypeSelectorTest {
    @Mock
    DisplayerSubtypeSelector.View subtypeView;
    @Mock
    RendererManager rendererManager;
    @Mock
    RendererLibrary rendererLibrary;
    @Mock
    EventSourceMock<DisplayerSubtypeSelectedEvent> subtypeSelectedEvent;
    DisplayerSubtypeSelector presenter;

    @Before
    public void init() {
        Mockito.when((Object)this.rendererManager.getRendererForType((DisplayerType)ArgumentMatchers.any(DisplayerType.class))).thenReturn((Object)this.rendererLibrary);
        Mockito.when((Object)this.rendererLibrary.getSupportedSubtypes(DisplayerType.BARCHART)).thenReturn(Arrays.asList(DisplayerSubType.BAR, DisplayerSubType.BAR_STACKED));
        Mockito.when((Object)this.rendererLibrary.getSupportedSubtypes(DisplayerType.LINECHART)).thenReturn(Arrays.asList(DisplayerSubType.LINE, DisplayerSubType.SMOOTH));
        Mockito.when((Object)this.rendererLibrary.getSupportedSubtypes(DisplayerType.BUBBLECHART)).thenReturn(null);
        this.presenter = new DisplayerSubtypeSelector(this.subtypeView, this.rendererManager, this.subtypeSelectedEvent);
    }

    @Test
    public void testInitialization1() {
        this.presenter.init(DisplayerType.BARCHART, DisplayerSubType.BAR);
        ((DisplayerSubtypeSelector.View)Mockito.verify((Object)this.subtypeView)).show(DisplayerType.BARCHART, DisplayerSubType.BAR);
        ((DisplayerSubtypeSelector.View)Mockito.verify((Object)this.subtypeView)).show(DisplayerType.BARCHART, DisplayerSubType.BAR_STACKED);
        ((DisplayerSubtypeSelector.View)Mockito.verify((Object)this.subtypeView)).select(DisplayerSubType.BAR);
    }

    @Test
    public void testInitialization2() {
        this.presenter.init(DisplayerType.LINECHART, null);
        ((DisplayerSubtypeSelector.View)Mockito.verify((Object)this.subtypeView)).show(DisplayerType.LINECHART, DisplayerSubType.LINE);
        ((DisplayerSubtypeSelector.View)Mockito.verify((Object)this.subtypeView)).show(DisplayerType.LINECHART, DisplayerSubType.SMOOTH);
        ((DisplayerSubtypeSelector.View)Mockito.verify((Object)this.subtypeView)).select(DisplayerSubType.LINE);
    }

    @Test
    public void testInitialization3() {
        this.presenter.init(DisplayerType.BUBBLECHART, null);
        ((DisplayerSubtypeSelector.View)Mockito.verify((Object)this.subtypeView, (VerificationMode)Mockito.never())).show((DisplayerType)ArgumentMatchers.any(DisplayerType.class), (DisplayerSubType)ArgumentMatchers.any(DisplayerSubType.class));
        ((DisplayerSubtypeSelector.View)Mockito.verify((Object)this.subtypeView)).showDefault(DisplayerType.BUBBLECHART);
    }

    @Test
    public void testOnSelect() {
        this.presenter.onSelect(DisplayerSubType.LINE);
        Assert.assertEquals((Object)this.presenter.getSelectedSubtype(), (Object)DisplayerSubType.LINE);
        ((EventSourceMock)Mockito.verify(this.subtypeSelectedEvent)).fire(ArgumentMatchers.any(DisplayerSubtypeSelectedEvent.class));
    }
}

