/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.displayer.client.widgets;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.user.client.ui.Composite;
import elemental2.dom.HTMLAnchorElement;
import elemental2.dom.HTMLDivElement;
import elemental2.dom.HTMLParagraphElement;
import elemental2.dom.HTMLTextAreaElement;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.jboss.errai.ui.shared.api.annotations.DataField;
import org.jboss.errai.ui.shared.api.annotations.EventHandler;
import org.jboss.errai.ui.shared.api.annotations.Templated;

@Dependent
@Templated
public class DisplayerErrorWidget
extends Composite {
    @Inject
    @DataField
    private HTMLDivElement displayerErrorRoot;
    @Inject
    @DataField
    private HTMLParagraphElement errorBody;
    @Inject
    @DataField
    private HTMLDivElement errorDetailsSection;
    @Inject
    @DataField
    private HTMLTextAreaElement errorDetails;
    @Inject
    @DataField
    private HTMLAnchorElement chevronRight;
    @Inject
    @DataField
    private HTMLAnchorElement chevronDown;

    public void show(String message, Throwable t) {
        this.errorBody.textContent = message;
        this.errorDetails.value = this.buildErrorDetails(t);
    }

    private String buildErrorDetails(Throwable t) {
        StringBuilder sb = new StringBuilder();
        sb.append(t.getMessage());
        for (Throwable cause = t.getCause(); cause != null; cause = cause.getCause()) {
            sb.append("\n  Caused by: " + cause.getMessage());
        }
        return sb.toString();
    }

    @EventHandler(value={"chevronRight"})
    public void onChevronRightClicked(ClickEvent event) {
        this.showErrorDetails(true);
    }

    @EventHandler(value={"chevronDown"})
    public void onChevronDownClicked(ClickEvent event) {
        this.showErrorDetails(false);
    }

    private void showErrorDetails(boolean isVisible) {
        this.chevronRight.hidden = isVisible;
        this.chevronDown.hidden = !isVisible;
        this.errorDetailsSection.hidden = !isVisible;
    }
}

