/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.displayer.client;

import org.dashbuilder.displayer.DisplayerSettingsFactory;
import org.dashbuilder.displayer.client.AbstractDisplayer;
import org.dashbuilder.displayer.client.AbstractDisplayerTest;
import org.dashbuilder.displayer.impl.TableDisplayerSettingsBuilderImpl;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.Silent.class)
public class DisplayerRefreshTest
extends AbstractDisplayerTest {
    @Test
    public void testRefreshEnabled() {
        AbstractDisplayer displayer = (AbstractDisplayer)this.displayerLocator.lookupDisplayer(((TableDisplayerSettingsBuilderImpl)((TableDisplayerSettingsBuilderImpl)DisplayerSettingsFactory.newTableSettings().dataset("expenses")).refreshOn(10, false)).buildSettings());
        displayer.draw();
        Assert.assertEquals((Object)displayer.isRefreshOn(), (Object)true);
        ((AbstractDisplayer.View)Mockito.verify((Object)displayer.getView())).enableRefreshTimer(10);
        ((AbstractDisplayer.View)Mockito.verify((Object)displayer.getView(), (VerificationMode)Mockito.never())).cancelRefreshTimer();
    }

    @Test
    public void testRefreshDisabled() {
        AbstractDisplayer displayer = (AbstractDisplayer)this.displayerLocator.lookupDisplayer(((TableDisplayerSettingsBuilderImpl)((TableDisplayerSettingsBuilderImpl)DisplayerSettingsFactory.newTableSettings().dataset("expenses")).refreshOff()).buildSettings());
        displayer.draw();
        Assert.assertEquals((Object)displayer.isRefreshOn(), (Object)true);
        ((AbstractDisplayer.View)Mockito.verify((Object)displayer.getView())).cancelRefreshTimer();
        ((AbstractDisplayer.View)Mockito.verify((Object)displayer.getView(), (VerificationMode)Mockito.never())).enableRefreshTimer(Mockito.anyInt());
    }

    @Test
    public void testSwitchRefreshOff() {
        AbstractDisplayer displayer = (AbstractDisplayer)this.displayerLocator.lookupDisplayer(((TableDisplayerSettingsBuilderImpl)((TableDisplayerSettingsBuilderImpl)DisplayerSettingsFactory.newTableSettings().dataset("expenses")).refreshOn(10, false)).buildSettings());
        displayer.draw();
        Mockito.reset((Object[])new AbstractDisplayer.View[]{displayer.getView()});
        displayer.setRefreshOn(false);
        Assert.assertEquals((Object)displayer.isRefreshOn(), (Object)false);
        ((AbstractDisplayer.View)Mockito.verify((Object)displayer.getView())).cancelRefreshTimer();
    }

    @Test
    public void testSwitchRefreshOn() {
        AbstractDisplayer displayer = (AbstractDisplayer)this.displayerLocator.lookupDisplayer(((TableDisplayerSettingsBuilderImpl)((TableDisplayerSettingsBuilderImpl)DisplayerSettingsFactory.newTableSettings().dataset("expenses")).refreshOn(10, false)).buildSettings());
        AbstractDisplayer.View view = displayer.getView();
        displayer.draw();
        ((AbstractDisplayer.View)Mockito.verify((Object)view)).enableRefreshTimer(10);
        Mockito.reset((Object[])new AbstractDisplayer.View[]{view});
        displayer.setRefreshOn(true);
        ((AbstractDisplayer.View)Mockito.verify((Object)view, (VerificationMode)Mockito.never())).enableRefreshTimer(Mockito.anyInt());
        ((AbstractDisplayer.View)Mockito.verify((Object)view, (VerificationMode)Mockito.never())).cancelRefreshTimer();
    }
}

