/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.displayer.client;

import org.dashbuilder.dataset.DataColumn;
import org.dashbuilder.dataset.DataSet;
import org.dashbuilder.dataset.filter.ColumnFilter;
import org.dashbuilder.dataset.filter.FilterFactory;
import org.dashbuilder.dataset.service.DataSetExportServices;
import org.dashbuilder.displayer.DisplayerSettings;
import org.dashbuilder.displayer.DisplayerSettingsFactory;
import org.dashbuilder.displayer.client.AbstractDisplayerTest;
import org.dashbuilder.displayer.client.Displayer;
import org.dashbuilder.displayer.client.export.ExportCallback;
import org.dashbuilder.displayer.client.export.ExportFormat;
import org.dashbuilder.displayer.impl.TableDisplayerSettingsBuilderImpl;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.Silent.class)
public class DisplayerExportTest
extends AbstractDisplayerTest {
    DisplayerSettings EMPTY = ((TableDisplayerSettingsBuilderImpl)((TableDisplayerSettingsBuilderImpl)DisplayerSettingsFactory.newTableSettings().dataset("expenses")).filter("CITY", new ColumnFilter[]{FilterFactory.isNull()})).buildSettings();
    DisplayerSettings ALLROWS = ((TableDisplayerSettingsBuilderImpl)DisplayerSettingsFactory.newTableSettings().dataset("expenses")).buildSettings();
    DisplayerSettings CUSTOM_NAMES = ((TableDisplayerSettingsBuilderImpl)((TableDisplayerSettingsBuilderImpl)((TableDisplayerSettingsBuilderImpl)((TableDisplayerSettingsBuilderImpl)((TableDisplayerSettingsBuilderImpl)((TableDisplayerSettingsBuilderImpl)((TableDisplayerSettingsBuilderImpl)((TableDisplayerSettingsBuilderImpl)((TableDisplayerSettingsBuilderImpl)((TableDisplayerSettingsBuilderImpl)((TableDisplayerSettingsBuilderImpl)DisplayerSettingsFactory.newTableSettings().dataset("expenses")).column("DEPARTMENT")).format("Dept")).column("EMPLOYEE")).format("Emp")).column("CITY")).format("City")).column("CREATION_DATE")).format("Date")).column("AMOUNT")).format("$")).buildSettings();
    @Mock
    ExportCallback exportCallback;

    @Test
    public void testExportDisplayer() {
        Displayer displayer = this.displayerLocator.lookupDisplayer(this.ALLROWS);
        displayer.draw();
        displayer.export(ExportFormat.CSV, -1, this.exportCallback);
        ((ExportCallback)Mockito.verify((Object)this.exportCallback)).exportFileUrl((String)Mockito.any());
    }

    @Test
    public void testExportNonDrawnDisplayer() {
        Displayer displayer = this.displayerLocator.lookupDisplayer(this.ALLROWS);
        displayer.export(ExportFormat.CSV, -1, this.exportCallback);
        ((ExportCallback)Mockito.verify((Object)this.exportCallback)).noData();
    }

    @Test
    public void testExportEmptyDisplayer() {
        Displayer displayer = this.displayerLocator.lookupDisplayer(this.EMPTY);
        displayer.draw();
        displayer.export(ExportFormat.CSV, -1, this.exportCallback);
        ((ExportCallback)Mockito.verify((Object)this.exportCallback)).noData();
    }

    @Test
    public void testExportLimitExceeded() {
        Displayer displayer = this.displayerLocator.lookupDisplayer(this.ALLROWS);
        displayer.draw();
        displayer.export(ExportFormat.CSV, 10, this.exportCallback);
        ((ExportCallback)Mockito.verify((Object)this.exportCallback)).tooManyRows(50);
    }

    @Test
    public void testExportLimitRuledOut() {
        Displayer displayer = this.displayerLocator.lookupDisplayer(this.ALLROWS);
        displayer.draw();
        displayer.export(ExportFormat.CSV, 0, this.exportCallback);
        ((ExportCallback)Mockito.verify((Object)this.exportCallback, (VerificationMode)Mockito.never())).tooManyRows(Mockito.anyInt());
        ((ExportCallback)Mockito.verify((Object)this.exportCallback)).exportFileUrl((String)Mockito.any());
    }

    @Test
    public void testDefaultNamesCsv() throws Exception {
        this.testDefaultNames(ExportFormat.CSV);
    }

    @Test
    public void testCustomNamesCsv() throws Exception {
        this.testCustomNames(ExportFormat.CSV);
    }

    @Test
    public void testDefaultNamesXls() throws Exception {
        this.testDefaultNames(ExportFormat.XLS);
    }

    @Test
    public void testCustomNamesXls() throws Exception {
        this.testCustomNames(ExportFormat.XLS);
    }

    public void testDefaultNames(ExportFormat format) throws Exception {
        Displayer displayer = this.displayerLocator.lookupDisplayer(this.ALLROWS);
        displayer.draw();
        displayer.export(format, 0, this.exportCallback);
        ArgumentCaptor dataSetCaptor = ArgumentCaptor.forClass(DataSet.class);
        if (ExportFormat.CSV.equals((Object)format)) {
            ((DataSetExportServices)Mockito.verify((Object)this.dataSetExportServices)).exportDataSetCSV((DataSet)dataSetCaptor.capture());
        } else {
            ((DataSetExportServices)Mockito.verify((Object)this.dataSetExportServices)).exportDataSetExcel((DataSet)dataSetCaptor.capture());
        }
        DataSet dataSet = (DataSet)dataSetCaptor.getValue();
        Assert.assertEquals((long)dataSet.getColumns().size(), (long)6L);
        Assert.assertEquals((Object)((DataColumn)dataSet.getColumns().get(0)).getId(), (Object)"EXPENSES_ID");
        Assert.assertEquals((Object)((DataColumn)dataSet.getColumns().get(1)).getId(), (Object)"CITY");
        Assert.assertEquals((Object)((DataColumn)dataSet.getColumns().get(2)).getId(), (Object)"DEPARTMENT");
        Assert.assertEquals((Object)((DataColumn)dataSet.getColumns().get(3)).getId(), (Object)"EMPLOYEE");
        Assert.assertEquals((Object)((DataColumn)dataSet.getColumns().get(4)).getId(), (Object)"CREATION_DATE");
        Assert.assertEquals((Object)((DataColumn)dataSet.getColumns().get(5)).getId(), (Object)"AMOUNT");
    }

    public void testCustomNames(ExportFormat format) throws Exception {
        Displayer displayer = this.displayerLocator.lookupDisplayer(this.CUSTOM_NAMES);
        displayer.draw();
        displayer.export(format, 0, this.exportCallback);
        ArgumentCaptor dataSetCaptor = ArgumentCaptor.forClass(DataSet.class);
        if (ExportFormat.CSV.equals((Object)format)) {
            ((DataSetExportServices)Mockito.verify((Object)this.dataSetExportServices)).exportDataSetCSV((DataSet)dataSetCaptor.capture());
        } else {
            ((DataSetExportServices)Mockito.verify((Object)this.dataSetExportServices)).exportDataSetExcel((DataSet)dataSetCaptor.capture());
        }
        DataSet dataSet = (DataSet)dataSetCaptor.getValue();
        Assert.assertEquals((long)dataSet.getColumns().size(), (long)5L);
        Assert.assertEquals((Object)((DataColumn)dataSet.getColumns().get(0)).getId(), (Object)"Dept");
        Assert.assertEquals((Object)((DataColumn)dataSet.getColumns().get(1)).getId(), (Object)"Emp");
        Assert.assertEquals((Object)((DataColumn)dataSet.getColumns().get(2)).getId(), (Object)"City");
        Assert.assertEquals((Object)((DataColumn)dataSet.getColumns().get(3)).getId(), (Object)"Date");
        Assert.assertEquals((Object)((DataColumn)dataSet.getColumns().get(4)).getId(), (Object)"$");
    }
}

