/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.displayer.client;

import org.dashbuilder.dataset.Assertions;
import org.dashbuilder.dataset.DataSet;
import org.dashbuilder.dataset.group.AggregateFunctionType;
import org.dashbuilder.displayer.DisplayerSettings;
import org.dashbuilder.displayer.DisplayerSettingsFactory;
import org.dashbuilder.displayer.client.AbstractDisplayer;
import org.dashbuilder.displayer.client.AbstractDisplayerTest;
import org.dashbuilder.displayer.client.Displayer;
import org.dashbuilder.displayer.client.DisplayerListener;
import org.dashbuilder.displayer.impl.PieChartSettingsBuilderImpl;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.Silent.class)
public class DisplayerLifecycleTest
extends AbstractDisplayerTest {
    DisplayerSettings settings = ((PieChartSettingsBuilderImpl)((PieChartSettingsBuilderImpl)((PieChartSettingsBuilderImpl)((PieChartSettingsBuilderImpl)((PieChartSettingsBuilderImpl)((PieChartSettingsBuilderImpl)DisplayerSettingsFactory.newPieChartSettings().uuid("expenses")).dataset("expenses")).group("CREATION_DATE")).column("CREATION_DATE")).column("AMOUNT", AggregateFunctionType.COUNT)).column("AMOUNT", AggregateFunctionType.SUM)).buildSettings();
    @Mock
    DisplayerListener listener;

    @Test
    public void testLookup() {
        Displayer displayer = this.displayerLocator.lookupDisplayer(this.settings);
        Assert.assertNotNull((Object)displayer);
        Assert.assertNotNull((Object)displayer.getDataSetHandler());
        Assert.assertNotNull((Object)displayer.getDisplayerSettings());
        Assert.assertEquals((Object)displayer.getDisplayerSettings(), (Object)this.settings);
    }

    @Test
    public void testDraw() {
        AbstractDisplayer displayer = (AbstractDisplayer)this.displayerLocator.lookupDisplayer(this.settings);
        AbstractDisplayer.View view = displayer.getView();
        displayer.addListener(new DisplayerListener[]{this.listener});
        Assert.assertEquals((Object)displayer.isDrawn(), (Object)false);
        displayer.draw();
        Assert.assertEquals((Object)displayer.isDrawn(), (Object)true);
        ((AbstractDisplayer.View)Mockito.verify((Object)view)).showLoading();
        ((AbstractDisplayer.View)Mockito.verify((Object)view)).setId("expenses");
        ((DisplayerListener)Mockito.verify((Object)this.listener)).onDataLookup((Displayer)displayer);
        ((DisplayerListener)Mockito.verify((Object)this.listener)).onDataLoaded((Displayer)displayer);
        ((DisplayerListener)Mockito.verify((Object)this.listener)).onDraw((Displayer)displayer);
        ((DisplayerListener)Mockito.verify((Object)this.listener, (VerificationMode)Mockito.never())).onRedraw((Displayer)displayer);
        Assertions.assertDataSetValues((DataSet)displayer.getDataSetHandler().getLastDataSet(), (String[][])new String[][]{{"2012", "13.00", "6,126.13"}, {"2013", "11.00", "5,252.96"}, {"2014", "11.00", "4,015.48"}, {"2015", "15.00", "7,336.69"}}, (int)0);
    }

    @Test
    public void testRedraw() {
        AbstractDisplayer displayer = (AbstractDisplayer)this.displayerLocator.lookupDisplayer(this.settings);
        AbstractDisplayer.View view = displayer.getView();
        displayer.addListener(new DisplayerListener[]{this.listener});
        displayer.draw();
        Mockito.reset((Object[])new AbstractDisplayer.View[]{view});
        Mockito.reset((Object[])new DisplayerListener[]{this.listener});
        Assert.assertEquals((Object)displayer.isDrawn(), (Object)true);
        displayer.redraw();
        Assert.assertEquals((Object)displayer.isDrawn(), (Object)true);
        ((DisplayerListener)Mockito.verify((Object)this.listener)).onDataLookup((Displayer)displayer);
        ((DisplayerListener)Mockito.verify((Object)this.listener)).onRedraw((Displayer)displayer);
        ((DisplayerListener)Mockito.verify((Object)this.listener, (VerificationMode)Mockito.never())).onDraw((Displayer)displayer);
        ((AbstractDisplayer.View)Mockito.verify((Object)view, (VerificationMode)Mockito.never())).showLoading();
        Assertions.assertDataSetValues((DataSet)displayer.getDataSetHandler().getLastDataSet(), (String[][])new String[][]{{"2012", "13.00", "6,126.13"}, {"2013", "11.00", "5,252.96"}, {"2014", "11.00", "4,015.48"}, {"2015", "15.00", "7,336.69"}}, (int)0);
    }

    @Test
    public void testClose() {
        AbstractDisplayer displayer = (AbstractDisplayer)this.displayerLocator.lookupDisplayer(this.settings);
        AbstractDisplayer.View view = displayer.getView();
        displayer.addListener(new DisplayerListener[]{this.listener});
        displayer.close();
        ((AbstractDisplayer.View)Mockito.verify((Object)view)).clear();
        ((DisplayerListener)Mockito.verify((Object)this.listener)).onClose((Displayer)displayer);
    }
}

