/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.displayer.client.widgets.filter;

import java.util.Arrays;
import org.dashbuilder.displayer.client.widgets.filter.MultipleNumberParameterEditor;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.uberfire.mvp.Command;

@RunWith(value=MockitoJUnitRunner.class)
public class MultipleNumberParameterEditorTest {
    MultipleNumberParameterEditor presenter;
    @Mock
    MultipleNumberParameterEditor.View view;
    @Mock
    Command changedEvent;

    @Before
    public void init() {
        this.presenter = new MultipleNumberParameterEditor(this.view);
    }

    @Test
    public void testShowSingleValue() {
        this.presenter.setValues(Arrays.asList(10.0));
        ((MultipleNumberParameterEditor.View)Mockito.verify((Object)this.view)).setValue("10.0");
    }

    @Test
    public void testShowSingleValue2() {
        this.presenter.setValues(Arrays.asList("10"));
        ((MultipleNumberParameterEditor.View)Mockito.verify((Object)this.view)).setValue("10");
    }

    @Test
    public void testShowMultipleValues() {
        this.presenter.setValues(Arrays.asList(10.0, 20.0, 30.0));
        ((MultipleNumberParameterEditor.View)Mockito.verify((Object)this.view)).setValue("10.0 | 20.0 | 30.0");
    }

    @Test
    public void testParseVoidInput() {
        Mockito.when((Object)this.view.getValue()).thenReturn((Object)"");
        this.presenter.valueChanged();
        Assert.assertTrue((boolean)this.presenter.getValues().isEmpty());
        ((MultipleNumberParameterEditor.View)Mockito.verify((Object)this.view)).error();
    }

    @Test
    public void testParseSingleInput() {
        Mockito.when((Object)this.view.getValue()).thenReturn((Object)"3");
        this.presenter.valueChanged();
        Assert.assertEquals((long)this.presenter.getValues().size(), (long)1L);
        Assert.assertEquals(this.presenter.getValues().get(0), (Object)3.0);
    }

    @Test
    public void testMultipleInput() {
        Mockito.when((Object)this.view.getValue()).thenReturn((Object)"|1| 2 | 3|4|  ");
        this.presenter.valueChanged();
        Assert.assertEquals((long)this.presenter.getValues().size(), (long)4L);
        Assert.assertEquals(this.presenter.getValues().get(0), (Object)1.0);
        Assert.assertEquals(this.presenter.getValues().get(1), (Object)2.0);
        Assert.assertEquals(this.presenter.getValues().get(2), (Object)3.0);
        Assert.assertEquals(this.presenter.getValues().get(3), (Object)4.0);
        this.presenter.valueChanged();
        Assert.assertEquals((long)this.presenter.getValues().size(), (long)4L);
    }

    @Test
    public void testMultipleInput2() {
        Mockito.when((Object)this.view.getValue()).thenReturn((Object)",1, 2 , 3,4,  ");
        this.presenter.valueChanged();
        Assert.assertEquals((long)this.presenter.getValues().size(), (long)4L);
        Assert.assertEquals(this.presenter.getValues().get(0), (Object)1.0);
        Assert.assertEquals(this.presenter.getValues().get(1), (Object)2.0);
        Assert.assertEquals(this.presenter.getValues().get(2), (Object)3.0);
        Assert.assertEquals(this.presenter.getValues().get(3), (Object)4.0);
    }

    @Test
    public void testSingleInputError() {
        Mockito.when((Object)this.view.getValue()).thenReturn((Object)"a");
        this.presenter.valueChanged();
        Assert.assertTrue((boolean)this.presenter.getValues().isEmpty());
        ((MultipleNumberParameterEditor.View)Mockito.verify((Object)this.view)).error();
    }

    @Test
    public void testMultipleInputError() {
        Mockito.when((Object)this.view.getValue()).thenReturn((Object)"a,3");
        this.presenter.valueChanged();
        Assert.assertTrue((boolean)this.presenter.getValues().isEmpty());
        ((MultipleNumberParameterEditor.View)Mockito.verify((Object)this.view)).error();
    }
}

