/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.displayer.client.widgets;

import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Style;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.uibinder.client.UiHandler;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Widget;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.dashbuilder.common.client.error.ClientRuntimeError;
import org.dashbuilder.common.client.widgets.AlertPanel;
import org.dashbuilder.displayer.client.resources.i18n.CommonConstants;
import org.dashbuilder.displayer.client.widgets.DataSetLookupEditor;
import org.dashbuilder.displayer.client.widgets.DisplayerEditor;
import org.dashbuilder.displayer.client.widgets.DisplayerErrorWidget;
import org.dashbuilder.displayer.client.widgets.DisplayerSettingsEditor;
import org.dashbuilder.displayer.client.widgets.DisplayerTypeSelector;
import org.dashbuilder.displayer.client.widgets.ExternalComponentPropertiesEditor;
import org.gwtbootstrap3.client.ui.CheckBox;
import org.gwtbootstrap3.client.ui.Column;
import org.gwtbootstrap3.client.ui.Row;
import org.gwtbootstrap3.client.ui.TabListItem;
import org.gwtbootstrap3.client.ui.constants.AlertType;
import org.uberfire.mvp.Command;

@Dependent
public class DisplayerEditorView
extends Composite
implements DisplayerEditor.View {
    private static Binder uiBinder = (Binder)GWT.create(Binder.class);
    @UiField
    Column westColumn;
    @UiField
    Column leftColumn;
    @UiField
    Column centerColumn;
    @UiField
    TabListItem optionType;
    @UiField
    TabListItem optionData;
    @UiField
    TabListItem optionSettings;
    @UiField
    TabListItem optionComponentSettings;
    @UiField
    Row viewAsTableButtonRow;
    @UiField
    CheckBox viewAsTableButton;
    protected DisplayerEditor presenter;
    @Inject
    protected DisplayerErrorWidget errorWidget;

    public void init(DisplayerEditor presenter) {
        this.presenter = presenter;
        this.initWidget((Widget)uiBinder.createAndBindUi(this));
        this.viewAsTableButtonRow.getElement().setAttribute("cellpadding", "5");
        this.setComponentSettingsEnabled(false);
    }

    @Override
    public String getBrandNewDisplayerTitle() {
        return "- " + CommonConstants.INSTANCE.displayer_editor_new() + " -";
    }

    @Override
    public void showDisplayer(IsWidget displayer) {
        this.centerColumn.clear();
        this.centerColumn.add(displayer);
    }

    @Override
    public void setTypeSelectionEnabled(boolean enabled) {
        this.optionType.setVisible(enabled);
        this.goToOtherSectionIfActive(this.optionType);
    }

    @Override
    public void setDisplaySettingsEnabled(boolean enabled) {
        this.optionSettings.setVisible(enabled);
        this.goToOtherSectionIfActive(this.optionSettings);
    }

    @Override
    public void setDataSetLookupConfEnabled(boolean enabled) {
        this.optionData.setVisible(enabled);
        this.goToOtherSectionIfActive(this.optionData);
    }

    @Override
    public void setComponentSettingsEnabled(boolean enabled) {
        this.optionComponentSettings.setVisible(enabled);
        this.goToOtherSectionIfActive(this.optionComponentSettings);
    }

    @Override
    public boolean isTableDisplayModeOn() {
        return this.viewAsTableButtonRow.isVisible() && this.viewAsTableButton.getValue() != false;
    }

    @Override
    public void setTableDisplayModeEnabled(boolean enabled) {
        this.viewAsTableButtonRow.setVisible(enabled);
    }

    @Override
    public void goToTypeSelection(DisplayerTypeSelector typeSelector) {
        this.leftColumn.clear();
        this.leftColumn.getElement().getStyle().setOverflowY(Style.Overflow.HIDDEN);
        this.leftColumn.add((IsWidget)typeSelector);
        this.viewAsTableButtonRow.setVisible(false);
        this.optionData.setActive(false);
        this.optionSettings.setActive(false);
        this.optionType.setActive(true);
        this.optionComponentSettings.setActive(false);
    }

    @Override
    public void goToDataSetLookupConf(DataSetLookupEditor lookupEditor) {
        this.leftColumn.clear();
        this.leftColumn.getElement().getStyle().setOverflowY(Style.Overflow.AUTO);
        this.leftColumn.add((IsWidget)lookupEditor);
        this.optionSettings.setActive(false);
        this.optionType.setActive(false);
        this.optionData.setActive(true);
        this.optionComponentSettings.setActive(false);
    }

    @Override
    public void goToDisplaySettings(DisplayerSettingsEditor settingsEditor) {
        this.leftColumn.clear();
        this.leftColumn.getElement().getStyle().setOverflowY(Style.Overflow.AUTO);
        this.leftColumn.add((IsWidget)settingsEditor);
        this.viewAsTableButtonRow.setVisible(false);
        this.optionType.setActive(false);
        this.optionData.setActive(false);
        this.optionSettings.setActive(true);
        this.optionComponentSettings.setActive(false);
    }

    @Override
    public void gotoExternalComponentSettings(ExternalComponentPropertiesEditor externalComponentPropertiesEditor) {
        this.leftColumn.clear();
        this.leftColumn.getElement().getStyle().setOverflowY(Style.Overflow.AUTO);
        this.leftColumn.add((IsWidget)externalComponentPropertiesEditor);
        this.viewAsTableButtonRow.setVisible(false);
        this.optionType.setActive(false);
        this.optionData.setActive(false);
        this.optionSettings.setActive(false);
        this.optionComponentSettings.setActive(true);
    }

    @Override
    public void showTypeChangedWarning(Command yes, Command no) {
        AlertPanel alertPanel = new AlertPanel();
        String alertMsg = CommonConstants.INSTANCE.displayer_editor_incompatible_settings();
        alertPanel.show(AlertType.WARNING, alertMsg, Integer.valueOf(400), yes, no);
        this.centerColumn.clear();
        this.centerColumn.add((IsWidget)alertPanel);
    }

    @Override
    public void error(String error) {
        this.centerColumn.clear();
        this.centerColumn.add((Widget)this.errorWidget);
        this.errorWidget.show(error, null);
        GWT.log((String)error);
    }

    @Override
    public void error(ClientRuntimeError e) {
        this.centerColumn.clear();
        this.centerColumn.add((Widget)this.errorWidget);
        this.errorWidget.show(e.getMessage(), e.getThrowable());
        if (e.getThrowable() != null) {
            GWT.log((String)e.getMessage(), (Throwable)e.getThrowable());
        } else {
            GWT.log((String)e.getMessage());
        }
    }

    @UiHandler(value={"optionType"})
    public void onTypeSelected(ClickEvent clickEvent) {
        this.presenter.gotoTypeSelection();
    }

    @UiHandler(value={"optionData"})
    public void onDataSelected(ClickEvent clickEvent) {
        this.presenter.gotoDataSetLookupConf();
    }

    @UiHandler(value={"optionSettings"})
    public void onSettingsSelected(ClickEvent clickEvent) {
        this.presenter.gotoDisplaySettings();
    }

    @UiHandler(value={"optionComponentSettings"})
    public void onExternalComponentSettingsSelected(ClickEvent clickEvent) {
        this.presenter.gotoExternalComponentSettings();
    }

    @UiHandler(value={"viewAsTableButton"})
    public void onRawTableChecked(ClickEvent clickEvent) {
        this.presenter.showDisplayer();
    }

    private void goToOtherSectionIfActive(TabListItem item) {
        if (item.isActive()) {
            this.presenter.gotoFirstSectionEnabled();
        }
    }

    static interface Binder
    extends UiBinder<Widget, DisplayerEditorView> {
    }
}

