/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.displayer.client.widgets;

import com.google.gwt.dom.client.Document;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Widget;
import elemental2.dom.HTMLDivElement;
import elemental2.dom.HTMLElement;
import java.util.ArrayList;
import java.util.Collection;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import javax.inject.Named;
import org.dashbuilder.displayer.client.resources.i18n.CommonConstants;
import org.dashbuilder.displayer.client.widgets.ExternalComponentPropertiesEditor;
import org.jboss.errai.common.client.dom.elemental2.Elemental2DomUtil;
import org.jboss.errai.ui.shared.api.annotations.DataField;
import org.jboss.errai.ui.shared.api.annotations.Templated;
import org.uberfire.ext.properties.editor.client.PropertyEditorWidget;
import org.uberfire.ext.properties.editor.model.PropertyEditorCategory;
import org.uberfire.ext.properties.editor.model.PropertyEditorChangeEvent;
import org.uberfire.ext.properties.editor.model.PropertyEditorEvent;
import org.uberfire.ext.properties.editor.model.PropertyEditorFieldInfo;

@Dependent
@Templated
public class ExternalComponentPropertiesEditorView
extends Composite
implements ExternalComponentPropertiesEditor.View {
    private final CommonConstants i18n = CommonConstants.INSTANCE;
    private final String externalComponentEditorId = Document.get().createUniqueId();
    @Inject
    @DataField
    HTMLDivElement externalComponentPropertiesRoot;
    @Inject
    @DataField
    HTMLDivElement messageContainer;
    @Inject
    @DataField
    @Named(value="strong")
    HTMLElement messageTextContainer;
    @Inject
    Elemental2DomUtil elementalUtil;
    private PropertyEditorWidget propertyEditorWidget;
    private ExternalComponentPropertiesEditor presenter;

    public void init(ExternalComponentPropertiesEditor presenter) {
        this.presenter = presenter;
        this.messageContainer.hidden = true;
        this.propertyEditorWidget = new PropertyEditorWidget();
        this.elementalUtil.appendWidgetToElement((HTMLElement)this.externalComponentPropertiesRoot, (Widget)this.propertyEditorWidget);
    }

    @Override
    public void componentNotFound() {
        this.showMessage(this.i18n.componentNotFound());
    }

    @Override
    public void addCategories(Collection<PropertyEditorCategory> categories) {
        this.messageContainer.hidden = true;
        this.externalComponentPropertiesRoot.hidden = false;
        ArrayList<PropertyEditorCategory> catList = new ArrayList<PropertyEditorCategory>(categories);
        this.propertyEditorWidget.handle(new PropertyEditorEvent(this.externalComponentEditorId, catList));
    }

    protected void onPropertyEditorChange(@Observes PropertyEditorChangeEvent event) {
        PropertyEditorFieldInfo property = event.getProperty();
        if (property.getEventId().equalsIgnoreCase(this.externalComponentEditorId)) {
            this.presenter.onPropertyChange(property.getKey(), property.getCurrentStringValue());
        }
    }

    @Override
    public void noPropertiesComponent() {
        this.showMessage(this.i18n.noPropertiesComponent());
    }

    private void showMessage(String message) {
        this.messageContainer.hidden = false;
        this.externalComponentPropertiesRoot.hidden = true;
        this.messageTextContainer.textContent = message;
    }
}

