/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.displayer.client.widgets.filter;

import com.google.gwt.user.client.ui.IsWidget;
import java.lang.annotation.Annotation;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.dashbuilder.dataset.ColumnType;
import org.dashbuilder.dataset.DataSetMetadata;
import org.dashbuilder.dataset.filter.ColumnFilter;
import org.dashbuilder.dataset.filter.CoreFunctionFilter;
import org.dashbuilder.dataset.filter.CoreFunctionType;
import org.dashbuilder.displayer.client.events.ColumnFilterChangedEvent;
import org.dashbuilder.displayer.client.events.ColumnFilterDeletedEvent;
import org.dashbuilder.displayer.client.widgets.filter.ColumnFilterEditor;
import org.dashbuilder.displayer.client.widgets.filter.DateParameterEditor;
import org.dashbuilder.displayer.client.widgets.filter.LikeToFunctionEditor;
import org.dashbuilder.displayer.client.widgets.filter.NumberParameterEditor;
import org.dashbuilder.displayer.client.widgets.filter.TextParameterEditor;
import org.dashbuilder.displayer.client.widgets.filter.TimeFrameEditor;
import org.jboss.errai.ioc.client.container.SyncBeanDef;
import org.jboss.errai.ioc.client.container.SyncBeanManager;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.uberfire.mocks.EventSourceMock;

@RunWith(value=MockitoJUnitRunner.class)
public class ColumnFilterEditorTest {
    @Mock
    ColumnFilterEditor.View view;
    @Mock
    SyncBeanManager beanManager;
    @Mock
    SyncBeanDef<TextParameterEditor> textParameterBeanDef;
    @Mock
    SyncBeanDef<NumberParameterEditor> numberParameterBeanDef;
    @Mock
    SyncBeanDef<DateParameterEditor> dateParameterBeanDef;
    @Mock
    SyncBeanDef<TimeFrameEditor> timeFrameBeanDef;
    @Mock
    SyncBeanDef<LikeToFunctionEditor> likeToFunctionBeanDef;
    @Mock
    TextParameterEditor textParameterEditor;
    @Mock
    NumberParameterEditor numberParameterEditor;
    @Mock
    DateParameterEditor dateParameterEditor;
    @Mock
    TimeFrameEditor timeFrameEditor;
    @Mock
    LikeToFunctionEditor likeToFunctionEditor;
    @Mock
    DataSetMetadata metadata;
    @Mock
    EventSourceMock<ColumnFilterChangedEvent> changedEvent;
    @Mock
    EventSourceMock<ColumnFilterDeletedEvent> deletedEvent;

    @Before
    public void init() {
        Mockito.when((Object)this.beanManager.lookupBean(TextParameterEditor.class, new Annotation[0])).thenReturn(this.textParameterBeanDef);
        Mockito.when((Object)this.beanManager.lookupBean(NumberParameterEditor.class, new Annotation[0])).thenReturn(this.numberParameterBeanDef);
        Mockito.when((Object)this.beanManager.lookupBean(DateParameterEditor.class, new Annotation[0])).thenReturn(this.dateParameterBeanDef);
        Mockito.when((Object)this.beanManager.lookupBean(TimeFrameEditor.class, new Annotation[0])).thenReturn(this.timeFrameBeanDef);
        Mockito.when((Object)this.beanManager.lookupBean(LikeToFunctionEditor.class, new Annotation[0])).thenReturn(this.likeToFunctionBeanDef);
        Mockito.when((Object)((TextParameterEditor)this.textParameterBeanDef.newInstance())).thenReturn((Object)this.textParameterEditor);
        Mockito.when((Object)((NumberParameterEditor)this.numberParameterBeanDef.newInstance())).thenReturn((Object)this.numberParameterEditor);
        Mockito.when((Object)((DateParameterEditor)this.dateParameterBeanDef.newInstance())).thenReturn((Object)this.dateParameterEditor);
        Mockito.when((Object)((LikeToFunctionEditor)this.likeToFunctionBeanDef.newInstance())).thenReturn((Object)this.likeToFunctionEditor);
        Mockito.when((Object)((TimeFrameEditor)this.timeFrameBeanDef.newInstance())).thenReturn((Object)this.timeFrameEditor);
    }

    protected ColumnFilterEditor setupEditor(ColumnType columnType, CoreFunctionType functionType, Comparable ... params) {
        Mockito.when((Object)this.metadata.getColumnType("col")).thenReturn((Object)columnType);
        CoreFunctionFilter filter = new CoreFunctionFilter("col", functionType, params);
        ColumnFilterEditor filterEditor = new ColumnFilterEditor(this.view, this.beanManager, this.changedEvent, this.deletedEvent);
        filterEditor.init(this.metadata, (ColumnFilter)filter);
        Assert.assertEquals((Object)this.view, (Object)filterEditor.getView());
        return filterEditor;
    }

    @Test
    public void testTextParam() {
        this.setupEditor(ColumnType.LABEL, CoreFunctionType.EQUALS_TO, new Comparable[]{"Test"});
        int n = CoreFunctionType.getSupportedTypes((ColumnType)ColumnType.LABEL).size() - 1;
        ((ColumnFilterEditor.View)Mockito.verify((Object)this.view)).clearFunctionSelector();
        ((ColumnFilterEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)n))).addFunctionItem((CoreFunctionType)Mockito.any());
        ((ColumnFilterEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).addFunctionItem(CoreFunctionType.TIME_FRAME);
        ((ColumnFilterEditor.View)Mockito.verify((Object)this.view)).clearFilterConfig();
        ((ColumnFilterEditor.View)Mockito.verify((Object)this.view)).addFilterConfigWidget((IsWidget)this.textParameterEditor);
        ((ColumnFilterEditor.View)Mockito.verify((Object)this.view)).setFunctionSelected("col = Test");
    }

    @Test
    public void testNumberParam() throws Exception {
        double number = 1000.23;
        NumberFormat numberFormat = NumberFormat.getNumberInstance();
        Mockito.when((Object)this.view.formatNumber((Number)number)).thenReturn((Object)numberFormat.format(number));
        this.setupEditor(ColumnType.NUMBER, CoreFunctionType.EQUALS_TO, Double.valueOf(number));
        int n = CoreFunctionType.getSupportedTypes((ColumnType)ColumnType.NUMBER).size() - 1;
        ((ColumnFilterEditor.View)Mockito.verify((Object)this.view)).clearFunctionSelector();
        ((ColumnFilterEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)n))).addFunctionItem((CoreFunctionType)Mockito.any());
        ((ColumnFilterEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).addFunctionItem(CoreFunctionType.TIME_FRAME);
        ((ColumnFilterEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).addFunctionItem(CoreFunctionType.LIKE_TO);
        ((ColumnFilterEditor.View)Mockito.verify((Object)this.view)).clearFilterConfig();
        ((ColumnFilterEditor.View)Mockito.verify((Object)this.view)).addFilterConfigWidget((IsWidget)this.numberParameterEditor);
        ((ColumnFilterEditor.View)Mockito.verify((Object)this.view)).setFunctionSelected("col = " + numberFormat.format(number));
    }

    @Test
    public void testDateParam() throws Exception {
        SimpleDateFormat dateFormat = new SimpleDateFormat("dd-MM-yyyy HH:mm:ss");
        String dateStr = "23-11-2020 23:59:59";
        Date d = dateFormat.parse(dateStr);
        Mockito.when((Object)this.view.formatDate(d)).thenReturn((Object)dateStr);
        this.setupEditor(ColumnType.DATE, CoreFunctionType.EQUALS_TO, d);
        int n = CoreFunctionType.getSupportedTypes((ColumnType)ColumnType.DATE).size() - 1;
        ((ColumnFilterEditor.View)Mockito.verify((Object)this.view)).clearFunctionSelector();
        ((ColumnFilterEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)n))).addFunctionItem((CoreFunctionType)Mockito.any());
        ((ColumnFilterEditor.View)Mockito.verify((Object)this.view)).addFunctionItem(CoreFunctionType.TIME_FRAME);
        ((ColumnFilterEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).addFunctionItem(CoreFunctionType.LIKE_TO);
        ((ColumnFilterEditor.View)Mockito.verify((Object)this.view)).clearFilterConfig();
        ((ColumnFilterEditor.View)Mockito.verify((Object)this.view)).addFilterConfigWidget((IsWidget)this.dateParameterEditor);
        ((ColumnFilterEditor.View)Mockito.verify((Object)this.view)).setFunctionSelected("col = " + dateStr);
    }

    @Test
    public void testNotEquals() {
        this.setupEditor(ColumnType.LABEL, CoreFunctionType.NOT_EQUALS_TO, new Comparable[]{"Test"});
        ((ColumnFilterEditor.View)Mockito.verify((Object)this.view)).setFunctionSelected("col != Test");
    }

    @Test
    public void testBetween() {
        this.setupEditor(ColumnType.LABEL, CoreFunctionType.BETWEEN, new Comparable[]{"A", "B"});
        ((ColumnFilterEditor.View)Mockito.verify((Object)this.view)).setFunctionSelected("col [A B]");
    }

    @Test
    public void testGreaterOrEquals() {
        this.setupEditor(ColumnType.LABEL, CoreFunctionType.GREATER_OR_EQUALS_TO, new Comparable[]{"Test"});
        ((ColumnFilterEditor.View)Mockito.verify((Object)this.view)).setFunctionSelected("col >= Test");
    }

    @Test
    public void testGreaterThan() {
        this.setupEditor(ColumnType.LABEL, CoreFunctionType.GREATER_THAN, new Comparable[]{"Test"});
        ((ColumnFilterEditor.View)Mockito.verify((Object)this.view)).setFunctionSelected("col > Test");
    }

    @Test
    public void testLowerOrEquals() {
        this.setupEditor(ColumnType.LABEL, CoreFunctionType.LOWER_OR_EQUALS_TO, new Comparable[]{"Test"});
        ((ColumnFilterEditor.View)Mockito.verify((Object)this.view)).setFunctionSelected("col <= Test");
    }

    @Test
    public void testLowerThan() {
        this.setupEditor(ColumnType.LABEL, CoreFunctionType.LOWER_THAN, new Comparable[]{"Test"});
        ((ColumnFilterEditor.View)Mockito.verify((Object)this.view)).setFunctionSelected("col < Test");
    }

    @Test
    public void testNull() {
        this.setupEditor(ColumnType.LABEL, CoreFunctionType.IS_NULL, new Comparable[0]);
        ((ColumnFilterEditor.View)Mockito.verify((Object)this.view)).setFunctionSelected("col = null ");
    }

    @Test
    public void testNotNull() {
        this.setupEditor(ColumnType.LABEL, CoreFunctionType.NOT_NULL, new Comparable[0]);
        ((ColumnFilterEditor.View)Mockito.verify((Object)this.view)).setFunctionSelected("col != null ");
    }

    @Test
    public void testLikeTo() {
        this.setupEditor(ColumnType.LABEL, CoreFunctionType.LIKE_TO, new Comparable[]{"Test"});
        ((ColumnFilterEditor.View)Mockito.verify((Object)this.view)).clearFilterConfig();
        ((ColumnFilterEditor.View)Mockito.verify((Object)this.view)).setFunctionSelected("col like Test");
        ((ColumnFilterEditor.View)Mockito.verify((Object)this.view)).addFilterConfigWidget((IsWidget)this.likeToFunctionEditor);
    }

    @Test
    public void testTimeFrame() {
        this.setupEditor(ColumnType.DATE, CoreFunctionType.TIME_FRAME, new Comparable[]{"begin[year February] till now"});
        ((ColumnFilterEditor.View)Mockito.verify((Object)this.view)).clearFilterConfig();
        ((ColumnFilterEditor.View)Mockito.verify((Object)this.view)).setFunctionSelected("col = begin[year February] till now");
        ((ColumnFilterEditor.View)Mockito.verify((Object)this.view)).addFilterConfigWidget((IsWidget)this.timeFrameEditor);
    }

    @Test
    public void testSelectFunction() {
        ColumnFilterEditor presenter = this.setupEditor(ColumnType.LABEL, CoreFunctionType.EQUALS_TO, new Comparable[]{"value"});
        ((ColumnFilterEditor.View)Mockito.verify((Object)this.view)).clearFilterConfig();
        ((ColumnFilterEditor.View)Mockito.verify((Object)this.view)).setFunctionSelected("col = value");
        Mockito.reset((Object[])new ColumnFilterEditor.View[]{this.view});
        Mockito.when((Object)this.view.getSelectedFunctionIndex()).thenReturn((Object)2);
        presenter.onSelectFilterFunction();
        Assert.assertEquals((Object)presenter.getCoreFilter().getType(), (Object)CoreFunctionType.NOT_EQUALS_TO);
        ((EventSourceMock)Mockito.verify(this.changedEvent)).fire((Object)((ColumnFilterChangedEvent)Mockito.any()));
        ((ColumnFilterEditor.View)Mockito.verify((Object)this.view)).clearFilterConfig();
        ((ColumnFilterEditor.View)Mockito.verify((Object)this.view)).setFunctionSelected("col != value1");
    }
}

