/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.displayer.client.component;

import elemental2.core.JsMap;
import elemental2.dom.DomGlobal;
import elemental2.dom.MessageEvent;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import jsinterop.base.Js;
import org.dashbuilder.displayer.client.component.ExternalComponentListener;
import org.dashbuilder.displayer.client.component.function.ComponentFunctionLocator;
import org.dashbuilder.displayer.client.resources.i18n.CommonConstants;
import org.dashbuilder.displayer.external.ExternalComponentFunction;
import org.dashbuilder.displayer.external.ExternalComponentMessage;
import org.dashbuilder.displayer.external.ExternalComponentMessageHelper;
import org.dashbuilder.displayer.external.ExternalComponentMessageType;
import org.dashbuilder.displayer.external.FunctionCallRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class ExternalComponentDispatcher {
    private static final CommonConstants i18n = CommonConstants.INSTANCE;
    private static final Logger LOGGER = LoggerFactory.getLogger(ExternalComponentDispatcher.class);
    @Inject
    ExternalComponentMessageHelper messageHelper;
    @Inject
    ComponentFunctionLocator functionLocator;
    Set<ExternalComponentListener> listeners;

    @PostConstruct
    public void setup() {
        this.listeners = new HashSet<ExternalComponentListener>();
        this.startListening();
    }

    public void register(ExternalComponentListener listener) {
        listener.prepare();
        this.listeners.add(listener);
    }

    public void unregister(ExternalComponentListener listener) {
        this.listeners.remove(listener);
    }

    public void onMessage(ExternalComponentMessage message) {
        ExternalComponentMessageType type = this.messageHelper.messageType(message);
        switch (type) {
            case FILTER: {
                this.handleFilter(message);
                break;
            }
            case FUNCTION_CALL: {
                this.handleFunction(message);
                break;
            }
            case READY: {
                this.handleReady(message);
                break;
            }
            case FIX_CONFIGURATION: {
                this.handleConfiguration(message);
                break;
            }
            case CONFIGURATION_OK: {
                this.handleOkConfiguration(message);
                break;
            }
        }
    }

    private void handleOkConfiguration(ExternalComponentMessage message) {
        this.findDestination(message, ExternalComponentListener::configurationOk);
    }

    private void handleConfiguration(ExternalComponentMessage message) {
        this.findDestination(message, destination -> destination.onConfigurationIssue(this.messageHelper.getConfigurationIssue(message).orElse(i18n.componentConfigDefaultMessage())));
    }

    private void handleFunction(ExternalComponentMessage message) {
        this.findDestination(message, destination -> {
            Optional functionCallOp = this.messageHelper.functionCallRequest(message);
            if (functionCallOp.isPresent()) {
                this.callFunction((ExternalComponentListener)destination, (FunctionCallRequest)functionCallOp.get());
            } else {
                destination.sendMessage(this.messageHelper.newFunctionRequestNotFound());
            }
        });
    }

    private void callFunction(ExternalComponentListener destination, FunctionCallRequest functionCallRequest) {
        Optional<ExternalComponentFunction> target = this.functionLocator.findFunctionByName(functionCallRequest.getFunctionName());
        if (target.isPresent()) {
            this.execFunction(target.get(), functionCallRequest, destination::sendMessage);
        } else {
            destination.sendMessage(this.messageHelper.newFunctionNotFound(functionCallRequest));
        }
    }

    private void execFunction(ExternalComponentFunction target, FunctionCallRequest functionCallRequest, Consumer<ExternalComponentMessage> consumeResult) {
        try {
            Map<String, Object> params = this.extractParams(functionCallRequest);
            target.exec(params, result -> consumeResult.accept(this.messageHelper.newFunctionSuccess(functionCallRequest, result)), error -> consumeResult.accept(this.messageHelper.newFunctionError(functionCallRequest, error)));
        }
        catch (Exception e) {
            consumeResult.accept(this.messageHelper.newFunctionError(functionCallRequest, e.getMessage()));
        }
    }

    private Map<String, Object> extractParams(FunctionCallRequest functionCallRequest) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        JsMap requestParams = functionCallRequest.getParameters();
        if (requestParams != null) {
            requestParams.forEach((v, k, m) -> params.put((String)k, v));
        }
        return params;
    }

    private void handleReady(ExternalComponentMessage message) {
        this.findDestination(message, ExternalComponentListener::prepare);
    }

    private void handleFilter(ExternalComponentMessage message) {
        this.findDestination(message, listener -> this.messageHelper.filterRequest(message).ifPresent(listener::onFilter));
    }

    private void findDestination(ExternalComponentMessage message, Consumer<ExternalComponentListener> consumeDestination) {
        Optional destinationOp = this.messageHelper.getComponentId(message).flatMap(id -> this.listeners.stream().filter(listener -> listener.getId().equals(id)).findAny());
        destinationOp.ifPresent(consumeDestination);
        if (!destinationOp.isPresent()) {
            LOGGER.warn("Ignoring message, destination not found.");
        }
    }

    private void startListening() {
        DomGlobal.window.addEventListener("message", e -> {
            MessageEvent event = (MessageEvent)Js.cast((Object)e);
            if (event.data instanceof ExternalComponentMessage) {
                this.onMessage((ExternalComponentMessage)Js.cast((Object)event.data));
            }
        });
    }
}

