/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.displayer.client.component.function;

import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.dashbuilder.displayer.client.component.function.ComponentFunctionLocator;
import org.dashbuilder.displayer.external.ExternalComponentFunction;
import org.dashbuilder.external.service.BackendComponentFunctionService;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.ioc.client.api.EntryPoint;

@EntryPoint
public class BackendFunctionLoader {
    private static final String UNKNOWN_BACKEND_ERROR = "Unknown backend error.";
    @Inject
    ComponentFunctionLocator componentFunctionLocator;
    @Inject
    Caller<BackendComponentFunctionService> backendFunctionLoaderService;

    @PostConstruct
    public void loadBackendFunctions() {
        ((BackendComponentFunctionService)this.backendFunctionLoaderService.call(result -> this.registerFunctions((List<String>)result))).listFunctions();
    }

    private void registerFunctions(List<String> result) {
        result.forEach(name -> this.componentFunctionLocator.registerFunction(new ExternalComponentFunction((String)name){
            final /* synthetic */ String val$name;
            {
                this.val$name = string;
            }

            public String getName() {
                return this.val$name;
            }

            public void exec(Map<String, Object> params, Consumer<Object> onFinish, Consumer<String> onError) {
                ((BackendComponentFunctionService)BackendFunctionLoader.this.backendFunctionLoaderService.call(onFinish::accept, (message, throwable) -> {
                    String errorMessage = BackendFunctionLoader.UNKNOWN_BACKEND_ERROR;
                    if (throwable != null && throwable.getMessage() != null) {
                        errorMessage = throwable.getMessage();
                    } else if (message != null) {
                        errorMessage = message.toString();
                    }
                    onError.accept(errorMessage);
                    return false;
                })).callFunction(this.val$name, params);
            }
        }));
    }
}

