/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.displayer.client.component;

import com.google.gwtmockito.GwtMockitoTestRunner;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import org.dashbuilder.displayer.client.component.ExternalComponentDispatcher;
import org.dashbuilder.displayer.client.component.ExternalComponentListener;
import org.dashbuilder.displayer.client.component.function.ComponentFunctionLocator;
import org.dashbuilder.displayer.client.resources.i18n.CommonConstants;
import org.dashbuilder.displayer.external.ExternalComponentFunction;
import org.dashbuilder.displayer.external.ExternalComponentMessage;
import org.dashbuilder.displayer.external.ExternalComponentMessageHelper;
import org.dashbuilder.displayer.external.ExternalComponentMessageType;
import org.dashbuilder.displayer.external.ExternalFilterRequest;
import org.dashbuilder.displayer.external.FunctionCallRequest;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Captor;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

@RunWith(value=GwtMockitoTestRunner.class)
public class ExternalComponentDispatcherTest {
    private static final String DEST1 = "DEST1";
    @Mock
    ExternalComponentMessageHelper messageHelper;
    @Mock
    ComponentFunctionLocator functionLocator;
    @Mock
    ExternalComponentListener listener;
    @InjectMocks
    ExternalComponentDispatcher dispatcher;
    @Captor
    ArgumentCaptor<Consumer<Object>> functionExecutionCaptor;

    @Before
    public void setup() {
        this.dispatcher.listeners = new HashSet();
        Mockito.when((Object)this.listener.getId()).thenReturn((Object)DEST1);
        this.dispatcher.register(this.listener);
    }

    @Test
    public void testFilterWithoutFilterRequest() {
        ExternalComponentMessage message = this.filterMessage();
        this.withId(message, Optional.of(DEST1));
        this.dispatcher.onMessage(message);
        ((ExternalComponentListener)Mockito.verify((Object)this.listener, (VerificationMode)Mockito.times((int)0))).onFilter((ExternalFilterRequest)ArgumentMatchers.any());
    }

    @Test
    public void testFilterWithoutDestination() {
        ExternalComponentMessage message = this.filterMessage();
        this.noId(message);
        this.dispatcher.onMessage(message);
        ((ExternalComponentListener)Mockito.verify((Object)this.listener, (VerificationMode)Mockito.times((int)0))).onFilter((ExternalFilterRequest)ArgumentMatchers.any());
    }

    @Test
    public void testFilter() {
        ExternalFilterRequest filterRequest = (ExternalFilterRequest)Mockito.mock(ExternalFilterRequest.class);
        Optional<ExternalFilterRequest> filterRequestOp = Optional.of(filterRequest);
        ExternalComponentMessage message = this.filterMessage(filterRequestOp);
        this.withId(message, Optional.of(DEST1));
        this.dispatcher.onMessage(message);
        ((ExternalComponentListener)Mockito.verify((Object)this.listener)).onFilter((ExternalFilterRequest)ArgumentMatchers.eq((Object)filterRequest));
    }

    @Test
    public void testFunctionCallWithoutDestination() {
        ExternalComponentMessage message = this.functionCallMessage();
        this.noId(message);
        this.dispatcher.onMessage(message);
        ((ComponentFunctionLocator)Mockito.verify((Object)this.functionLocator, (VerificationMode)Mockito.times((int)0))).findFunctionByName((String)ArgumentMatchers.any());
    }

    @Test
    public void testFunctionCallWithoutRequest() {
        ExternalComponentMessage message = this.functionCallMessage();
        ExternalComponentMessage noRequestMessage = (ExternalComponentMessage)Mockito.mock(ExternalComponentMessage.class);
        Mockito.when((Object)this.messageHelper.newFunctionRequestNotFound()).thenReturn((Object)noRequestMessage);
        this.withId(message, Optional.of(DEST1));
        this.dispatcher.onMessage(message);
        ((ComponentFunctionLocator)Mockito.verify((Object)this.functionLocator, (VerificationMode)Mockito.times((int)0))).findFunctionByName((String)ArgumentMatchers.any());
        ((ExternalComponentMessageHelper)Mockito.verify((Object)this.messageHelper)).functionCallRequest((ExternalComponentMessage)ArgumentMatchers.eq((Object)message));
        ((ExternalComponentListener)Mockito.verify((Object)this.listener)).sendMessage(noRequestMessage);
    }

    @Test
    public void testFunctionCallFunctionNotFound() {
        FunctionCallRequest callRequest = (FunctionCallRequest)Mockito.mock(FunctionCallRequest.class);
        Optional<FunctionCallRequest> callRequestOp = Optional.of(callRequest);
        ExternalComponentMessage message = this.functionCallMessage(callRequestOp);
        ExternalComponentMessage functionNotFoundMessage = (ExternalComponentMessage)Mockito.mock(ExternalComponentMessage.class);
        String functionName = "f1";
        Mockito.when((Object)callRequest.getFunctionName()).thenReturn((Object)functionName);
        Mockito.when((Object)this.messageHelper.newFunctionNotFound((FunctionCallRequest)ArgumentMatchers.eq((Object)callRequest))).thenReturn((Object)functionNotFoundMessage);
        Mockito.when((Object)this.functionLocator.findFunctionByName((String)ArgumentMatchers.eq((Object)functionName))).thenReturn(Optional.empty());
        this.withId(message, Optional.of(DEST1));
        this.dispatcher.onMessage(message);
        ((ExternalComponentMessageHelper)Mockito.verify((Object)this.messageHelper)).functionCallRequest((ExternalComponentMessage)ArgumentMatchers.eq((Object)message));
        ((ComponentFunctionLocator)Mockito.verify((Object)this.functionLocator)).findFunctionByName((String)ArgumentMatchers.eq((Object)functionName));
        ((ExternalComponentListener)Mockito.verify((Object)this.listener)).sendMessage(functionNotFoundMessage);
    }

    @Test
    public void testFunctionCallError() {
        ExternalComponentFunction function = (ExternalComponentFunction)Mockito.mock(ExternalComponentFunction.class);
        FunctionCallRequest callRequest = (FunctionCallRequest)Mockito.mock(FunctionCallRequest.class);
        Optional<FunctionCallRequest> callRequestOp = Optional.of(callRequest);
        ExternalComponentMessage message = this.functionCallMessage(callRequestOp);
        ExternalComponentMessage functionErrorMessage = (ExternalComponentMessage)Mockito.mock(ExternalComponentMessage.class);
        String functionName = "f1";
        String functionError = "error";
        ((ExternalComponentFunction)Mockito.doThrow((Throwable[])new Throwable[]{new RuntimeException(functionError)}).when((Object)function)).exec((Map)ArgumentMatchers.any(), (Consumer)ArgumentMatchers.any(), (Consumer)ArgumentMatchers.any());
        Mockito.when((Object)callRequest.getFunctionName()).thenReturn((Object)functionName);
        Mockito.when((Object)this.messageHelper.newFunctionError((FunctionCallRequest)ArgumentMatchers.eq((Object)callRequest), (String)ArgumentMatchers.eq((Object)functionError))).thenReturn((Object)functionErrorMessage);
        Mockito.when((Object)this.functionLocator.findFunctionByName((String)ArgumentMatchers.eq((Object)functionName))).thenReturn(Optional.of(function));
        this.withId(message, Optional.of(DEST1));
        this.dispatcher.onMessage(message);
        ((ExternalComponentMessageHelper)Mockito.verify((Object)this.messageHelper)).functionCallRequest((ExternalComponentMessage)ArgumentMatchers.eq((Object)message));
        ((ComponentFunctionLocator)Mockito.verify((Object)this.functionLocator)).findFunctionByName((String)ArgumentMatchers.eq((Object)functionName));
        ((ExternalComponentFunction)Mockito.verify((Object)function)).exec((Map)ArgumentMatchers.any(), (Consumer)ArgumentMatchers.any(), (Consumer)ArgumentMatchers.any());
        ((ExternalComponentListener)Mockito.verify((Object)this.listener)).sendMessage(functionErrorMessage);
    }

    @Test
    public void testFunctionCallSuccess() {
        ExternalComponentFunction function = (ExternalComponentFunction)Mockito.mock(ExternalComponentFunction.class);
        FunctionCallRequest callRequest = (FunctionCallRequest)Mockito.mock(FunctionCallRequest.class);
        Optional<FunctionCallRequest> callRequestOp = Optional.of(callRequest);
        ExternalComponentMessage message = this.functionCallMessage(callRequestOp);
        ExternalComponentMessage functionSuccessMessage = (ExternalComponentMessage)Mockito.mock(ExternalComponentMessage.class);
        String functionName = "f1";
        String result = "success";
        Mockito.when((Object)callRequest.getFunctionName()).thenReturn((Object)functionName);
        Mockito.when((Object)this.messageHelper.newFunctionSuccess((FunctionCallRequest)ArgumentMatchers.eq((Object)callRequest), ArgumentMatchers.eq((Object)result))).thenReturn((Object)functionSuccessMessage);
        Mockito.when((Object)this.functionLocator.findFunctionByName((String)ArgumentMatchers.eq((Object)functionName))).thenReturn(Optional.of(function));
        this.withId(message, Optional.of(DEST1));
        this.dispatcher.onMessage(message);
        ((ExternalComponentMessageHelper)Mockito.verify((Object)this.messageHelper)).functionCallRequest((ExternalComponentMessage)ArgumentMatchers.eq((Object)message));
        ((ComponentFunctionLocator)Mockito.verify((Object)this.functionLocator)).findFunctionByName((String)ArgumentMatchers.eq((Object)functionName));
        ((ExternalComponentFunction)Mockito.verify((Object)function)).exec((Map)ArgumentMatchers.any(), (Consumer)this.functionExecutionCaptor.capture(), (Consumer)ArgumentMatchers.any());
        ((Consumer)this.functionExecutionCaptor.getValue()).accept(result);
        ((ExternalComponentMessageHelper)Mockito.verify((Object)this.messageHelper)).newFunctionSuccess((FunctionCallRequest)ArgumentMatchers.eq((Object)callRequest), ArgumentMatchers.eq((Object)result));
        ((ExternalComponentListener)Mockito.verify((Object)this.listener)).sendMessage((ExternalComponentMessage)ArgumentMatchers.eq((Object)functionSuccessMessage));
    }

    @Test
    public void testFixConfigurationWithoutMessage() {
        ExternalComponentMessage configurationIssueMsg = (ExternalComponentMessage)Mockito.mock(ExternalComponentMessage.class);
        this.withId(configurationIssueMsg, Optional.of(DEST1));
        Mockito.when((Object)this.messageHelper.messageType((ExternalComponentMessage)ArgumentMatchers.eq((Object)configurationIssueMsg))).thenReturn((Object)ExternalComponentMessageType.FIX_CONFIGURATION);
        Mockito.when((Object)this.messageHelper.getConfigurationIssue((ExternalComponentMessage)ArgumentMatchers.eq((Object)configurationIssueMsg))).thenReturn(Optional.empty());
        this.dispatcher.onMessage(configurationIssueMsg);
        ((ExternalComponentListener)Mockito.verify((Object)this.listener)).onConfigurationIssue(CommonConstants.INSTANCE.componentConfigDefaultMessage());
    }

    @Test
    public void testFixConfigurationWithMessage() {
        ExternalComponentMessage configurationIssueMsg = (ExternalComponentMessage)Mockito.mock(ExternalComponentMessage.class);
        String configurationMessage = "config error";
        this.withId(configurationIssueMsg, Optional.of(DEST1));
        Mockito.when((Object)this.messageHelper.messageType((ExternalComponentMessage)ArgumentMatchers.eq((Object)configurationIssueMsg))).thenReturn((Object)ExternalComponentMessageType.FIX_CONFIGURATION);
        Mockito.when((Object)this.messageHelper.getConfigurationIssue((ExternalComponentMessage)ArgumentMatchers.eq((Object)configurationIssueMsg))).thenReturn(Optional.of(configurationMessage));
        this.dispatcher.onMessage(configurationIssueMsg);
        ((ExternalComponentListener)Mockito.verify((Object)this.listener)).onConfigurationIssue(configurationMessage);
    }

    @Test
    public void testOkConfigurationWithMessage() {
        ExternalComponentMessage configurationOkMsg = (ExternalComponentMessage)Mockito.mock(ExternalComponentMessage.class);
        this.withId(configurationOkMsg, Optional.of(DEST1));
        Mockito.when((Object)this.messageHelper.messageType((ExternalComponentMessage)ArgumentMatchers.eq((Object)configurationOkMsg))).thenReturn((Object)ExternalComponentMessageType.CONFIGURATION_OK);
        this.dispatcher.onMessage(configurationOkMsg);
        ((ExternalComponentListener)Mockito.verify((Object)this.listener)).configurationOk();
    }

    private void noId(ExternalComponentMessage message) {
        this.withId(message, Optional.empty());
    }

    private ExternalComponentMessage filterMessage() {
        return this.filterMessage(Optional.empty());
    }

    private ExternalComponentMessage functionCallMessage() {
        return this.functionCallMessage(Optional.empty());
    }

    private void withId(ExternalComponentMessage message, Optional<String> id) {
        Mockito.when((Object)this.messageHelper.getComponentId((ExternalComponentMessage)ArgumentMatchers.eq((Object)message))).thenReturn(id);
    }

    private ExternalComponentMessage filterMessage(Optional<ExternalFilterRequest> filterRequestOp) {
        ExternalComponentMessage message = (ExternalComponentMessage)Mockito.mock(ExternalComponentMessage.class);
        Mockito.when((Object)this.messageHelper.messageType((ExternalComponentMessage)ArgumentMatchers.eq((Object)message))).thenReturn((Object)ExternalComponentMessageType.FILTER);
        Mockito.when((Object)this.messageHelper.filterRequest((ExternalComponentMessage)ArgumentMatchers.eq((Object)message))).thenReturn(filterRequestOp);
        return message;
    }

    private ExternalComponentMessage functionCallMessage(Optional<FunctionCallRequest> callRequestOp) {
        ExternalComponentMessage message = (ExternalComponentMessage)Mockito.mock(ExternalComponentMessage.class);
        Mockito.when((Object)this.messageHelper.messageType((ExternalComponentMessage)ArgumentMatchers.eq((Object)message))).thenReturn((Object)ExternalComponentMessageType.FUNCTION_CALL);
        Mockito.when((Object)this.messageHelper.functionCallRequest((ExternalComponentMessage)ArgumentMatchers.eq((Object)message))).thenReturn(callRequestOp);
        return message;
    }
}

