/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.displayer.client.widgets.sourcecode;

import java.util.HashMap;
import org.dashbuilder.displayer.client.widgets.sourcecode.HtmlValidator;
import org.dashbuilder.displayer.client.widgets.sourcecode.JsValidator;
import org.dashbuilder.displayer.client.widgets.sourcecode.SourceCodeEditor;
import org.dashbuilder.displayer.client.widgets.sourcecode.SourceCodeType;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.uberfire.mvp.Command;

@RunWith(value=MockitoJUnitRunner.class)
public class SourceCodeEditorTest {
    @Mock
    SourceCodeEditor.View view;
    @Mock
    Command onChange;
    @Mock
    HtmlValidator htmlValidator;
    @Mock
    JsValidator jsValidator;
    SourceCodeEditor presenter;

    @Before
    public void init() {
        this.presenter = new SourceCodeEditor(this.view, this.htmlValidator, this.jsValidator);
        this.presenter.init(SourceCodeType.HTML, "Hi", new HashMap(), this.onChange);
    }

    @Test
    public void testInitialization() {
        ((SourceCodeEditor.View)Mockito.verify((Object)this.view)).edit(SourceCodeType.HTML, "Hi");
    }

    @Test
    public void testEmpty() {
        Mockito.reset((Object[])new HtmlValidator[]{this.htmlValidator});
        this.presenter.init(SourceCodeType.HTML, null, new HashMap(), this.onChange);
        ((HtmlValidator)Mockito.verify((Object)this.htmlValidator, (VerificationMode)Mockito.never())).validate((String)Mockito.any());
        Mockito.reset((Object[])new HtmlValidator[]{this.htmlValidator});
        this.presenter.init(SourceCodeType.HTML, "", new HashMap(), this.onChange);
        ((HtmlValidator)Mockito.verify((Object)this.htmlValidator, (VerificationMode)Mockito.never())).validate((String)Mockito.any());
        Mockito.reset((Object[])new JsValidator[]{this.jsValidator});
        this.presenter.init(SourceCodeType.JAVASCRIPT, null, new HashMap(), this.onChange);
        ((JsValidator)Mockito.verify((Object)this.jsValidator, (VerificationMode)Mockito.never())).validate((String)Mockito.any(), Mockito.anyCollection());
        Mockito.reset((Object[])new JsValidator[]{this.jsValidator});
        this.presenter.init(SourceCodeType.JAVASCRIPT, "", new HashMap(), this.onChange);
        ((JsValidator)Mockito.verify((Object)this.jsValidator, (VerificationMode)Mockito.never())).validate((String)Mockito.any(), Mockito.anyCollection());
    }

    @Test
    public void testOnChange() {
        this.presenter.onSourceCodeChanged("howdy?");
        Assert.assertEquals((Object)this.presenter.getCode(), (Object)"howdy?");
        Assert.assertEquals((Object)this.presenter.hasErrors(), (Object)false);
        ((HtmlValidator)Mockito.verify((Object)this.htmlValidator)).validate("howdy?");
        ((Command)Mockito.verify((Object)this.onChange)).execute();
        ((SourceCodeEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).error(Mockito.anyString());
    }

    @Test
    public void testError() {
        Mockito.when((Object)this.htmlValidator.validate("howdy?")).thenReturn((Object)"Error");
        boolean ok = this.presenter.onSourceCodeChanged("howdy?");
        Assert.assertFalse((boolean)ok);
        Assert.assertEquals((Object)this.presenter.getCode(), (Object)"Hi");
        Assert.assertEquals((Object)this.presenter.hasErrors(), (Object)true);
        ((HtmlValidator)Mockito.verify((Object)this.htmlValidator)).validate("howdy?");
        ((Command)Mockito.verify((Object)this.onChange, (VerificationMode)Mockito.never())).execute();
        ((SourceCodeEditor.View)Mockito.verify((Object)this.view)).error("Error");
    }
}

