/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.displayer.client.widgets.group;

import javax.enterprise.event.Event;
import org.dashbuilder.dataset.group.ColumnGroup;
import org.dashbuilder.dataset.group.DateIntervalType;
import org.dashbuilder.dataset.group.GroupStrategy;
import org.dashbuilder.displayer.client.events.DataSetGroupDateChanged;
import org.dashbuilder.displayer.client.widgets.group.DataSetGroupDateEditor;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class DataSetGroupDateEditorTest {
    @Mock
    DataSetGroupDateEditor.View view;
    @Mock
    Event<DataSetGroupDateChanged> changeEvent;
    DataSetGroupDateEditor presenter;

    @Before
    public void init() {
        this.presenter = new DataSetGroupDateEditor(this.view, this.changeEvent);
    }

    @Test
    public void testFixedModeInit() {
        this.presenter.init(new ColumnGroup("col", "col", GroupStrategy.FIXED, 15, DateIntervalType.HOUR.toString()));
        ((DataSetGroupDateEditor.View)Mockito.verify((Object)this.view)).setFixedModeValue(true);
        ((DataSetGroupDateEditor.View)Mockito.verify((Object)this.view)).clearIntervalTypeSelector();
        ((DataSetGroupDateEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)DateIntervalType.FIXED_INTERVALS_SUPPORTED.size()))).addIntervalTypeItem((DateIntervalType)ArgumentMatchers.any(DateIntervalType.class));
        ((DataSetGroupDateEditor.View)Mockito.verify((Object)this.view)).setSelectedIntervalTypeIndex(Mockito.anyInt());
        ((DataSetGroupDateEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).setMaxIntervalsVisibility(true);
        ((DataSetGroupDateEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).setFirstDayVisibility(true);
        ((DataSetGroupDateEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).setFirstMonthVisibility(true);
    }

    @Test
    public void testDynamicModeInit() {
        ColumnGroup columnGroup = new ColumnGroup("col", "col", GroupStrategy.DYNAMIC, 15, DateIntervalType.HOUR.toString());
        this.presenter.init(columnGroup);
        ((DataSetGroupDateEditor.View)Mockito.verify((Object)this.view)).setFixedModeValue(false);
        ((DataSetGroupDateEditor.View)Mockito.verify((Object)this.view)).clearIntervalTypeSelector();
        ((DataSetGroupDateEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.times((int)DateIntervalType.values().length))).addIntervalTypeItem((DateIntervalType)ArgumentMatchers.any(DateIntervalType.class));
        ((DataSetGroupDateEditor.View)Mockito.verify((Object)this.view)).setSelectedIntervalTypeIndex(Mockito.anyInt());
        ((DataSetGroupDateEditor.View)Mockito.verify((Object)this.view)).setMaxIntervalsVisibility(true);
        ((DataSetGroupDateEditor.View)Mockito.verify((Object)this.view)).setMaxIntervalsValue("15");
        ((DataSetGroupDateEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).setFirstDayVisibility(true);
        ((DataSetGroupDateEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).setFirstMonthVisibility(true);
    }

    @Test
    public void testFirstMonthDayVisibility() {
        this.presenter.init(new ColumnGroup("col", "col", GroupStrategy.FIXED, 15, DateIntervalType.QUARTER.toString()));
        ((DataSetGroupDateEditor.View)Mockito.verify((Object)this.view)).setFirstMonthVisibility(false);
        ((DataSetGroupDateEditor.View)Mockito.verify((Object)this.view)).setFirstDayVisibility(false);
        ((DataSetGroupDateEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).setFirstDayVisibility(true);
        ((DataSetGroupDateEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).setFirstMonthVisibility(true);
        Mockito.reset((Object[])new DataSetGroupDateEditor.View[]{this.view});
        this.presenter.init(new ColumnGroup("col", "col", GroupStrategy.FIXED, 15, DateIntervalType.MONTH.toString()));
        ((DataSetGroupDateEditor.View)Mockito.verify((Object)this.view)).setFirstMonthVisibility(true);
        ((DataSetGroupDateEditor.View)Mockito.verify((Object)this.view)).setFirstDayVisibility(false);
        ((DataSetGroupDateEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).setFirstDayVisibility(true);
        Mockito.reset((Object[])new DataSetGroupDateEditor.View[]{this.view});
        this.presenter.init(new ColumnGroup("col", "col", GroupStrategy.FIXED, 15, DateIntervalType.DAY_OF_WEEK.toString()));
        ((DataSetGroupDateEditor.View)Mockito.verify((Object)this.view)).setFirstDayVisibility(true);
        ((DataSetGroupDateEditor.View)Mockito.verify((Object)this.view)).setFirstMonthVisibility(false);
        ((DataSetGroupDateEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).setFirstMonthVisibility(true);
        Mockito.reset((Object[])new DataSetGroupDateEditor.View[]{this.view});
        this.presenter.init(new ColumnGroup("col", "col", GroupStrategy.FIXED, 15, DateIntervalType.HOUR.toString()));
        ((DataSetGroupDateEditor.View)Mockito.verify((Object)this.view)).setFirstMonthVisibility(false);
        ((DataSetGroupDateEditor.View)Mockito.verify((Object)this.view)).setFirstDayVisibility(false);
        ((DataSetGroupDateEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).setFirstDayVisibility(true);
        ((DataSetGroupDateEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).setFirstMonthVisibility(true);
        Mockito.reset((Object[])new DataSetGroupDateEditor.View[]{this.view});
        this.presenter.init(new ColumnGroup("col", "col", GroupStrategy.FIXED, 15, DateIntervalType.MINUTE.toString()));
        ((DataSetGroupDateEditor.View)Mockito.verify((Object)this.view)).setFirstMonthVisibility(false);
        ((DataSetGroupDateEditor.View)Mockito.verify((Object)this.view)).setFirstDayVisibility(false);
        ((DataSetGroupDateEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).setFirstDayVisibility(true);
        ((DataSetGroupDateEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).setFirstMonthVisibility(true);
        Mockito.reset((Object[])new DataSetGroupDateEditor.View[]{this.view});
        this.presenter.init(new ColumnGroup("col", "col", GroupStrategy.FIXED, 15, DateIntervalType.SECOND.toString()));
        ((DataSetGroupDateEditor.View)Mockito.verify((Object)this.view)).setFirstMonthVisibility(false);
        ((DataSetGroupDateEditor.View)Mockito.verify((Object)this.view)).setFirstDayVisibility(false);
        ((DataSetGroupDateEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).setFirstDayVisibility(true);
        ((DataSetGroupDateEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).setFirstMonthVisibility(true);
    }

    @Test
    public void testEnableFixedMode() {
        this.presenter.init(new ColumnGroup("col", "col", GroupStrategy.DYNAMIC, 15, DateIntervalType.CENTURY.toString()));
        Mockito.reset((Object[])new DataSetGroupDateEditor.View[]{this.view});
        Mockito.when((Object)this.view.getFixedModeValue()).thenReturn((Object)true);
        this.presenter.onFixedStrategyChanged();
        ((Event)Mockito.verify(this.changeEvent)).fire((Object)((DataSetGroupDateChanged)ArgumentMatchers.any(DataSetGroupDateChanged.class)));
        ColumnGroup result = this.presenter.getColumnGroup();
        Assert.assertEquals((Object)result.getStrategy(), (Object)GroupStrategy.FIXED);
        ((DataSetGroupDateEditor.View)Mockito.verify((Object)this.view)).setFirstMonthVisibility(true);
        ((DataSetGroupDateEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).setMaxIntervalsVisibility(true);
        ((DataSetGroupDateEditor.View)Mockito.verify((Object)this.view, (VerificationMode)Mockito.never())).setFirstDayVisibility(true);
    }

    @Test
    public void testDisableFixedMode() {
        Mockito.when((Object)this.view.getFixedModeValue()).thenReturn((Object)false);
        this.presenter.init(new ColumnGroup("col", "col", GroupStrategy.FIXED, 15, DateIntervalType.HOUR.toString()));
        this.presenter.onFixedStrategyChanged();
        ((Event)Mockito.verify(this.changeEvent)).fire((Object)((DataSetGroupDateChanged)ArgumentMatchers.any(DataSetGroupDateChanged.class)));
        ColumnGroup result = this.presenter.getColumnGroup();
        Assert.assertEquals((Object)result.getStrategy(), (Object)GroupStrategy.DYNAMIC);
        ((DataSetGroupDateEditor.View)Mockito.verify((Object)this.view)).setMaxIntervalsVisibility(true);
        ((DataSetGroupDateEditor.View)Mockito.verify((Object)this.view)).setMaxIntervalsValue("15");
    }
}

