/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.client.editor;

import com.github.gwtbootstrap.client.ui.Modal;
import com.google.gwt.user.client.ui.IsWidget;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import org.dashbuilder.client.editor.resources.i18n.Constants;
import org.dashbuilder.displayer.DisplayerSettings;
import org.dashbuilder.displayer.client.json.DisplayerSettingsJSONMarshaller;
import org.dashbuilder.displayer.client.widgets.DisplayerEditor;
import org.dashbuilder.displayer.client.widgets.DisplayerView;
import org.uberfire.ext.plugin.client.perspective.editor.api.ExternalPerspectiveEditorComponent;

@Dependent
public class DisplayerPerspectiveEditorComponent
implements ExternalPerspectiveEditorComponent {
    private DisplayerEditor editor = new DisplayerEditor();
    DisplayerSettingsJSONMarshaller jsonMarshaller = new DisplayerSettingsJSONMarshaller();

    @PostConstruct
    public void setup() {
        this.editor.init(null, null);
    }

    public void setup(String placeName, Map<String, String> parameters) {
        String json = parameters.get("json");
        DisplayerSettings settings = this.jsonMarshaller.fromJsonString(json);
        this.editor.init(settings, null);
    }

    public String getPlaceName() {
        return "DisplayerScreen";
    }

    public Map<String, String> getParametersMap() {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("json", this.jsonMarshaller.toJsonString(this.editor.getDisplayerSettings()));
        return params;
    }

    public IsWidget getConfig() {
        return this.editor;
    }

    public IsWidget getPreview(Map<String, String> parameters) {
        String json = parameters.get("json");
        DisplayerSettings settings = this.jsonMarshaller.fromJsonString(json);
        return new DisplayerView(settings).draw();
    }

    public void modalSettings(Modal popup) {
        popup.setWidth(900);
        popup.setMaxHeigth("500px");
        popup.setTitle(Constants.INSTANCE.displayer_perspective_editor_title());
    }
}

