/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.client.editor;

import com.github.gwtbootstrap.client.ui.Modal;
import com.github.gwtbootstrap.client.ui.TextBox;
import com.github.gwtbootstrap.client.ui.constants.AlternateSize;
import com.google.gwt.core.client.GWT;
import com.google.gwt.event.logical.shared.AttachEvent;
import com.google.gwt.user.client.ui.IsWidget;
import java.util.Map;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.dashbuilder.displayer.DisplayerSettings;
import org.dashbuilder.displayer.client.Displayer;
import org.dashbuilder.displayer.client.PerspectiveCoordinator;
import org.dashbuilder.displayer.client.json.DisplayerSettingsJSONMarshaller;
import org.dashbuilder.displayer.client.widgets.DisplayerEditor;
import org.dashbuilder.displayer.client.widgets.DisplayerEditorPopup;
import org.dashbuilder.displayer.client.widgets.DisplayerView;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.ext.layout.editor.client.components.HasModalConfiguration;
import org.uberfire.ext.layout.editor.client.components.ModalConfigurationContext;
import org.uberfire.ext.layout.editor.client.components.RenderingContext;
import org.uberfire.ext.plugin.client.perspective.editor.api.PerspectiveEditorDragComponent;

@Dependent
public class DisplayerDragComponent
implements PerspectiveEditorDragComponent,
HasModalConfiguration {
    @Inject
    DisplayerEditorPopup editor;
    @Inject
    DisplayerSettingsJSONMarshaller marshaller;
    @Inject
    PlaceManager placeManager;
    @Inject
    PerspectiveCoordinator perspectiveCoordinator;

    public IsWidget getDragWidget() {
        TextBox textBox = (TextBox)GWT.create(TextBox.class);
        textBox.setPlaceholder("Displayer Component");
        textBox.setReadOnly(true);
        textBox.setAlternateSize(AlternateSize.MEDIUM);
        return textBox;
    }

    public IsWidget getPreviewWidget(RenderingContext ctx) {
        return this.getShowWidget(ctx);
    }

    public IsWidget getShowWidget(final RenderingContext ctx) {
        Map properties = ctx.getComponent().getProperties();
        String json = (String)properties.get("json");
        if (json == null) {
            return null;
        }
        final DisplayerSettings settings = this.marshaller.fromJsonString(json);
        final DisplayerView displayerView = new DisplayerView(settings);
        displayerView.addAttachHandler(new AttachEvent.Handler(){

            public void onAttachOrDetach(AttachEvent attachEvent) {
                if (attachEvent.isAttached()) {
                    int containerWidth = ctx.getContainer().getOffsetWidth() - 40;
                    DisplayerDragComponent.this.adjustSize(settings, containerWidth);
                    Displayer displayer = displayerView.draw();
                    DisplayerDragComponent.this.perspectiveCoordinator.addDisplayer(displayer);
                }
            }
        });
        return displayerView;
    }

    public Modal getConfigurationModal(final ModalConfigurationContext ctx) {
        Map properties = ctx.getComponentProperties();
        String json = (String)properties.get("json");
        DisplayerSettings settings = json != null ? this.marshaller.fromJsonString(json) : null;
        this.editor.init(settings, new DisplayerEditor.Listener(){

            public void onClose(DisplayerEditor editor) {
                ctx.configurationCancelled();
            }

            public void onSave(DisplayerEditor editor) {
                String json = DisplayerDragComponent.this.marshaller.toJsonString(editor.getDisplayerSettings());
                ctx.setComponentProperty("json", json);
                ctx.configurationFinished();
            }
        });
        return this.editor;
    }

    protected void adjustSize(DisplayerSettings settings, int containerWidth) {
        int displayerWidth = settings.getChartWidth();
        int tableWidth = settings.getTableWidth();
        if (containerWidth > 0 && displayerWidth > containerWidth) {
            int ratio = containerWidth * 100 / displayerWidth;
            settings.setChartWidth(containerWidth);
            settings.setChartHeight(settings.getChartHeight() * ratio / 100);
        }
        if (tableWidth == 0 || tableWidth > containerWidth) {
            settings.setTableWidth(containerWidth - 20);
        }
    }
}

