/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.client.editor;

import com.google.gwt.user.client.ui.IsWidget;
import java.lang.annotation.Annotation;
import java.util.Map;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.dashbuilder.client.editor.resources.i18n.Constants;
import org.dashbuilder.displayer.DisplayerSettings;
import org.dashbuilder.displayer.DisplayerSubType;
import org.dashbuilder.displayer.DisplayerType;
import org.dashbuilder.displayer.client.Displayer;
import org.dashbuilder.displayer.client.PerspectiveCoordinator;
import org.dashbuilder.displayer.client.widgets.DisplayerEditorPopup;
import org.dashbuilder.displayer.client.widgets.DisplayerViewer;
import org.dashbuilder.displayer.json.DisplayerSettingsJSONMarshaller;
import org.gwtbootstrap3.client.ui.Modal;
import org.jboss.errai.ioc.client.container.SyncBeanManager;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.ext.layout.editor.client.api.HasModalConfiguration;
import org.uberfire.ext.layout.editor.client.api.LayoutDragComponent;
import org.uberfire.ext.layout.editor.client.api.ModalConfigurationContext;
import org.uberfire.ext.layout.editor.client.api.RenderingContext;
import org.uberfire.mvp.Command;

@Dependent
public class DisplayerDragComponent
implements LayoutDragComponent,
HasModalConfiguration {
    SyncBeanManager beanManager;
    DisplayerViewer viewer;
    PlaceManager placeManager;
    PerspectiveCoordinator perspectiveCoordinator;
    DisplayerSettingsJSONMarshaller marshaller;

    @Inject
    public DisplayerDragComponent(SyncBeanManager beanManager, DisplayerViewer viewer, PlaceManager placeManager, PerspectiveCoordinator perspectiveCoordinator) {
        this.beanManager = beanManager;
        this.viewer = viewer;
        this.placeManager = placeManager;
        this.perspectiveCoordinator = perspectiveCoordinator;
        this.marshaller = DisplayerSettingsJSONMarshaller.get();
    }

    public DisplayerType getDisplayerType() {
        return null;
    }

    public DisplayerSubType getDisplayerSubType() {
        return null;
    }

    public String getDragComponentTitle() {
        return Constants.INSTANCE.DisplayerComponent();
    }

    public IsWidget getPreviewWidget(RenderingContext ctx) {
        return this.getShowWidget(ctx);
    }

    public IsWidget getShowWidget(RenderingContext ctx) {
        Map properties = ctx.getComponent().getProperties();
        String json = (String)properties.get("json");
        if (json == null) {
            return null;
        }
        DisplayerSettings settings = this.marshaller.fromJsonString(json);
        this.viewer.init(settings);
        this.viewer.addAttachHandler(attachEvent -> {
            if (attachEvent.isAttached()) {
                int offsetWidth = ctx.getContainer().getOffsetWidth();
                int containerWidth = offsetWidth > 40 ? offsetWidth - 40 : 0;
                this.adjustSize(settings, containerWidth);
                Displayer displayer = this.viewer.draw();
                this.perspectiveCoordinator.addDisplayer(displayer);
            }
        });
        int containerWidth = ctx.getContainer().getOffsetWidth() - 40;
        this.adjustSize(settings, containerWidth);
        Displayer displayer = this.viewer.draw();
        this.perspectiveCoordinator.addDisplayer(displayer);
        return this.viewer;
    }

    public Modal getConfigurationModal(ModalConfigurationContext ctx) {
        Map properties = ctx.getComponentProperties();
        String json = (String)properties.get("json");
        DisplayerSettings settings = json != null ? this.marshaller.fromJsonString(json) : null;
        DisplayerEditorPopup editor = (DisplayerEditorPopup)this.beanManager.lookupBean(DisplayerEditorPopup.class, new Annotation[0]).newInstance();
        if (settings == null) {
            if (this.getDisplayerType() != null) {
                editor.setDisplayerType(this.getDisplayerType());
            }
            if (this.getDisplayerSubType() != null) {
                editor.setDisplayerSubType(this.getDisplayerSubType());
            }
        }
        editor.init(settings);
        editor.setOnSaveCommand(this.getSaveCommand(editor, ctx));
        editor.setOnCloseCommand(this.getCloseCommand(editor, ctx));
        return editor;
    }

    protected Command getSaveCommand(final DisplayerEditorPopup editor, final ModalConfigurationContext ctx) {
        return new Command(){

            public void execute() {
                String json = DisplayerDragComponent.this.marshaller.toJsonString(editor.getDisplayerSettings());
                ctx.setComponentProperty("json", json);
                ctx.configurationFinished();
                DisplayerDragComponent.this.beanManager.destroyBean((Object)editor);
            }
        };
    }

    protected Command getCloseCommand(final DisplayerEditorPopup editor, final ModalConfigurationContext ctx) {
        return new Command(){

            public void execute() {
                ctx.configurationCancelled();
                DisplayerDragComponent.this.beanManager.destroyBean((Object)editor);
            }
        };
    }

    protected void adjustSize(DisplayerSettings settings, int containerWidth) {
        int displayerWidth = settings.getChartWidth();
        int tableWidth = settings.getTableWidth();
        if (containerWidth > 0 && displayerWidth > containerWidth) {
            int ratio = containerWidth * 100 / displayerWidth;
            settings.setChartWidth(containerWidth);
            settings.setChartHeight(settings.getChartHeight() * ratio / 100);
        }
        if (tableWidth == 0 || tableWidth > containerWidth) {
            settings.setTableWidth(containerWidth > 20 ? containerWidth - 20 : 0);
        }
    }
}

