/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.client.editor.external;

import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.dashbuilder.client.editor.external.ExternalComponentDragDef;
import org.dashbuilder.client.editor.external.ExternalDisplayerDragComponent;
import org.dashbuilder.client.editor.external.ExternalDragComponent;
import org.dashbuilder.client.editor.resources.i18n.Constants;
import org.dashbuilder.external.model.ExternalComponent;
import org.dashbuilder.external.service.ExternalComponentService;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.ioc.client.api.AfterInitialization;
import org.jboss.errai.ioc.client.api.EntryPoint;
import org.jboss.errai.ioc.client.container.SyncBeanManager;
import org.uberfire.ext.layout.editor.client.api.LayoutDragComponent;
import org.uberfire.ext.layout.editor.client.api.LayoutDragComponentGroup;
import org.uberfire.ext.plugin.client.perspective.editor.api.PerspectiveEditorComponentGroupProvider;

@EntryPoint
@ApplicationScoped
public class ExternalComponentGroupProvider
implements PerspectiveEditorComponentGroupProvider {
    private final Constants i18n = Constants.INSTANCE;
    @Inject
    Caller<ExternalComponentService> externalComponentService;
    @Inject
    SyncBeanManager beanManager;
    List<ExternalComponent> loadedComponents = Collections.emptyList();

    @AfterInitialization
    public void loadComponents() {
        ((ExternalComponentService)this.externalComponentService.call(components -> {
            this.loadedComponents = components;
        })).listComponents();
    }

    public String getName() {
        return this.i18n.externalComponents();
    }

    public LayoutDragComponentGroup getComponentGroup() {
        LayoutDragComponentGroup group = new LayoutDragComponentGroup(this.getName());
        this.loadedComponents.forEach(comp -> {
            ExternalComponentDragDef dragComp = this.produceDragComponent((ExternalComponent)comp);
            group.addLayoutDragComponent(comp.getId(), (LayoutDragComponent)dragComp);
        });
        return group;
    }

    ExternalComponentDragDef produceDragComponent(ExternalComponent comp) {
        ExternalComponentDragDef dragComp = comp.isNoData() ? (ExternalComponentDragDef)this.beanManager.lookupBean(ExternalDragComponent.class, new Annotation[0]).getInstance() : (ExternalComponentDragDef)this.beanManager.lookupBean(ExternalDisplayerDragComponent.class, new Annotation[0]).getInstance();
        dragComp.setDragInfo(comp.getName(), comp.getIcon());
        dragComp.setComponentId(comp.getId());
        return dragComp;
    }
}

