/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.client.editor.external;

import com.google.gwt.user.client.ui.IsWidget;
import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.dashbuilder.client.editor.external.ExternalComponentDragDef;
import org.dashbuilder.displayer.client.widgets.ExternalComponentEditorPopUp;
import org.dashbuilder.displayer.client.widgets.ExternalComponentPresenter;
import org.dashbuilder.displayer.external.ExternalComponentMessage;
import org.dashbuilder.displayer.external.ExternalComponentMessageHelper;
import org.gwtbootstrap3.client.ui.Label;
import org.gwtbootstrap3.client.ui.Modal;
import org.jboss.errai.ioc.client.container.SyncBeanManager;
import org.uberfire.ext.layout.editor.client.api.HasModalConfiguration;
import org.uberfire.ext.layout.editor.client.api.ModalConfigurationContext;
import org.uberfire.ext.layout.editor.client.api.RenderingContext;
import org.uberfire.mvp.Command;

@Dependent
public class ExternalDragComponent
implements ExternalComponentDragDef,
HasModalConfiguration {
    @Inject
    SyncBeanManager beanManager;
    @Inject
    ExternalComponentPresenter externalComponentPresenter;
    @Inject
    ExternalComponentMessageHelper messageHelper;
    private String componentId;
    private String componentName;
    private String componentIcon;

    public IsWidget getPreviewWidget(RenderingContext ctx) {
        return this.getShowWidget(ctx);
    }

    public IsWidget getShowWidget(RenderingContext ctx) {
        Map ltProps = ctx.getComponent().getProperties();
        String storedComponentId = (String)ltProps.get("componentId");
        String partition = (String)ltProps.get("componentPartition");
        if (storedComponentId == null) {
            return new Label("Component not found.");
        }
        if (partition != null) {
            this.externalComponentPresenter.withComponent(storedComponentId, partition);
        } else {
            this.externalComponentPresenter.withComponent(storedComponentId);
        }
        HashMap<String, String> componentProperties = new HashMap<String, String>(this.retrieveComponentProperties(storedComponentId, ltProps));
        ExternalComponentMessage message = this.messageHelper.newInitMessage(componentProperties);
        this.externalComponentPresenter.sendMessage(message);
        return this.externalComponentPresenter.getView();
    }

    @Override
    public String getComponentName() {
        return this.componentName;
    }

    @Override
    public String getComponentIcon() {
        return this.componentIcon;
    }

    @Override
    public String getComponentId() {
        return this.componentId;
    }

    @Override
    public void setComponentId(String componentId) {
        this.componentId = componentId;
    }

    @Override
    public void setDragInfo(String componentName, String componentIcon) {
        this.componentName = componentName;
        this.componentIcon = componentIcon;
    }

    public Modal getConfigurationModal(ModalConfigurationContext ctx) {
        String storedComponentId = ctx.getComponentProperty("componentId");
        ExternalComponentEditorPopUp editor = (ExternalComponentEditorPopUp)this.beanManager.lookupBean(ExternalComponentEditorPopUp.class, new Annotation[0]).newInstance();
        Map<String, String> existingProps = this.retrieveComponentProperties(storedComponentId, ctx.getComponentProperties());
        editor.init(storedComponentId, existingProps, this.getCloseCommand(editor, ctx), this.getSaveCommand(storedComponentId, editor, ctx));
        return editor;
    }

    protected Command getSaveCommand(String componentId, ExternalComponentEditorPopUp editor, ModalConfigurationContext ctx) {
        return () -> {
            editor.getProperties().forEach((k, v) -> {
                String key = this.appendComponentPrefix(componentId, (String)k);
                ctx.getComponentProperties().put(key, v);
            });
            ctx.configurationFinished();
            this.beanManager.destroyBean((Object)editor);
        };
    }

    protected Command getCloseCommand(ExternalComponentEditorPopUp editor, ModalConfigurationContext ctx) {
        return () -> {
            ctx.configurationCancelled();
            this.beanManager.destroyBean((Object)editor);
        };
    }

    private Map<String, String> retrieveComponentProperties(String componentId, Map<String, String> componentProperties) {
        String prefix = this.getComponentPrefix(componentId);
        return componentProperties.entrySet().stream().filter(e -> ((String)e.getKey()).startsWith(prefix)).collect(Collectors.toMap(e -> this.removeComponentPrefix(componentId, (String)e.getKey()), Map.Entry::getValue));
    }

    private String getComponentPrefix(String componentId) {
        return componentId + ".";
    }

    private String appendComponentPrefix(String componentId, String key) {
        return componentId + "." + key;
    }

    private String removeComponentPrefix(String componentId, String key) {
        return key.replaceFirst(componentId + ".", "");
    }
}

