/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.client.editor.external;

import java.lang.annotation.Annotation;
import java.util.List;
import java.util.stream.Collectors;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.dashbuilder.client.editor.external.ExternalComponentDragDef;
import org.dashbuilder.client.editor.external.ExternalDisplayerDragComponent;
import org.dashbuilder.client.editor.external.ExternalDragComponent;
import org.dashbuilder.client.editor.resources.i18n.Constants;
import org.dashbuilder.external.model.ExternalComponent;
import org.dashbuilder.external.service.ComponentService;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.ioc.client.container.SyncBeanManager;
import org.uberfire.ext.layout.editor.client.api.LayoutDragComponent;
import org.uberfire.ext.layout.editor.client.api.LayoutDragComponentGroup;
import org.uberfire.ext.layout.editor.client.api.LayoutDragComponentPalette;
import org.uberfire.ext.layout.editor.client.widgets.LayoutComponentPaletteGroupProvider;
import org.uberfire.ext.plugin.client.perspective.editor.events.PerspectiveEditorFocusEvent;

@ApplicationScoped
public class ComponentGroupProducer {
    private static final Constants i18n = Constants.INSTANCE;
    private SyncBeanManager beanManager;
    private LayoutDragComponentPalette layoutDragComponentPalette;
    private Caller<ComponentService> componentService;

    @Inject
    public ComponentGroupProducer(Caller<ComponentService> externalComponentService, SyncBeanManager beanManager, LayoutDragComponentPalette layoutDragComponentPalette) {
        this.componentService = externalComponentService;
        this.beanManager = beanManager;
        this.layoutDragComponentPalette = layoutDragComponentPalette;
    }

    public void onEditorFocus(@Observes PerspectiveEditorFocusEvent event) {
        this.loadComponents();
    }

    public void loadComponents() {
        ((ComponentService)this.componentService.call(components -> {
            this.addProvidedComponents(components.stream().filter(c -> c.isProvided()).collect(Collectors.toList()));
            this.addExternalComponents(components.stream().filter(c -> !c.isProvided()).collect(Collectors.toList()));
        })).listAllComponents();
    }

    public void addExternalComponents(List<ExternalComponent> components) {
        String groupId = i18n.externalComponentsGroupName();
        if (!components.isEmpty()) {
            this.checkGroup(groupId);
        }
        components.forEach(comp -> this.layoutDragComponentPalette.addDraggableComponent(groupId, comp.getId(), (LayoutDragComponent)this.produceDragComponent((ExternalComponent)comp)));
    }

    public void addProvidedComponents(List<ExternalComponent> components) {
        components.stream().forEach(component -> {
            String groupId = component.getCategory() != null ? component.getCategory() : i18n.internalComponentsGroupName();
            this.checkGroup(groupId);
            this.layoutDragComponentPalette.addDraggableComponent(groupId, component.getId(), (LayoutDragComponent)this.produceDragComponent((ExternalComponent)component));
        });
    }

    private void checkGroup(final String groupId) {
        if (!this.layoutDragComponentPalette.hasDraggableGroup(groupId)) {
            this.layoutDragComponentPalette.addDraggableGroup(new LayoutComponentPaletteGroupProvider(){

                public String getName() {
                    return groupId;
                }

                public LayoutDragComponentGroup getComponentGroup() {
                    return new LayoutDragComponentGroup(groupId);
                }
            });
        }
    }

    ExternalComponentDragDef produceDragComponent(ExternalComponent comp) {
        ExternalComponentDragDef dragComp = comp.isNoData() ? (ExternalComponentDragDef)this.beanManager.lookupBean(ExternalDragComponent.class, new Annotation[0]).getInstance() : (ExternalComponentDragDef)this.beanManager.lookupBean(ExternalDisplayerDragComponent.class, new Annotation[0]).getInstance();
        dragComp.setDragInfo(comp.getName(), comp.getIcon());
        dragComp.setComponentId(comp.getId());
        return dragComp;
    }
}

