/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.client.editor;

import java.lang.annotation.Annotation;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.dashbuilder.client.editor.AreaChartDragComponent;
import org.dashbuilder.client.editor.BarChartDragComponent;
import org.dashbuilder.client.editor.BubbleChartDragComponent;
import org.dashbuilder.client.editor.DisplayerDragComponent;
import org.dashbuilder.client.editor.LineChartDragComponent;
import org.dashbuilder.client.editor.MapChartDragComponent;
import org.dashbuilder.client.editor.MeterChartDragComponent;
import org.dashbuilder.client.editor.MetricDragComponent;
import org.dashbuilder.client.editor.PieChartDragComponent;
import org.dashbuilder.client.editor.SelectorDragComponent;
import org.dashbuilder.client.editor.TableDragComponent;
import org.dashbuilder.client.editor.resources.i18n.Constants;
import org.dashbuilder.displayer.DisplayerType;
import org.dashbuilder.displayer.client.RendererManager;
import org.jboss.errai.ioc.client.container.SyncBeanDef;
import org.jboss.errai.ioc.client.container.SyncBeanManager;
import org.uberfire.ext.layout.editor.client.api.LayoutDragComponent;
import org.uberfire.ext.layout.editor.client.api.LayoutDragComponentGroup;
import org.uberfire.ext.plugin.client.perspective.editor.api.PerspectiveEditorComponentGroupProvider;

@ApplicationScoped
public class PerspectiveEditorReportingGroupProvider
implements PerspectiveEditorComponentGroupProvider {
    private SyncBeanManager beanManager;
    private Constants i18n = Constants.INSTANCE;
    private RendererManager rendererManager;

    @Inject
    public PerspectiveEditorReportingGroupProvider(SyncBeanManager beanManager, RendererManager rendererManager) {
        this.beanManager = beanManager;
        this.rendererManager = rendererManager;
    }

    public String getName() {
        return this.i18n.drag_group_name_reporting();
    }

    public LayoutDragComponentGroup getComponentGroup() {
        LayoutDragComponentGroup group = new LayoutDragComponentGroup(this.getName());
        this.addComponent(DisplayerType.BARCHART, group, this.i18n.drag_component_name_barchart(), BarChartDragComponent.class);
        this.addComponent(DisplayerType.PIECHART, group, this.i18n.drag_component_name_piechart(), PieChartDragComponent.class);
        this.addComponent(DisplayerType.LINECHART, group, this.i18n.drag_component_name_linechart(), LineChartDragComponent.class);
        this.addComponent(DisplayerType.AREACHART, group, this.i18n.drag_component_name_areachart(), AreaChartDragComponent.class);
        this.addComponent(DisplayerType.BUBBLECHART, group, this.i18n.drag_component_name_bubblechart(), BubbleChartDragComponent.class);
        this.addComponent(DisplayerType.METERCHART, group, this.i18n.drag_component_name_meterchart(), MeterChartDragComponent.class);
        this.addComponent(DisplayerType.MAP, group, this.i18n.drag_component_name_mapchart(), MapChartDragComponent.class);
        this.addComponent(DisplayerType.METRIC, group, this.i18n.drag_component_name_metric(), MetricDragComponent.class);
        this.addComponent(DisplayerType.TABLE, group, this.i18n.drag_component_name_table(), TableDragComponent.class);
        this.addComponent(DisplayerType.SELECTOR, group, this.i18n.drag_component_name_filter(), SelectorDragComponent.class);
        return group;
    }

    private void addComponent(DisplayerType type, LayoutDragComponentGroup group, String name, Class dragClass) {
        if (this.rendererManager.isTypeSupported(type)) {
            group.addLayoutDragComponent(name, (LayoutDragComponent)this.lookupDisplayerComponent(dragClass));
        }
    }

    protected DisplayerDragComponent lookupDisplayerComponent(Class dragClass) {
        SyncBeanDef displayerBeanDef = this.beanManager.lookupBean(dragClass, new Annotation[0]);
        return (DisplayerDragComponent)displayerBeanDef.newInstance();
    }
}

