/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.client.editor;

import com.google.gwtmockito.GwtMockitoTestRunner;
import java.lang.annotation.Annotation;
import java.util.Map;
import org.dashbuilder.client.editor.DisplayerDragComponent;
import org.dashbuilder.client.editor.LineChartDragComponent;
import org.dashbuilder.displayer.DisplayerSettings;
import org.dashbuilder.displayer.DisplayerSubType;
import org.dashbuilder.displayer.DisplayerType;
import org.dashbuilder.displayer.client.widgets.DisplayerEditorPopup;
import org.jboss.errai.ioc.client.container.SyncBeanDef;
import org.jboss.errai.ioc.client.container.SyncBeanManager;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.uberfire.ext.layout.editor.client.api.ModalConfigurationContext;

@RunWith(value=GwtMockitoTestRunner.class)
public class DisplayerDragComponentTest {
    @InjectMocks
    DisplayerDragComponent displayerDragComponent;
    @Mock
    SyncBeanManager beanManager;
    @Mock
    SyncBeanDef<DisplayerEditorPopup> editorBeanDef;
    @Mock
    DisplayerEditorPopup editorPopup;
    @Mock
    ModalConfigurationContext configurationContext;
    @Mock
    Map<String, String> configurationProperties;
    @InjectMocks
    LineChartDragComponent lineChartDragComponent;

    @Before
    public void setUp() {
        Mockito.when((Object)this.configurationContext.getComponentProperties()).thenReturn(this.configurationProperties);
        Mockito.when((Object)this.beanManager.lookupBean(DisplayerEditorPopup.class, new Annotation[0])).thenReturn(this.editorBeanDef);
        Mockito.when((Object)((DisplayerEditorPopup)this.editorBeanDef.newInstance())).thenReturn((Object)this.editorPopup);
    }

    @Test
    public void testDefaultDisplayerType() {
        Assert.assertEquals((Object)this.lineChartDragComponent.getDisplayerType(), (Object)DisplayerType.LINECHART);
        Assert.assertEquals((Object)this.lineChartDragComponent.getDisplayerSubType(), null);
        this.lineChartDragComponent.getConfigurationModal(this.configurationContext);
        ((DisplayerEditorPopup)Mockito.verify((Object)this.editorPopup)).setDisplayerType(DisplayerType.LINECHART);
        ((DisplayerEditorPopup)Mockito.verify((Object)this.editorPopup, (VerificationMode)Mockito.never())).setDisplayerSubType((DisplayerSubType)Mockito.any());
    }

    @Test
    public void testDoNotSetDisplayerType() {
        Mockito.when((Object)this.configurationProperties.get("json")).thenReturn((Object)"");
        this.lineChartDragComponent.getConfigurationModal(this.configurationContext);
        ((DisplayerEditorPopup)Mockito.verify((Object)this.editorPopup, (VerificationMode)Mockito.never())).setDisplayerType((DisplayerType)Mockito.any());
        ((DisplayerEditorPopup)Mockito.verify((Object)this.editorPopup, (VerificationMode)Mockito.never())).setDisplayerSubType((DisplayerSubType)Mockito.any());
    }

    @Test
    public void testAdjustSize() {
        DisplayerSettings settings = (DisplayerSettings)Mockito.mock(DisplayerSettings.class);
        Mockito.when((Object)settings.getChartWidth()).thenReturn((Object)0);
        Mockito.when((Object)settings.getTableWidth()).thenReturn((Object)0);
        this.displayerDragComponent.adjustSize(settings, 0);
        ((DisplayerSettings)Mockito.verify((Object)settings)).setTableWidth(0);
        this.displayerDragComponent.adjustSize(settings, 30);
        ((DisplayerSettings)Mockito.verify((Object)settings)).setTableWidth(10);
    }
}

