/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.displayer.client;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.ComplexPanel;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Widget;
import java.lang.annotation.Annotation;
import java.util.HashMap;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.dashbuilder.common.client.StringUtils;
import org.dashbuilder.common.client.error.ClientRuntimeError;
import org.dashbuilder.dataset.DataSetLookup;
import org.dashbuilder.dataset.DataSetMetadata;
import org.dashbuilder.dataset.client.DataSetClientServices;
import org.dashbuilder.dataset.client.DataSetExportReadyCallback;
import org.dashbuilder.dataset.uuid.UUIDGenerator;
import org.dashbuilder.displayer.DisplayerSettings;
import org.dashbuilder.displayer.client.Displayer;
import org.dashbuilder.displayer.client.PerspectiveCoordinator;
import org.dashbuilder.displayer.client.resources.i18n.Constants;
import org.dashbuilder.displayer.client.widgets.DisplayerEditorPopup;
import org.dashbuilder.displayer.client.widgets.DisplayerViewer;
import org.dashbuilder.displayer.json.DisplayerSettingsJSONMarshaller;
import org.gwtbootstrap3.client.ui.AnchorListItem;
import org.gwtbootstrap3.client.ui.Button;
import org.gwtbootstrap3.client.ui.ButtonGroup;
import org.gwtbootstrap3.client.ui.DropDownMenu;
import org.gwtbootstrap3.client.ui.constants.ButtonSize;
import org.gwtbootstrap3.client.ui.constants.Pull;
import org.gwtbootstrap3.client.ui.constants.Toggle;
import org.jboss.errai.ioc.client.container.SyncBeanManager;
import org.uberfire.backend.vfs.Path;
import org.uberfire.client.annotations.WorkbenchMenu;
import org.uberfire.client.annotations.WorkbenchPartTitle;
import org.uberfire.client.annotations.WorkbenchPartView;
import org.uberfire.client.annotations.WorkbenchScreen;
import org.uberfire.client.mvp.PerspectiveManager;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.client.workbench.PanelManager;
import org.uberfire.client.workbench.events.ChangeTitleWidgetEvent;
import org.uberfire.lifecycle.OnClose;
import org.uberfire.lifecycle.OnStartup;
import org.uberfire.mvp.Command;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.mvp.impl.DefaultPlaceRequest;
import org.uberfire.workbench.model.PanelDefinition;
import org.uberfire.workbench.model.menu.MenuFactory;
import org.uberfire.workbench.model.menu.MenuItem;
import org.uberfire.workbench.model.menu.Menus;
import org.uberfire.workbench.model.menu.impl.BaseMenuCustom;

@WorkbenchScreen(identifier="DisplayerScreen")
@Dependent
public class DisplayerScreenPresenter {
    private SyncBeanManager beanManager;
    private DataSetClientServices dataSetClientServices;
    private DisplayerViewer displayerViewer;
    private PerspectiveCoordinator perspectiveCoordinator;
    private PerspectiveManager perspectiveManager;
    private PanelManager panelManager;
    private PlaceManager placeManager;
    private UUIDGenerator uuidGenerator;
    private Event<ChangeTitleWidgetEvent> changeTitleEvent;
    private DisplayerSettingsJSONMarshaller jsonMarshaller;
    private DisplayerSettings displayerSettings;
    private PlaceRequest placeRequest;
    private Menus menu = null;
    private boolean editEnabled = false;
    private boolean cloneEnabled = false;
    private boolean csvExportAllowed = false;
    private boolean excelExportAllowed = false;
    private ButtonGroup menuActionsButton;
    private static final int MAX_EXPORT_LIMIT = 100000;

    @Inject
    public DisplayerScreenPresenter(SyncBeanManager beanManager, DataSetClientServices dataSetClientServices, UUIDGenerator uuidGenerator, PerspectiveManager perspectiveManager, PlaceManager placeManager, DisplayerViewer displayerViewer, PanelManager panelManager, PerspectiveCoordinator perspectiveCoordinator, Event<ChangeTitleWidgetEvent> changeTitleEvent) {
        this.beanManager = beanManager;
        this.dataSetClientServices = dataSetClientServices;
        this.uuidGenerator = uuidGenerator;
        this.placeManager = placeManager;
        this.perspectiveManager = perspectiveManager;
        this.displayerViewer = displayerViewer;
        this.panelManager = panelManager;
        this.perspectiveCoordinator = perspectiveCoordinator;
        this.menuActionsButton = this.getMenuActionsButton();
        this.changeTitleEvent = changeTitleEvent;
        this.jsonMarshaller = DisplayerSettingsJSONMarshaller.get();
    }

    @OnStartup
    public void onStartup(PlaceRequest placeRequest) {
        this.placeRequest = placeRequest;
        String json = placeRequest.getParameter("json", "");
        if (!StringUtils.isBlank((String)json)) {
            this.displayerSettings = this.jsonMarshaller.fromJsonString(json);
        }
        if (this.displayerSettings == null) {
            throw new IllegalArgumentException(Constants.INSTANCE.displayer_presenter_displayer_notfound());
        }
        Boolean showRendererSelector = Boolean.parseBoolean(placeRequest.getParameter("showRendererSelector", "false"));
        this.displayerViewer.setIsShowRendererSelector(showRendererSelector);
        if (StringUtils.isBlank((String)this.displayerSettings.getUUID())) {
            this.displayerSettings.setUUID(this.uuidGenerator.newUuid());
        }
        this.displayerViewer.init(this.displayerSettings);
        Displayer displayer = this.displayerViewer.draw();
        this.perspectiveCoordinator.addDisplayer(displayer);
        String edit = placeRequest.getParameter("edit", "false");
        String clone = placeRequest.getParameter("clone", "false");
        this.editEnabled = Boolean.parseBoolean(edit);
        this.cloneEnabled = Boolean.parseBoolean(clone);
        this.csvExportAllowed = this.displayerSettings.isCSVExportAllowed();
        this.excelExportAllowed = this.displayerSettings.isExcelExportAllowed();
        this.menu = this.makeMenuBar();
        this.adjustMenuActions(this.displayerSettings);
    }

    @OnClose
    public void onClose() {
        this.removeDisplayer();
    }

    @WorkbenchPartTitle
    public String getTitle() {
        return this.displayerSettings.getTitle();
    }

    @WorkbenchPartView
    public IsWidget getView() {
        return this.displayerViewer;
    }

    @WorkbenchMenu
    public Menus getMenu() {
        return this.menu;
    }

    private Menus makeMenuBar() {
        return ((MenuFactory.TopLevelMenusBuilder)MenuFactory.newTopLevelCustomMenu((MenuFactory.CustomMenuBuilder)new MenuFactory.CustomMenuBuilder(){

            public void push(MenuFactory.CustomMenuBuilder element) {
            }

            public MenuItem build() {
                return new BaseMenuCustom<IsWidget>(){

                    public IsWidget build() {
                        return DisplayerScreenPresenter.this.menuActionsButton;
                    }

                    public boolean isEnabled() {
                        return DisplayerScreenPresenter.this.editEnabled || DisplayerScreenPresenter.this.cloneEnabled || DisplayerScreenPresenter.this.csvExportAllowed || DisplayerScreenPresenter.this.excelExportAllowed;
                    }

                    public void setEnabled(boolean enabled) {
                    }
                };
            }
        }).endMenu()).build();
    }

    private Command getEditCommand() {
        return new Command(){

            public void execute() {
                DisplayerScreenPresenter.this.perspectiveCoordinator.editOn();
                String currentTitle = DisplayerScreenPresenter.this.displayerSettings.getTitle();
                DisplayerEditorPopup displayerEditor = (DisplayerEditorPopup)DisplayerScreenPresenter.this.beanManager.lookupBean(DisplayerEditorPopup.class, new Annotation[0]).newInstance();
                displayerEditor.init(DisplayerScreenPresenter.this.displayerSettings.cloneInstance());
                displayerEditor.setOnSaveCommand(DisplayerScreenPresenter.this.getSaveCommand(displayerEditor, currentTitle));
                displayerEditor.setOnCloseCommand(DisplayerScreenPresenter.this.getCloseCommand(displayerEditor));
            }
        };
    }

    protected Command getCloneCommand() {
        return new Command(){

            public void execute() {
                DisplayerScreenPresenter.this.perspectiveCoordinator.editOn();
                DisplayerSettings clonedSettings = DisplayerScreenPresenter.this.displayerSettings.cloneInstance();
                clonedSettings.setUUID(DisplayerScreenPresenter.this.uuidGenerator.newUuid());
                clonedSettings.setTitle("Copy of " + clonedSettings.getTitle());
                DisplayerEditorPopup displayerEditor = (DisplayerEditorPopup)DisplayerScreenPresenter.this.beanManager.lookupBean(DisplayerEditorPopup.class, new Annotation[0]).newInstance();
                displayerEditor.init(clonedSettings);
                displayerEditor.setOnSaveCommand(DisplayerScreenPresenter.this.getSaveCloneCommand(displayerEditor));
                displayerEditor.setOnCloseCommand(DisplayerScreenPresenter.this.getCloseCommand(displayerEditor));
            }
        };
    }

    protected Command getSaveCommand(final DisplayerEditorPopup displayerEditor, final String currentTitle) {
        return new Command(){

            public void execute() {
                DisplayerScreenPresenter.this.perspectiveCoordinator.editOff();
                DisplayerSettings newSettings = displayerEditor.getDisplayerSettings();
                if (!DisplayerScreenPresenter.this.displayerSettings.equals((Object)newSettings)) {
                    String newTitle = newSettings.getTitle();
                    if (!currentTitle.equals(newTitle)) {
                        DisplayerScreenPresenter.this.changeTitleEvent.fire((Object)new ChangeTitleWidgetEvent(DisplayerScreenPresenter.this.placeRequest, newSettings.getTitle()));
                    }
                    PanelDefinition panelDefinition = DisplayerScreenPresenter.this.panelManager.getPanelForPlace(DisplayerScreenPresenter.this.placeRequest);
                    DisplayerScreenPresenter.this.beanManager.destroyBean((Object)displayerEditor);
                    DisplayerScreenPresenter.this.placeManager.goTo(DisplayerScreenPresenter.this.createPlaceRequest(newSettings), panelDefinition);
                    DisplayerScreenPresenter.this.placeManager.closePlace(DisplayerScreenPresenter.this.placeRequest);
                    DisplayerScreenPresenter.this.perspectiveManager.savePerspectiveState(new Command(){

                        public void execute() {
                        }
                    });
                }
            }
        };
    }

    protected Command getSaveCloneCommand(final DisplayerEditorPopup displayerEditor) {
        return new Command(){

            public void execute() {
                DisplayerScreenPresenter.this.perspectiveCoordinator.editOff();
                DisplayerScreenPresenter.this.beanManager.destroyBean((Object)displayerEditor);
                PanelDefinition panelDefinition = DisplayerScreenPresenter.this.panelManager.getPanelForPlace(DisplayerScreenPresenter.this.placeRequest);
                DisplayerScreenPresenter.this.placeManager.goTo(DisplayerScreenPresenter.this.createPlaceRequest(displayerEditor.getDisplayerSettings()), panelDefinition);
                DisplayerScreenPresenter.this.perspectiveManager.savePerspectiveState(new Command(){

                    public void execute() {
                    }
                });
            }
        };
    }

    protected Command getCloseCommand(final DisplayerEditorPopup displayerEditor) {
        return new Command(){

            public void execute() {
                DisplayerScreenPresenter.this.perspectiveCoordinator.editOff();
                DisplayerScreenPresenter.this.beanManager.destroyBean((Object)displayerEditor);
            }
        };
    }

    protected Command getExportCsvCommand() {
        return new Command(){

            public void execute() {
                try {
                    DataSetLookup currentLookup = DisplayerScreenPresenter.this.getConstrainedDataSetLookup(DisplayerScreenPresenter.this.displayerViewer.getDisplayer().getDataSetHandler().getCurrentDataSetLookup());
                    DisplayerScreenPresenter.this.dataSetClientServices.exportDataSetCSV(currentLookup, new DataSetExportReadyCallback(){

                        public void exportReady(Path exportFilePath) {
                            String u = DisplayerScreenPresenter.this.dataSetClientServices.getDownloadFileUrl(exportFilePath);
                            Window.open((String)u, (String)"downloading", (String)"resizable=no,scrollbars=yes,status=no");
                        }

                        public void onError(ClientRuntimeError error) {
                            DisplayerScreenPresenter.this.displayerViewer.error(error);
                        }
                    });
                }
                catch (Exception e) {
                    DisplayerScreenPresenter.this.displayerViewer.error(new ClientRuntimeError((Throwable)e));
                }
            }
        };
    }

    protected Command getExportExcelCommand() {
        return new Command(){

            public void execute() {
                try {
                    DataSetLookup currentLookup = DisplayerScreenPresenter.this.getConstrainedDataSetLookup(DisplayerScreenPresenter.this.displayerViewer.getDisplayer().getDataSetHandler().getCurrentDataSetLookup());
                    DisplayerScreenPresenter.this.dataSetClientServices.exportDataSetExcel(currentLookup, new DataSetExportReadyCallback(){

                        public void exportReady(Path exportFilePath) {
                            String u = DisplayerScreenPresenter.this.dataSetClientServices.getDownloadFileUrl(exportFilePath);
                            Window.open((String)u, (String)"downloading", (String)"resizable=no,scrollbars=yes,status=no");
                        }

                        public void onError(ClientRuntimeError error) {
                            DisplayerScreenPresenter.this.displayerViewer.error(error);
                        }
                    });
                }
                catch (Exception e) {
                    DisplayerScreenPresenter.this.displayerViewer.error(new ClientRuntimeError((Throwable)e));
                }
            }
        };
    }

    protected DataSetLookup getConstrainedDataSetLookup(DataSetLookup dataSetLookup) {
        DataSetLookup _dataSetLookup = dataSetLookup.cloneInstance();
        if (dataSetLookup.getNumberOfRows() > 0) {
            DataSetMetadata metadata = this.dataSetClientServices.getMetadata(dataSetLookup.getDataSetUUID());
            if (metadata.getNumberOfRows() > 100000) {
                Window.alert((String)Constants.INSTANCE.displayer_presenter_export_large_dataset());
            }
            _dataSetLookup.setRowOffset(0);
            _dataSetLookup.setNumberOfRows(100000);
        }
        return _dataSetLookup;
    }

    protected void removeDisplayer() {
        Displayer displayer = this.displayerViewer.getDisplayer();
        this.perspectiveCoordinator.removeDisplayer(displayer);
        displayer.close();
        this.beanManager.destroyBean((Object)this.displayerViewer);
    }

    protected PlaceRequest createPlaceRequest(DisplayerSettings displayerSettings) {
        String json = this.jsonMarshaller.toJsonString(displayerSettings);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("json", json);
        params.put("edit", "true");
        params.put("clone", "true");
        return new DefaultPlaceRequest("DisplayerScreen", params);
    }

    protected void adjustMenuActions(DisplayerSettings displayerSettings) {
        ComplexPanel menu = (ComplexPanel)this.menuActionsButton.getWidget(1);
        menu.getWidget(2).setVisible(displayerSettings.isCSVExportAllowed());
        menu.getWidget(3).setVisible(displayerSettings.isExcelExportAllowed());
    }

    protected ButtonGroup getMenuActionsButton() {
        return new ButtonGroup(){
            {
                this.add((Widget)new Button(Constants.INSTANCE.menu_button_actions()){
                    {
                        this.setSize(ButtonSize.EXTRA_SMALL);
                        this.addStyleName(Pull.RIGHT.getCssName());
                        this.setDataToggle(Toggle.DROPDOWN);
                    }
                });
                this.add((Widget)new DropDownMenu(){
                    {
                        this.add((Widget)new AnchorListItem(Constants.INSTANCE.menu_edit()){
                            {
                                this.addClickHandler(new ClickHandler(){

                                    public void onClick(ClickEvent clickEvent) {
                                        DisplayerScreenPresenter.this.getEditCommand().execute();
                                    }
                                });
                            }
                        });
                        this.add((Widget)new AnchorListItem(Constants.INSTANCE.menu_clone()){
                            {
                                this.addClickHandler(new ClickHandler(){

                                    public void onClick(ClickEvent clickEvent) {
                                        DisplayerScreenPresenter.this.getCloneCommand().execute();
                                    }
                                });
                            }
                        });
                        this.add((Widget)new AnchorListItem(Constants.INSTANCE.menu_export_csv()){
                            {
                                this.addClickHandler(new ClickHandler(){

                                    public void onClick(ClickEvent clickEvent) {
                                        DisplayerScreenPresenter.this.getExportCsvCommand().execute();
                                    }
                                });
                            }
                        });
                        this.add((Widget)new AnchorListItem(Constants.INSTANCE.menu_export_excel()){
                            {
                                this.addClickHandler(new ClickHandler(){

                                    public void onClick(ClickEvent clickEvent) {
                                        DisplayerScreenPresenter.this.getExportExcelCommand().execute();
                                    }
                                });
                            }
                        });
                    }
                });
            }
        };
    }
}

