/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.displayer.client;

import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.dashbuilder.dataset.DataSet;
import org.dashbuilder.dataset.DataSetLookup;
import org.dashbuilder.dataset.events.DataSetModifiedEvent;
import org.dashbuilder.displayer.DisplayerSettings;
import org.dashbuilder.displayer.client.Displayer;
import org.dashbuilder.displayer.client.DisplayerCoordinator;
import org.uberfire.client.workbench.events.PerspectiveChange;

@ApplicationScoped
public class PerspectiveCoordinator {
    private DisplayerCoordinator displayerCoordinator;
    boolean editOn = false;

    public PerspectiveCoordinator() {
    }

    @Inject
    public PerspectiveCoordinator(DisplayerCoordinator coordinator) {
        this.displayerCoordinator = coordinator;
    }

    public void addDisplayer(Displayer displayer) {
        this.displayerCoordinator.addDisplayer(displayer);
    }

    public boolean removeDisplayer(Displayer displayer) {
        return this.displayerCoordinator.removeDisplayer(displayer);
    }

    public List<Displayer> getDisplayerList() {
        return this.displayerCoordinator.getDisplayerList();
    }

    public void editOn() {
        this.editOn = true;
        for (Displayer displayer : this.displayerCoordinator.getDisplayerList()) {
            displayer.setRefreshOn(false);
        }
    }

    public void editOff() {
        this.editOn = false;
        for (Displayer displayer : this.displayerCoordinator.getDisplayerList()) {
            displayer.setRefreshOn(true);
        }
    }

    private void onPerspectiveChanged(@Observes PerspectiveChange event) {
        this.displayerCoordinator.clear();
    }

    private void onDataSetModifiedEvent(@Observes DataSetModifiedEvent event) {
        if (!this.editOn) {
            String targetUUID = event.getDataSetDef().getUUID();
            for (Displayer displayer : this.displayerCoordinator.getDisplayerList()) {
                DisplayerSettings settings = displayer.getDisplayerSettings();
                if (!displayer.isDrawn() || displayer.isRefreshOn() || !settings.isRefreshStaleData()) continue;
                String uuid = null;
                DataSet dataSet = settings.getDataSet();
                if (dataSet != null) {
                    uuid = dataSet.getUUID();
                }
                DataSetLookup dataSetLookup = settings.getDataSetLookup();
                if (uuid == null && dataSetLookup != null) {
                    uuid = dataSetLookup.getDataSetUUID();
                }
                if (uuid == null || !targetUUID.equals(uuid)) continue;
                displayer.redraw();
            }
        }
    }
}

