/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.dsl.serialization;

import io.netty.util.internal.shaded.org.jctools.queues.MessagePassingQueue;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import org.dashbuilder.dsl.model.Dashboard;
import org.dashbuilder.dsl.serialization.impl.DashboardZipSerializer;
import org.dashbuilder.dsl.validation.DashboardValidator;
import org.dashbuilder.dsl.validation.ValidationResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DashboardExporter {
    private static final Logger logger = LoggerFactory.getLogger(DashboardExporter.class);
    private static final DashboardExporter INSTANCE = new DashboardExporter();
    DashboardValidator validator = DashboardValidator.get();

    private DashboardExporter() {
    }

    public static DashboardExporter get() {
        return INSTANCE;
    }

    public void export(Dashboard dashboard, String path, ExportType type) {
        this.export(dashboard, Paths.get(path, new String[0]), type);
    }

    public void export(Dashboard dashboard, Path path, ExportType type) {
        DashboardZipSerializer serializer = DashboardExporter.serializerFor(type);
        this.validate(dashboard);
        Path temp = this.createTempDashboardFile();
        try (FileOutputStream fos = new FileOutputStream(temp.toFile());){
            serializer.serialize(dashboard, fos);
            Files.move(temp, path, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (FileNotFoundException e) {
            throw new IllegalArgumentException("File not found: " + path, e);
        }
        catch (IOException e) {
            throw new RuntimeException("Error writing to file " + path, e);
        }
        finally {
            try {
                Files.deleteIfExists(temp);
            }
            catch (IOException e) {
                logger.error("Error deleting temp file", (Throwable)e);
            }
        }
    }

    private Path createTempDashboardFile() {
        try {
            return Files.createTempFile("dashboard", ".zip", new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new RuntimeException("Error creating temp file to export dashboard", e);
        }
    }

    void validate(Dashboard dashboard) {
        List<ValidationResult> results = this.validator.validate(dashboard);
        this.printResult(results, ValidationResult.ValidationResultType.ERROR, (MessagePassingQueue.Consumer<String>)((MessagePassingQueue.Consumer)arg_0 -> ((Logger)logger).error(arg_0)));
        this.printResult(results, ValidationResult.ValidationResultType.WARNING, (MessagePassingQueue.Consumer<String>)((MessagePassingQueue.Consumer)arg_0 -> ((Logger)logger).warn(arg_0)));
        this.printResult(results, ValidationResult.ValidationResultType.SUCCESS, (MessagePassingQueue.Consumer<String>)((MessagePassingQueue.Consumer)arg_0 -> ((Logger)logger).info(arg_0)));
        if (results.stream().anyMatch(p -> p.getType() == ValidationResult.ValidationResultType.ERROR)) {
            throw new IllegalArgumentException("There are validation errors, check logs for more details");
        }
    }

    private void printResult(List<ValidationResult> results, ValidationResult.ValidationResultType type, MessagePassingQueue.Consumer<String> printer) {
        results.stream().filter(v -> v.getType() == type).map(Object::toString).forEach(arg_0 -> printer.accept(arg_0));
    }

    private static DashboardZipSerializer serializerFor(ExportType type) {
        switch (type) {
            case ZIP: {
                return new DashboardZipSerializer();
            }
        }
        return new DashboardZipSerializer();
    }

    public static enum ExportType {
        ZIP;

    }
}

