/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.dsl.factory.component;

import org.dashbuilder.dataset.DataSetFactory;
import org.dashbuilder.displayer.DisplayerSettings;
import org.dashbuilder.displayer.DisplayerSettingsFactory;
import org.dashbuilder.displayer.impl.AreaChartSettingsBuilderImpl;
import org.dashbuilder.displayer.json.DisplayerSettingsJSONMarshaller;
import org.dashbuilder.dsl.factory.component.DisplayerBuilder;
import org.dashbuilder.dsl.model.Component;
import org.junit.Assert;
import org.junit.Test;

public class DisplayerBuilderTest {
    @Test
    public void testDisplayerJson() {
        DisplayerSettings settings = ((AreaChartSettingsBuilderImpl)((AreaChartSettingsBuilderImpl)DisplayerSettingsFactory.newAreaChartSettings().subType_Area()).dataset("test")).buildSettings();
        String json = DisplayerSettingsJSONMarshaller.get().toJsonString(settings);
        Component comp = DisplayerBuilder.create((DisplayerSettings)settings).build();
        Assert.assertEquals((Object)json, comp.getLayoutComponent().getProperties().get("json"));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testSettingsMissingDataSetUUID() {
        DisplayerSettings settings = ((AreaChartSettingsBuilderImpl)DisplayerSettingsFactory.newAreaChartSettings().subType_Area()).buildSettings();
        DisplayerBuilder.create((DisplayerSettings)settings).build();
    }

    @Test(expected=IllegalArgumentException.class)
    public void testSettingsEmptyDataSetUUID() {
        DisplayerSettings settings = ((AreaChartSettingsBuilderImpl)((AreaChartSettingsBuilderImpl)DisplayerSettingsFactory.newAreaChartSettings().subType_Area()).dataset("    ")).buildSettings();
        DisplayerBuilder.create((DisplayerSettings)settings).build();
    }

    @Test
    public void testWithDataSet() {
        DisplayerSettings settings = ((AreaChartSettingsBuilderImpl)((AreaChartSettingsBuilderImpl)DisplayerSettingsFactory.newAreaChartSettings().subType_Area()).dataset(DataSetFactory.newEmptyDataSet())).buildSettings();
        Assert.assertNotNull((Object)DisplayerBuilder.create((DisplayerSettings)settings).build());
    }
}

