/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.dsl.validation;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.dashbuilder.dataset.DataSetLookup;
import org.dashbuilder.dataset.def.DataSetDef;
import org.dashbuilder.displayer.DisplayerSettings;
import org.dashbuilder.displayer.json.DisplayerSettingsJSONMarshaller;
import org.dashbuilder.dsl.factory.navigation.NavigationFactory;
import org.dashbuilder.dsl.helper.ComponentsHelper;
import org.dashbuilder.dsl.model.Dashboard;
import org.dashbuilder.dsl.model.Navigation;
import org.dashbuilder.dsl.model.Page;
import org.dashbuilder.dsl.validation.DashboardValidator;
import org.dashbuilder.dsl.validation.ValidationResult;
import org.dashbuilder.navigation.NavDivider;
import org.dashbuilder.navigation.NavGroup;
import org.dashbuilder.navigation.NavItem;
import org.dashbuilder.navigation.NavItemVisitor;

class DashboardValidatorImpl
implements DashboardValidator {
    private static final String MISSING_NAVIGATION_ITEM = "Navigation item %s has no corresponding page";
    private static final String DUPLICATED_GROUPS = "The Navigation constains duplicate group names";
    private static final String VALID_NAVIGATION = "Navigation is valid";
    private static final String NO_MISSING_DATA_SET = "No missing data set dependencies for page %s";
    private static final String MISSING_DATA_SET = "The following data sets definitions used in page %s were not found: %s";
    private static final String NO_MISSING_COMPONENT = "No missing component dependencies for page %s";
    private static final String MISSING_COMPONENT_MESSAGE = "The following components used in page %s were not found: %s";
    DisplayerSettingsJSONMarshaller displayerSettingsMarshaller = DisplayerSettingsJSONMarshaller.get();

    DashboardValidatorImpl() {
    }

    @Override
    public List<ValidationResult> validate(Dashboard dashboard) {
        ArrayList<ValidationResult> results = new ArrayList<ValidationResult>();
        results.addAll(this.checkDataSetsDependencies(dashboard));
        results.addAll(this.checkComponentsDependencies(dashboard));
        results.addAll(this.checkNavigation(dashboard));
        return results;
    }

    private List<ValidationResult> checkNavigation(Dashboard dashboard) {
        Navigation navigation = dashboard.getNavigation();
        NavigationPagesVisitor visitor = new NavigationPagesVisitor();
        ArrayList<ValidationResult> results = new ArrayList<ValidationResult>();
        if (navigation == null || navigation == NavigationFactory.emptyNavigation()) {
            return Collections.emptyList();
        }
        navigation.getNavTree().accept((NavItemVisitor)visitor);
        List<String> visitedPages = visitor.getVisitedPages();
        List<String> visitedGroups = visitor.getVisitedGroups();
        if (!visitedPages.isEmpty()) {
            visitedPages.stream().filter(vp -> dashboard.getPages().stream().noneMatch(p -> p.getLayoutTemplate().getName().equals(vp))).map(vp -> ValidationResult.error(String.format(MISSING_NAVIGATION_ITEM, vp))).forEach(results::add);
        }
        if (this.containDuplicates(visitedGroups)) {
            results.add(ValidationResult.error(DUPLICATED_GROUPS));
        }
        if (results.isEmpty()) {
            results.add(ValidationResult.success(VALID_NAVIGATION));
        }
        return results;
    }

    List<ValidationResult> checkComponentsDependencies(Dashboard dashboard) {
        List<String> components = ComponentsHelper.listComponentsIds(dashboard);
        return dashboard.getPages().stream().map(p -> this.validateComponentsUsage((Page)p, components)).filter(Objects::nonNull).collect(Collectors.toList());
    }

    List<ValidationResult> checkDataSetsDependencies(Dashboard dashboard) {
        return dashboard.getPages().stream().map(p -> this.validateDataSetsUsage((Page)p, dashboard.getDataSets())).filter(Objects::nonNull).collect(Collectors.toList());
    }

    ValidationResult validateDataSetsUsage(Page page, List<DataSetDef> dataSets) {
        List<String> dataSetsDeps = this.findDataSetsDependencies(page);
        if (dataSetsDeps.isEmpty()) {
            return null;
        }
        Set missingDataSets = dataSetsDeps.stream().filter(uuid -> this.noneMatch(dataSets, ds -> ds.getUUID().equals(uuid))).collect(Collectors.toSet());
        return missingDataSets.isEmpty() ? ValidationResult.success(String.format(NO_MISSING_DATA_SET, page.getLayoutTemplate().getName())) : ValidationResult.error(String.format(MISSING_DATA_SET, page.getLayoutTemplate().getName(), missingDataSets.stream().collect(Collectors.joining(", "))));
    }

    ValidationResult validateComponentsUsage(Page page, List<String> components) {
        List<String> componentsDeps = this.findComponentsDependencies(page);
        if (componentsDeps.isEmpty()) {
            return null;
        }
        Set missingComponents = componentsDeps.stream().filter(id -> this.noneMatch(components, cid -> cid.equals(id))).collect(Collectors.toSet());
        return missingComponents.isEmpty() ? ValidationResult.success(String.format(NO_MISSING_COMPONENT, page.getLayoutTemplate().getName())) : ValidationResult.warning(String.format(MISSING_COMPONENT_MESSAGE, page.getLayoutTemplate().getName(), missingComponents.stream().collect(Collectors.joining(", "))));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private <T> boolean noneMatch(List<T> list, Predicate<T> test) {
        if (list.isEmpty()) return true;
        if (!list.stream().noneMatch(test::test)) return false;
        return true;
    }

    private List<String> findDataSetsDependencies(Page page) {
        return ComponentsHelper.collectingPropertyValue(page, "json").map(arg_0 -> ((DisplayerSettingsJSONMarshaller)this.displayerSettingsMarshaller).fromJsonString(arg_0)).map(DisplayerSettings::getDataSetLookup).filter(Objects::nonNull).map(DataSetLookup::getDataSetUUID).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private List<String> findComponentsDependencies(Page page) {
        return ComponentsHelper.collectingPropertyValue(page, "componentId").filter(c -> !c.endsWith("provided")).collect(Collectors.toList());
    }

    private boolean containDuplicates(List<String> list) {
        return (long)list.size() > list.stream().distinct().count();
    }

    static class NavigationPagesVisitor
    implements NavItemVisitor {
        private List<String> visitedPages = new ArrayList<String>();
        private List<String> visitedGroups = new ArrayList<String>();

        NavigationPagesVisitor() {
        }

        public List<String> getVisitedPages() {
            return this.visitedPages;
        }

        public void visitGroup(NavGroup group) {
            this.visitedGroups.add(group.getName());
        }

        public void visitItem(NavItem item) {
            this.visitedPages.add(item.getName());
        }

        public void visitDivider(NavDivider divider) {
        }

        public List<String> getVisitedGroups() {
            return this.visitedGroups;
        }
    }
}

