/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.dsl.serialization.impl;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import org.dashbuilder.dataset.ColumnType;
import org.dashbuilder.dataset.def.DataSetDef;
import org.dashbuilder.dataset.def.DataSetDefFactory;
import org.dashbuilder.dataset.group.AggregateFunctionType;
import org.dashbuilder.dataset.impl.CSVDataSetDefBuilderImpl;
import org.dashbuilder.displayer.DisplayerSettings;
import org.dashbuilder.displayer.DisplayerSettingsFactory;
import org.dashbuilder.displayer.DisplayerSubType;
import org.dashbuilder.displayer.Position;
import org.dashbuilder.displayer.impl.LineChartSettingsBuilderImpl;
import org.dashbuilder.displayer.impl.SelectorDisplayerSettingsBuilderImpl;
import org.dashbuilder.dsl.factory.component.ComponentFactory;
import org.dashbuilder.dsl.factory.dashboard.DashboardFactory;
import org.dashbuilder.dsl.factory.navigation.NavigationFactory;
import org.dashbuilder.dsl.factory.page.PageBuilder;
import org.dashbuilder.dsl.factory.page.PageFactory;
import org.dashbuilder.dsl.model.Component;
import org.dashbuilder.dsl.model.Dashboard;
import org.dashbuilder.dsl.model.Navigation;
import org.dashbuilder.dsl.model.NavigationGroup;
import org.dashbuilder.dsl.model.NavigationItem;
import org.dashbuilder.dsl.model.Page;
import org.dashbuilder.dsl.model.Row;
import org.dashbuilder.dsl.serialization.impl.DashboardZipSerializer;
import org.dashbuilder.navigation.json.NavTreeJSONMarshaller;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.uberfire.ext.layout.editor.api.css.CssProperty;

public class DashboardZipSerializerTest {
    String csvFilePath = this.getClass().getResource("/data/un_world_pop_medium_variant.csv").getFile();
    private DashboardZipSerializer serializer;

    @Before
    public void before() {
        this.serializer = new DashboardZipSerializer();
    }

    @Test
    public void testExportedStaticFiles() throws IOException {
        DataSetDef def = ((CSVDataSetDefBuilderImpl)((CSVDataSetDefBuilderImpl)((CSVDataSetDefBuilderImpl)DataSetDefFactory.newCSVDataSetDef().uuid("myDs")).filePath(this.csvFilePath).separatorChar(',').quoteChar('\"').column("Year", ColumnType.NUMBER)).cacheOff()).buildDef();
        Page page = PageFactory.page((String)"My Page", (Row[])new Row[]{PageFactory.row((Component)ComponentFactory.external((String)"comp1"))});
        Path componentsPath = Paths.get(this.getClass().getResource("/components").getFile(), new String[0]);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.serializer.serialize(DashboardFactory.dashboard(Arrays.asList(page), Arrays.asList(def), (Path)componentsPath), (OutputStream)out);
        Map content = this.serializer.readAllEntriesContent((InputStream)new ByteArrayInputStream(out.toByteArray()));
        Assert.assertEquals((Object)this.read("/components/comp1/manifest.json"), content.get("dashbuilder/components/comp1/manifest.json"));
        Assert.assertEquals((Object)this.read("/components/comp1/index.html"), content.get("dashbuilder/components/comp1/index.html"));
        Assert.assertEquals((Object)this.read("/components/comp1/index.js"), content.get("dashbuilder/components/comp1/index.js"));
        Assert.assertEquals((Object)this.read("/data/un_world_pop_medium_variant.csv"), content.get("dashbuilder/datasets/definitions/myDs.csv"));
    }

    @Test
    public void testExportedZip() throws Exception {
        DataSetDef def = ((CSVDataSetDefBuilderImpl)DataSetDefFactory.newCSVDataSetDef().uuid(UUID.randomUUID().toString())).filePath(this.csvFilePath).separatorChar(',').quoteChar('\"').buildDef();
        DisplayerSettings filterByYear = ((SelectorDisplayerSettingsBuilderImpl)((SelectorDisplayerSettingsBuilderImpl)((SelectorDisplayerSettingsBuilderImpl)((SelectorDisplayerSettingsBuilderImpl)((SelectorDisplayerSettingsBuilderImpl)DisplayerSettingsFactory.newSelectorSettings().subtype(DisplayerSubType.SELECTOR_SLIDER)).width(1200)).filterOn(false, true, false)).dataset(def.getUUID())).column("Year")).buildSettings();
        DisplayerSettings evolutionChart = ((LineChartSettingsBuilderImpl)((LineChartSettingsBuilderImpl)((LineChartSettingsBuilderImpl)((LineChartSettingsBuilderImpl)((LineChartSettingsBuilderImpl)((LineChartSettingsBuilderImpl)((LineChartSettingsBuilderImpl)((LineChartSettingsBuilderImpl)((LineChartSettingsBuilderImpl)((LineChartSettingsBuilderImpl)((LineChartSettingsBuilderImpl)((LineChartSettingsBuilderImpl)((LineChartSettingsBuilderImpl)DisplayerSettingsFactory.newLineChartSettings().subType_SmoothLine()).dataset(def.getUUID())).width(1200)).legendOn(Position.IN)).xAxisAngle(0)).margins(0, 30, 0, 0)).filterOn(false, false, true)).group("Year")).column("Year")).expression("parseInt(value)")).column("PopTotal", AggregateFunctionType.SUM, "Total")).column("PopFemale", AggregateFunctionType.SUM, "Female")).column("PopMale", AggregateFunctionType.SUM, "Male")).buildSettings();
        Page page = ((PageBuilder)PageFactory.pageBuilder((String)"Population").cssProperty(CssProperty.MARGIN_LEFT, "10px")).rows(new Row[]{PageFactory.row((String)"<h3>Population growth until 2100</h3>"), PageFactory.row((DisplayerSettings)filterByYear), PageFactory.row((DisplayerSettings)evolutionChart)}).build();
        Navigation navigation = NavigationFactory.navigation((NavigationGroup[])new NavigationGroup[]{NavigationFactory.group((String)"Test Group", (NavigationItem[])new NavigationItem[]{NavigationFactory.item((Page)page)})});
        Dashboard db = DashboardFactory.dashboard(Arrays.asList(page), Arrays.asList(def), (Navigation)navigation);
        String navTreeString = NavTreeJSONMarshaller.get().toJson(navigation.getNavTree()).toString();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.serializer.serialize(db, (OutputStream)out);
        Dashboard deserialized = this.serializer.internalDeserialize((InputStream)new ByteArrayInputStream(out.toByteArray()));
        Assert.assertEquals((Object)page.getLayoutTemplate().getName(), (Object)((Page)deserialized.getPages().get(0)).getLayoutTemplate().getName());
        Assert.assertEquals((Object)def.getUUID(), (Object)((DataSetDef)deserialized.getDataSets().get(0)).getUUID());
        Assert.assertEquals((Object)navTreeString, (Object)NavTreeJSONMarshaller.get().toJson(deserialized.getNavigation().getNavTree()).toString());
    }

    private String read(String path) throws IOException {
        return Files.readAllLines(Paths.get(this.getClass().getResource(path).getFile(), new String[0])).stream().collect(Collectors.joining("\n"));
    }
}

