/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.dsl.validation;

import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.List;
import org.dashbuilder.dataset.def.DataSetDef;
import org.dashbuilder.dataset.def.DataSetDefFactory;
import org.dashbuilder.dataset.impl.StaticDataSetDefBuilderImpl;
import org.dashbuilder.displayer.DisplayerSettings;
import org.dashbuilder.displayer.DisplayerSettingsFactory;
import org.dashbuilder.displayer.impl.AreaChartSettingsBuilderImpl;
import org.dashbuilder.dsl.factory.component.ComponentFactory;
import org.dashbuilder.dsl.factory.dashboard.DashboardFactory;
import org.dashbuilder.dsl.factory.navigation.NavigationFactory;
import org.dashbuilder.dsl.factory.page.PageFactory;
import org.dashbuilder.dsl.model.Component;
import org.dashbuilder.dsl.model.Dashboard;
import org.dashbuilder.dsl.model.Navigation;
import org.dashbuilder.dsl.model.NavigationGroup;
import org.dashbuilder.dsl.model.NavigationItem;
import org.dashbuilder.dsl.model.Page;
import org.dashbuilder.dsl.model.Row;
import org.dashbuilder.dsl.validation.DashboardValidatorImpl;
import org.dashbuilder.dsl.validation.ValidationResult;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class DashboardValidatorImplTest {
    private DashboardValidatorImpl impl;
    private Path componentsPath;

    @Before
    public void before() throws IOException {
        this.impl = new DashboardValidatorImpl();
        this.componentsPath = Paths.get(this.getClass().getResource("/components").getFile(), new String[0]);
    }

    @Test
    public void testMissingDataSet() {
        DisplayerSettings settings = ((AreaChartSettingsBuilderImpl)((AreaChartSettingsBuilderImpl)DisplayerSettingsFactory.newAreaChartSettings().subType_Area()).dataset("nonExisting")).buildSettings();
        Page page = PageFactory.page((String)"abc", (Row[])new Row[]{PageFactory.row((Component)ComponentFactory.displayer((DisplayerSettings)settings))});
        Dashboard dashboard = DashboardFactory.dashboard(Arrays.asList(page));
        List results = this.impl.validate(dashboard);
        ValidationResult result = (ValidationResult)results.get(0);
        Assert.assertEquals((long)1L, (long)results.size());
        Assert.assertEquals((Object)"The following data sets definitions used in page abc were not found: nonExisting", (Object)result.getMessage());
        Assert.assertEquals((Object)ValidationResult.ValidationResultType.ERROR, (Object)result.getType());
    }

    @Test
    public void testDataSetFound() {
        DataSetDef def = ((StaticDataSetDefBuilderImpl)DataSetDefFactory.newStaticDataSetDef().uuid("myds")).buildDef();
        DisplayerSettings settings = ((AreaChartSettingsBuilderImpl)((AreaChartSettingsBuilderImpl)DisplayerSettingsFactory.newAreaChartSettings().subType_Area()).dataset(def.getUUID())).buildSettings();
        Page page = PageFactory.page((String)"abc", (Row[])new Row[]{PageFactory.row((Component)ComponentFactory.displayer((DisplayerSettings)settings))});
        Dashboard dashboard = DashboardFactory.dashboard(Arrays.asList(page), Arrays.asList(def));
        List results = this.impl.validate(dashboard);
        ValidationResult result = (ValidationResult)results.get(0);
        Assert.assertEquals((long)1L, (long)results.size());
        Assert.assertEquals((Object)"No missing data set dependencies for page abc", (Object)result.getMessage());
        Assert.assertEquals((Object)ValidationResult.ValidationResultType.SUCCESS, (Object)result.getType());
    }

    @Test
    public void testMissingComponent() {
        DisplayerSettings settings = DisplayerSettingsFactory.newExternalDisplayerSettings().buildSettings();
        Page page = PageFactory.page((String)"abc", (Row[])new Row[]{PageFactory.row((Component)ComponentFactory.external((String)"missingComp", (DisplayerSettings)settings))});
        Dashboard dashboard = DashboardFactory.dashboard(Arrays.asList(page));
        List results = this.impl.validate(dashboard);
        ValidationResult result = (ValidationResult)results.get(0);
        Assert.assertEquals((long)1L, (long)results.size());
        Assert.assertEquals((Object)"The following components used in page abc were not found: missingComp", (Object)result.getMessage());
        Assert.assertEquals((Object)ValidationResult.ValidationResultType.WARNING, (Object)result.getType());
    }

    @Test
    public void testExistingComponent() {
        DisplayerSettings settings = DisplayerSettingsFactory.newExternalDisplayerSettings().buildSettings();
        Page page = PageFactory.page((String)"abc", (Row[])new Row[]{PageFactory.row((Component)ComponentFactory.external((String)"comp1", (DisplayerSettings)settings))});
        Dashboard dashboard = DashboardFactory.dashboard(Arrays.asList(page), (Path)this.componentsPath);
        List results = this.impl.validate(dashboard);
        Assert.assertEquals((long)1L, (long)results.size());
        Assert.assertEquals((Object)"No missing component dependencies for page abc", (Object)((ValidationResult)results.get(0)).getMessage());
    }

    @Test
    public void testMissingNavigationItem() {
        Page page = PageFactory.page((String)"page", (Row[])new Row[0]);
        Page page2 = PageFactory.page((String)"page2", (Row[])new Row[0]);
        Dashboard dashboard = DashboardFactory.dashboard(Arrays.asList(page), (Navigation)NavigationFactory.navigation((NavigationGroup[])new NavigationGroup[]{NavigationFactory.group((String)"test", (NavigationItem[])new NavigationItem[]{NavigationFactory.item((Page)page2)})}));
        List results = this.impl.validate(dashboard);
        ValidationResult result = (ValidationResult)results.get(0);
        Assert.assertEquals((long)1L, (long)results.size());
        Assert.assertEquals((Object)"Navigation item page2 has no corresponding page", (Object)result.getMessage());
        Assert.assertEquals((Object)ValidationResult.ValidationResultType.ERROR, (Object)result.getType());
    }

    @Test
    public void testNavigationWithMissingGroup() {
        Page page = PageFactory.page((String)"page", (Row[])new Row[0]);
        Dashboard dashboard = DashboardFactory.dashboard(Arrays.asList(page), (Navigation)NavigationFactory.navigation((NavigationGroup[])new NavigationGroup[]{NavigationFactory.group((String)"test", (NavigationItem[])new NavigationItem[]{NavigationFactory.item((Page)page)}), NavigationFactory.group((String)"test", (NavigationItem[])new NavigationItem[]{NavigationFactory.item((Page)page)})}));
        List results = this.impl.validate(dashboard);
        ValidationResult result = (ValidationResult)results.get(0);
        Assert.assertEquals((long)1L, (long)results.size());
        Assert.assertEquals((Object)"The Navigation constains duplicate group names", (Object)result.getMessage());
        Assert.assertEquals((Object)ValidationResult.ValidationResultType.ERROR, (Object)result.getType());
    }

    @Test
    public void testNavigationCorrect() {
        Page page = PageFactory.page((String)"page", (Row[])new Row[0]);
        Dashboard dashboard = DashboardFactory.dashboard(Arrays.asList(page), (Navigation)NavigationFactory.navigation((NavigationGroup[])new NavigationGroup[]{NavigationFactory.group((String)"test", (NavigationItem[])new NavigationItem[]{NavigationFactory.item((Page)page)})}));
        List results = this.impl.validate(dashboard);
        ValidationResult result = (ValidationResult)results.get(0);
        Assert.assertEquals((long)1L, (long)results.size());
        Assert.assertEquals((Object)"Navigation is valid", (Object)result.getMessage());
        Assert.assertEquals((Object)ValidationResult.ValidationResultType.SUCCESS, (Object)result.getType());
    }

    @Test
    public void testSuccessfulValidation() {
        DataSetDef def = ((StaticDataSetDefBuilderImpl)DataSetDefFactory.newStaticDataSetDef().uuid("myds")).buildDef();
        DisplayerSettings settings = ((AreaChartSettingsBuilderImpl)((AreaChartSettingsBuilderImpl)DisplayerSettingsFactory.newAreaChartSettings().subType_Area()).dataset(def.getUUID())).buildSettings();
        DisplayerSettings externalSettings = DisplayerSettingsFactory.newExternalDisplayerSettings().buildSettings();
        Page page = PageFactory.page((String)"abc", (Row[])new Row[]{PageFactory.row((Component)ComponentFactory.external((String)"comp1", (DisplayerSettings)externalSettings)), PageFactory.row((Component)ComponentFactory.displayer((DisplayerSettings)settings))});
        Dashboard dashboard = DashboardFactory.dashboard(Arrays.asList(page), Arrays.asList(def), (Navigation)NavigationFactory.navigation((NavigationGroup[])new NavigationGroup[]{NavigationFactory.group((String)"test", (NavigationItem[])new NavigationItem[]{NavigationFactory.item((Page)page)})}), (Path)this.componentsPath);
        List results = this.impl.validate(dashboard);
        Assert.assertEquals((long)3L, (long)results.size());
        Assert.assertTrue((boolean)results.stream().allMatch(r -> r.type == ValidationResult.ValidationResultType.SUCCESS));
    }
}

