/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.dsl.serialization.impl;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import javax.ws.rs.NotSupportedException;
import org.dashbuilder.dataprovider.DataSetProviderRegistry;
import org.dashbuilder.dataset.def.CSVDataSetDef;
import org.dashbuilder.dataset.def.DataSetDef;
import org.dashbuilder.dataset.json.DataSetDefJSONMarshaller;
import org.dashbuilder.dsl.factory.dashboard.DashboardFactory;
import org.dashbuilder.dsl.factory.navigation.NavigationFactory;
import org.dashbuilder.dsl.helper.ComponentsHelper;
import org.dashbuilder.dsl.model.Dashboard;
import org.dashbuilder.dsl.model.Navigation;
import org.dashbuilder.dsl.model.Page;
import org.dashbuilder.dsl.serialization.DashboardSerializer;
import org.dashbuilder.dsl.serialization.impl.InternalDataSetProviderRegistry;
import org.dashbuilder.external.model.ExternalComponent;
import org.dashbuilder.navigation.json.NavTreeJSONMarshaller;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.ext.layout.editor.api.editor.LayoutTemplate;

public class DashboardZipSerializer
implements DashboardSerializer {
    private static final String PATH_SEPARATOR = "/";
    Logger logger = LoggerFactory.getLogger(DashboardZipSerializer.class);
    private static int MAX_ENTRIES = 10000;
    private static final String CSV_EXT = ".csv";
    private static final String DATASET_EXT = ".dset";
    private static final String PLUGIN_EXT = ".plugin";
    private static final String PERSPECTIVE_LAYOUT = "perspective_layout";
    private static final String BASE_PATH = "dashbuilder/";
    private static final String LAYOUTS_PATH = "dashbuilder/perspectives/";
    private static final String DATA_SETS_BASE = "dashbuilder/datasets/";
    private static final String COMPONENTS_BASE = "dashbuilder/components/";
    private static final String DATA_SETS_PATH = "dashbuilder/datasets/definitions/";
    private static final String NAVIGATION_PATH = "dashbuilder/navigation/navigation/navtree.json";
    private static final DataSetDefJSONMarshaller DATA_SET_MARSHALLER = new DataSetDefJSONMarshaller((DataSetProviderRegistry)new InternalDataSetProviderRegistry());
    private static final Gson gson = new GsonBuilder().create();

    @Override
    public Dashboard deserialize(InputStream model) {
        throw new NotSupportedException("Deserialize is not supported for ZIP Serializer");
    }

    Dashboard internalDeserialize(InputStream model) {
        Map<String, String> importContent = this.readAllEntriesContent(model);
        ArrayList<Page> pages = new ArrayList<Page>();
        ArrayList<DataSetDef> datasets = new ArrayList<DataSetDef>();
        AtomicReference<Navigation> navigationRef = new AtomicReference<Navigation>(NavigationFactory.emptyNavigation());
        importContent.forEach((path, content) -> {
            if (path.startsWith(LAYOUTS_PATH) && path.endsWith(PERSPECTIVE_LAYOUT)) {
                LayoutTemplate template = (LayoutTemplate)gson.fromJson(content, LayoutTemplate.class);
                pages.add(Page.create(template));
            }
            if (path.startsWith(DATA_SETS_PATH) && path.endsWith(DATASET_EXT)) {
                try {
                    DataSetDef def = DATA_SET_MARSHALLER.fromJson(content);
                    datasets.add(def);
                }
                catch (Exception e) {
                    this.logger.warn("Error reading dataset content {}", path);
                    this.logger.debug("Error reading dataset content.", (Throwable)e);
                }
            }
            if (path.startsWith(NAVIGATION_PATH)) {
                navigationRef.set(Navigation.of(NavTreeJSONMarshaller.get().fromJson(content)));
            }
        });
        return DashboardFactory.dashboard(pages, datasets, navigationRef.get(), null);
    }

    @Override
    public void serialize(Dashboard dashboard, OutputStream os) {
        ZipOutputStream zos = new ZipOutputStream(os);
        dashboard.getDataSets().stream().forEach(def -> this.writeDataSetDef(zos, (DataSetDef)def));
        dashboard.getPages().stream().forEach(page -> this.writePage(zos, (Page)page));
        dashboard.getDataSets().stream().filter(CSVDataSetDef.class::isInstance).map(CSVDataSetDef.class::cast).forEach(def -> this.writeCSVFile(zos, (CSVDataSetDef)def));
        this.writeNavigation(zos, dashboard.getNavigation());
        this.writeContent(zos, "dashbuilder/datasets/readme.md", "");
        Optional<Path> componentsPathOp = dashboard.getComponentsPath();
        if (componentsPathOp.isPresent()) {
            Path componentsPath = componentsPathOp.get();
            List<ExternalComponent> components = ComponentsHelper.listComponents(componentsPath);
            ComponentsHelper.listPagesComponents(dashboard.getPages()).stream().filter(c -> components.stream().anyMatch(comp -> comp.getId().equals(c))).forEach(c -> this.writeComponent(componentsPath, (String)c, zos));
        }
        try {
            zos.close();
        }
        catch (IOException e) {
            throw new RuntimeException("Error closing ZIP", e);
        }
    }

    private void writeCSVFile(ZipOutputStream zos, CSVDataSetDef def) {
        Path path;
        String filePath = def.getFilePath();
        if (filePath != null && (path = Paths.get(filePath, new String[0])).toFile().exists()) {
            try {
                this.writeContent(zos, DATA_SETS_PATH + def.getUUID() + CSV_EXT, Files.readAllBytes(path));
            }
            catch (IOException e) {
                this.logger.warn("Not able to write CSV file {} to the exported ZIP", (Object)filePath);
                this.logger.debug("Not able to write CSV", (Throwable)e);
            }
        }
    }

    private void writeComponent(Path componentsPath, String componentId, ZipOutputStream zos) {
        Path componentPath = componentsPath.resolve(componentId);
        String componentZipPathBase = COMPONENTS_BASE + componentId + PATH_SEPARATOR;
        try (Stream<Path> walker = Files.walk(componentPath, 1, new FileVisitOption[0]);){
            walker.filter(p -> !p.toFile().isDirectory()).forEach(file -> {
                String fileName = componentZipPathBase + file.toFile().getName();
                this.writeContent(zos, fileName, (Path)file);
            });
        }
        catch (IOException e) {
            this.logger.debug("Error loading external component files.", (Throwable)e);
            throw new RuntimeException("Error loading components from " + componentsPath + ". Error: " + e.getMessage());
        }
    }

    private void writeNavigation(ZipOutputStream zos, Navigation navigation) {
        String content = NavTreeJSONMarshaller.get().toJson(navigation.getNavTree()).toString();
        this.writeContent(zos, NAVIGATION_PATH, content);
    }

    private void writePage(ZipOutputStream zos, Page page) {
        LayoutTemplate lt = page.getLayoutTemplate();
        String path = LAYOUTS_PATH + lt.getName() + PATH_SEPARATOR + PERSPECTIVE_LAYOUT;
        String pluginPath = path + PLUGIN_EXT;
        String content = gson.toJson((Object)lt);
        this.writeContent(zos, path, content);
        this.writeContent(zos, pluginPath, new Date().toString());
    }

    private void writeDataSetDef(ZipOutputStream zos, DataSetDef def) {
        String path = DATA_SETS_PATH + def.getUUID() + DATASET_EXT;
        String content = DATA_SET_MARSHALLER.toJsonString(def);
        this.writeContent(zos, path, content);
    }

    private void writeContent(ZipOutputStream zos, String path, byte[] content) {
        try {
            zos.putNextEntry(new ZipEntry(path));
            zos.write(content);
            zos.closeEntry();
        }
        catch (IOException e) {
            this.logger.warn("Error writing content on path {}", (Object)path);
            this.logger.debug("Error writing content. ", (Throwable)e);
        }
    }

    private void writeContent(ZipOutputStream zos, String path, String content) {
        this.writeContent(zos, path, content.getBytes());
    }

    private void writeContent(ZipOutputStream zos, String path, Path file) {
        try {
            this.writeContent(zos, path, Files.readAllBytes(file));
        }
        catch (IOException e) {
            this.logger.info("Error reading component file {}: {}", (Object)file, (Object)e.getMessage());
            this.logger.debug("Error reading component file", (Throwable)e);
        }
    }

    Map<String, String> readAllEntriesContent(InputStream model) {
        Path zipTemp;
        HashMap<String, String> entriesContent = new HashMap<String, String>();
        try {
            zipTemp = Files.createTempFile("dashboard", "zip", new FileAttribute[0]);
            Files.copy(model, zipTemp, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            throw new RuntimeException("Error creating temp file", e);
        }
        try (ZipFile zipFile = new ZipFile(zipTemp.toFile());){
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            int totalEntries = 0;
            while (entries.hasMoreElements()) {
                if (++totalEntries > MAX_ENTRIES) {
                    throw new IllegalArgumentException("ZIP file contains too many entries");
                }
                ZipEntry e = entries.nextElement();
                String content = new BufferedReader(new InputStreamReader(zipFile.getInputStream(e), StandardCharsets.UTF_8)).lines().collect(Collectors.joining("\n"));
                entriesContent.put(e.getName(), content);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Error reading input file", e);
        }
        try {
            Files.delete(zipTemp);
        }
        catch (IOException e) {
            this.logger.error("Temp file not deleted due an error", (Throwable)e);
        }
        return entriesContent;
    }
}

