/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.dsl.factory.component;

import org.dashbuilder.displayer.DisplayerSettings;
import org.dashbuilder.displayer.DisplayerSettingsFactory;
import org.dashbuilder.dsl.factory.component.ComponentFactory;
import org.dashbuilder.dsl.model.Component;
import org.junit.Assert;
import org.junit.Test;

public class ComponentFactoryTest {
    @Test
    public void testExternal() {
        Component external = ComponentFactory.external((String)"test");
        Assert.assertEquals((Object)"test", external.getLayoutComponent().getProperties().get("componentId"));
    }

    @Test
    public void testHtml() {
        Component html = ComponentFactory.html((String)"test");
        Assert.assertEquals((Object)"test", html.getLayoutComponent().getProperties().get("HTML_CODE"));
    }

    @Test
    public void testLogo() {
        Component logo = ComponentFactory.logo((String)"src");
        Assert.assertEquals((Object)"logo-provided", logo.getLayoutComponent().getProperties().get("componentId"));
        Assert.assertEquals((Object)"src", logo.getLayoutComponent().getProperties().get("logo-provided.src"));
    }

    @Test
    public void testHeatmap() {
        DisplayerSettings settings = DisplayerSettingsFactory.newExternalDisplayerSettings().buildSettings();
        Component heatmap = ComponentFactory.processHeatmap((String)"server", (String)"container", (String)"process", (DisplayerSettings)settings);
        Assert.assertEquals((Object)"process-heatmap-provided", heatmap.getLayoutComponent().getProperties().get("componentId"));
        Assert.assertEquals((Object)"server", (Object)settings.getComponentProperty("serverTemplate"));
        Assert.assertEquals((Object)"container", (Object)settings.getComponentProperty("containerId"));
        Assert.assertEquals((Object)"process", (Object)settings.getComponentProperty("processId"));
    }

    @Test
    public void testAllProcessesHeatmap() {
        DisplayerSettings settings = DisplayerSettingsFactory.newExternalDisplayerSettings().buildSettings();
        Component allProcessHeatmap = ComponentFactory.allProcessesHeatmap((String)"server", (DisplayerSettings)settings);
        Assert.assertEquals((Object)"processes-heatmaps-provided", allProcessHeatmap.getLayoutComponent().getProperties().get("componentId"));
        Assert.assertEquals((Object)"server", (Object)settings.getComponentProperty("serverTemplate"));
    }
}

