/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.dsl.factory.component;

import org.dashbuilder.displayer.DisplayerSettings;
import org.dashbuilder.displayer.json.DisplayerSettingsJSONMarshaller;
import org.dashbuilder.dsl.factory.component.AbstractComponentBuilder;
import org.dashbuilder.dsl.model.Component;

public class DisplayerBuilder
extends AbstractComponentBuilder<DisplayerBuilder> {
    private static final String JSON_PROP = "json";
    DisplayerSettings settings;

    DisplayerBuilder(DisplayerSettings settings) {
        this.settings = settings;
    }

    public static DisplayerBuilder create(DisplayerSettings settings) {
        if (DisplayerBuilder.isInvalid(settings)) {
            throw new IllegalArgumentException("You must provide a data set or an UUID to build a displayer component");
        }
        return new DisplayerBuilder(settings);
    }

    @Override
    public Component build() {
        this.property(JSON_PROP, DisplayerSettingsJSONMarshaller.get().toJsonString(this.settings));
        return super.build();
    }

    @Override
    String getDragType() {
        return "org.dashbuilder.client.editor.DisplayerDragComponent";
    }

    private static boolean isInvalid(DisplayerSettings settings) {
        String dataSetUUID = settings.getDataSetLookup().getDataSetUUID();
        return (dataSetUUID == null || dataSetUUID.trim().isEmpty()) && settings.getDataSet() == null;
    }
}

