/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.dsl.helper;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.dashbuilder.dsl.model.Dashboard;
import org.dashbuilder.dsl.model.Page;
import org.dashbuilder.external.model.ExternalComponent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.ext.layout.editor.api.editor.LayoutComponent;
import org.uberfire.ext.layout.editor.api.editor.LayoutRow;
import org.uberfire.ext.layout.editor.api.editor.LayoutTemplate;

public class ComponentsHelper {
    private static final Logger logger = LoggerFactory.getLogger(ComponentsHelper.class);
    private static final Gson gson = new GsonBuilder().create();

    private ComponentsHelper() {
    }

    public static List<String> listComponentsIds(Dashboard dashboard) {
        Optional<Path> componentsPath = dashboard.getComponentsPath();
        if (!componentsPath.isPresent()) {
            return Collections.emptyList();
        }
        return ComponentsHelper.listComponents(componentsPath.get()).stream().map(ExternalComponent::getId).collect(Collectors.toList());
    }

    public static List<ExternalComponent> listComponents(Path componentsPath) {
        List<ExternalComponent> list;
        block8: {
            Stream<Path> walker = Files.walk(componentsPath, 1, new FileVisitOption[0]);
            try {
                list = walker.filter(p -> p.toFile().isDirectory()).map(p -> Paths.get(p.toString(), "manifest.json")).filter(f -> f.toFile().exists()).map(ComponentsHelper::readComponent).filter(Objects::nonNull).collect(Collectors.toList());
                if (walker == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (walker != null) {
                        try {
                            walker.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    logger.debug("Error loading external components.", (Throwable)e);
                    throw new RuntimeException("Error loading components from " + componentsPath + ". Error: " + e.getMessage(), e);
                }
            }
            walker.close();
        }
        return list;
    }

    public static List<String> listPagesComponents(List<Page> pages) {
        return pages.stream().map(Page::getLayoutTemplate).map(LayoutTemplate::getRows).flatMap(ComponentsHelper::allLayoutComponentsStream).map(lt -> (String)lt.getProperties().get("componentId")).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public static Stream<String> collectingPropertyValue(Page page, String propertyId) {
        return ComponentsHelper.allLayoutComponentsStream(page.getLayoutTemplate().getRows()).map(lc -> (String)lc.getProperties().get(propertyId)).filter(Objects::nonNull);
    }

    private static Stream<LayoutComponent> allLayoutComponentsStream(List<LayoutRow> row) {
        return row.stream().flatMap(r -> r.getLayoutColumns().stream()).flatMap(cl -> Stream.concat(cl.getLayoutComponents().stream(), ComponentsHelper.allLayoutComponentsStream(cl.getRows())));
    }

    private static ExternalComponent readComponent(Path file) {
        String id = file.getParent().toFile().getName();
        try {
            ExternalComponent component = (ExternalComponent)gson.fromJson((Reader)new FileReader(file.toFile()), ExternalComponent.class);
            component.setId(id);
            return component;
        }
        catch (FileNotFoundException e) {
            logger.error("Not able to read component manifest file {}. Error: {}", (Object)file, (Object)e.getMessage());
            logger.debug("Error reading component file.", (Throwable)e);
            return null;
        }
    }
}

