/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.external.impl;

import com.google.gson.Gson;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import org.dashbuilder.external.model.ExternalComponent;
import org.dashbuilder.external.service.ExternalComponentLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class ExternalComponentLoaderImpl
implements ExternalComponentLoader {
    Logger logger = LoggerFactory.getLogger(ExternalComponentLoaderImpl.class);
    public static final String EXTERNAL_COMP_DIR_PROP = "dashbuilder.components.dir";
    public static final String EXTERNAL_COMP_ENABLE_PROP = "dashbuilder.components.enable";
    public static final String DESCRIPTOR_FILE = "manifest.json";
    private static final String DEFAULT_COMPONENTS_PATH = "/tmp/dashbuilder/components/";
    private String externalComponentsDir;
    private Gson gson;
    private boolean isExternalComponentEnabled;

    @PostConstruct
    public void init() {
        Path baseDirPath;
        this.gson = new Gson();
        this.isExternalComponentEnabled = Boolean.parseBoolean(System.getProperty(EXTERNAL_COMP_ENABLE_PROP, Boolean.FALSE.toString()));
        this.externalComponentsDir = System.getProperty(EXTERNAL_COMP_DIR_PROP, DEFAULT_COMPONENTS_PATH);
        if (this.isExternalComponentEnabled && !(baseDirPath = Paths.get(this.externalComponentsDir, new String[0])).toFile().exists()) {
            baseDirPath.toFile().mkdirs();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<ExternalComponent> load() {
        if (!this.isExternalComponentEnabled) {
            return Collections.emptyList();
        }
        try (Stream<Path> walker = Files.walk(Paths.get(this.externalComponentsDir, new String[0]), 1, new FileVisitOption[0]);){
            List<ExternalComponent> list = walker.filter(p -> p.toFile().isDirectory()).map(this::getComponentDescriptor).filter(File::exists).map(this::readComponent).filter(Objects::nonNull).collect(Collectors.toList());
            return list;
        }
        catch (IOException e) {
            this.logger.error("Error loading components from {}. Error: {}", (Object)this.externalComponentsDir, (Object)e.getMessage());
            this.logger.debug("Error loading external components.", (Throwable)e);
            return Collections.emptyList();
        }
    }

    public String getExternalComponentsDir() {
        return this.externalComponentsDir;
    }

    private ExternalComponent readComponent(File componentDescriptor) {
        try {
            String componentId = componentDescriptor.getParentFile().getName();
            ExternalComponent component = (ExternalComponent)this.gson.fromJson((Reader)new FileReader(componentDescriptor), ExternalComponent.class);
            component.setId(componentId);
            return component;
        }
        catch (Exception e) {
            this.logger.error("Not able to load component {}. Error: {}", (Object)componentDescriptor, (Object)e.getMessage());
            this.logger.debug("Error reading component.", (Throwable)e);
            return null;
        }
    }

    private File getComponentDescriptor(Path p) {
        return Paths.get(p.toString(), DESCRIPTOR_FILE).toFile();
    }

    public boolean isEnabled() {
        return this.isExternalComponentEnabled;
    }
}

