/*
 * Decompiled with CFR 0.152.
 */
package org.dashbuilder.external.impl;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Optional;
import org.dashbuilder.external.impl.ComponentLoaderImpl;
import org.dashbuilder.external.model.ComponentParameter;
import org.dashbuilder.external.model.ExternalComponent;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.lesscss.deps.org.apache.commons.io.FileUtils;

public class ComponentLoaderImplTest {
    private static final String C1_ID = "c1_id";
    private static final String C2_ID = "c2_id";
    private static final String TEXT = "text";
    private static final String C2P1_LABEL = "c2p1 label";
    private static final String C2P1_DEFAULT = "c2p1 default";
    private static final String C2P1 = "c2p1";
    private static final String C2_ICON = "c2 icon";
    private static final String C2 = "c2";
    private static final String C1P1_LABEL = "c1p1 label";
    private static final String C1P1_DEFAULT = "c1p1 default";
    private static final String C1P1 = "c1p1";
    private static final String C1_ICON = "c1 icon";
    private static final String C1 = "c1";
    final String C1_MANIFEST = "{\n    \"name\": \"c1\",\n    \"icon\": \"c1 icon\",\n    \"parameters\": [\n        {\n            \"name\": \"c1p1\",\n            \"type\": \"text\",\n            \"defaultValue\": \"c1p1 default\",\n            \"label\": \"c1p1 label\"\n        }\n\n    ]\n}";
    final String C2_MANIFEST = "{\n    \"name\": \"c2\",\n    \"icon\": \"c2 icon\",\n    \"parameters\": [\n        {\n            \"name\": \"c2p1\",\n            \"type\": \"text\",\n            \"defaultValue\": \"c2p1 default\",\n            \"label\": \"c2p1 label\"\n        }\n\n    ]\n}";
    private Path componentPath;
    ComponentLoaderImpl externalComponentLoaderImpl;

    @Before
    public void init() throws URISyntaxException {
        String rootPath = ComponentLoaderImplTest.class.getResource("/").getFile();
        this.externalComponentLoaderImpl = new ComponentLoaderImpl();
        this.componentPath = Paths.get(rootPath, "components");
        System.setProperty("dashbuilder.components.dir", this.componentPath.toString());
        System.setProperty("dashbuilder.components.enable", Boolean.TRUE.toString());
    }

    @After
    public void cleanup() throws IOException {
        FileUtils.deleteQuietly((File)this.componentPath.toFile());
    }

    @Test
    public void testBaseDirCreated() {
        Assert.assertFalse((boolean)Files.exists(this.componentPath, new LinkOption[0]));
        this.externalComponentLoaderImpl.init();
        Assert.assertTrue((boolean)Files.exists(this.componentPath, new LinkOption[0]));
    }

    @Test
    public void testLoad() {
        this.externalComponentLoaderImpl.init();
        this.createComponentsFiles();
        List components = this.externalComponentLoaderImpl.loadExternal();
        Assert.assertEquals((long)2L, (long)components.size());
        ExternalComponent c1 = this.getComponent(components, C1_ID);
        ExternalComponent c2 = this.getComponent(components, C2_ID);
        Assert.assertEquals((long)1L, (long)c1.getParameters().size());
        Assert.assertEquals((Object)C1, (Object)c1.getName());
        Assert.assertEquals((Object)C1_ICON, (Object)c1.getIcon());
        ComponentParameter cp1 = (ComponentParameter)c1.getParameters().get(0);
        Assert.assertEquals((Object)C1P1, (Object)cp1.getName());
        Assert.assertEquals((Object)C1P1_DEFAULT, (Object)cp1.getDefaultValue());
        Assert.assertEquals((Object)C1P1_LABEL, (Object)cp1.getLabel());
        Assert.assertEquals((long)1L, (long)c2.getParameters().size());
        Assert.assertEquals((Object)C2, (Object)c2.getName());
        Assert.assertEquals((Object)C2_ICON, (Object)c2.getIcon());
        ComponentParameter cp2 = (ComponentParameter)c2.getParameters().get(0);
        Assert.assertEquals((Object)C2P1, (Object)cp2.getName());
        Assert.assertEquals((Object)C2P1_DEFAULT, (Object)cp2.getDefaultValue());
        Assert.assertEquals((Object)C2P1_LABEL, (Object)cp2.getLabel());
    }

    @Test
    public void testLoadWhenDisabled() throws IOException {
        System.setProperty("dashbuilder.components.enable", Boolean.FALSE.toString());
        this.externalComponentLoaderImpl.init();
        Assert.assertFalse((boolean)Files.exists(this.componentPath, new LinkOption[0]));
        Files.createDirectory(this.componentPath, new FileAttribute[0]);
        this.createComponentsFiles();
        Assert.assertTrue((boolean)this.externalComponentLoaderImpl.loadExternal().isEmpty());
    }

    @Test
    public void testLoadInternalComponents() throws IOException {
        this.externalComponentLoaderImpl.init();
        List internalComponents = this.externalComponentLoaderImpl.loadProvided();
        Assert.assertEquals((long)1L, (long)internalComponents.size());
        ExternalComponent component = (ExternalComponent)internalComponents.get(0);
        Assert.assertEquals((Object)"logo-provided", (Object)component.getId());
        List parameters = component.getParameters();
        Assert.assertEquals((long)3L, (long)parameters.size());
        Optional<ComponentParameter> srcParamOp = component.getParameters().stream().filter(p -> p.getName().equals("src")).findFirst();
        Assert.assertTrue((boolean)srcParamOp.isPresent());
        ComponentParameter srcParam = srcParamOp.get();
        Assert.assertEquals((Object)"src", (Object)srcParam.getName());
        Assert.assertEquals((Object)"Logo URL", (Object)srcParam.getLabel());
        Assert.assertEquals((Object)TEXT, (Object)srcParam.getType());
        Optional<ComponentParameter> widthParamOp = component.getParameters().stream().filter(p -> p.getName().equals("width")).findFirst();
        Assert.assertTrue((boolean)widthParamOp.isPresent());
        ComponentParameter widthParam = widthParamOp.get();
        Assert.assertEquals((Object)"width", (Object)widthParam.getName());
        Assert.assertEquals((Object)"Width", (Object)widthParam.getLabel());
        Assert.assertEquals((Object)TEXT, (Object)widthParam.getType());
        Optional<ComponentParameter> heightParamOp = component.getParameters().stream().filter(p -> p.getName().equals("height")).findFirst();
        Assert.assertTrue((boolean)heightParamOp.isPresent());
        ComponentParameter heightParam = heightParamOp.get();
        Assert.assertEquals((Object)"height", (Object)heightParam.getName());
        Assert.assertEquals((Object)"Height", (Object)heightParam.getLabel());
        Assert.assertEquals((Object)TEXT, (Object)heightParam.getType());
    }

    private ExternalComponent getComponent(List<ExternalComponent> components, String id) {
        return components.stream().filter(c -> c.getId().equals(id)).findFirst().get();
    }

    private void createComponentsFiles() {
        try {
            Path c1 = Paths.get(this.componentPath.toString(), C1_ID, "manifest.json");
            c1.toFile().getParentFile().mkdirs();
            c1.toFile().createNewFile();
            Files.write(c1, "{\n    \"name\": \"c1\",\n    \"icon\": \"c1 icon\",\n    \"parameters\": [\n        {\n            \"name\": \"c1p1\",\n            \"type\": \"text\",\n            \"defaultValue\": \"c1p1 default\",\n            \"label\": \"c1p1 label\"\n        }\n\n    ]\n}".getBytes(), new OpenOption[0]);
            Path c2 = Paths.get(this.componentPath.toString(), C2_ID, "manifest.json");
            c2.toFile().getParentFile().mkdirs();
            c2.toFile().createNewFile();
            Files.write(c2, "{\n    \"name\": \"c2\",\n    \"icon\": \"c2 icon\",\n    \"parameters\": [\n        {\n            \"name\": \"c2p1\",\n            \"type\": \"text\",\n            \"defaultValue\": \"c2p1 default\",\n            \"label\": \"c2p1 label\"\n        }\n\n    ]\n}".getBytes(), new OpenOption[0]);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

